<?php
get_header();
get_template_part( 'partials/banner/banner-blog' );
global $post;
?>
	<div class="container">
		<div class="wrapper-page-contents">
			<div class="row">
				<div class="col-md-8">
					<div class="content-area">
						<?php
						if ( have_posts() ):
							while ( have_posts() ):
								the_post();
								?>
								<article id="post-<?php the_ID(); ?>" <?php post_class( "single-post-bp" ); ?>>
									<?php
									if ( has_post_thumbnail() ) {
										?>
										<div class="the-post-thumbnail">
											<a data-imagelightbox="lightbox"
											   href="<?php echo get_the_post_thumbnail_url(); ?>"><?php the_post_thumbnail(); ?></a>
										</div>
										<?php
									}
									?>
									<h1 class="psost-heading-single"><?php the_title(); ?></h1>
									<div class="post-meta">
										<span class="author"><?php the_author(); ?></span>
										<span class="date"><time
												datetime="<?php the_time( 'c' ); ?>"><?php the_time( 'F j, Y' ); ?></time></span>
										<a class="comments" href="<?php comments_link(); ?>">
											<span
												class="post-count"><?php comments_number( esc_html__( '0 Comment', 'inspiry-builderpress' ), esc_html__( '1 Comment', 'inspiry-builderpress' ), esc_html__( '% Comments', 'inspiry-builderpress' ) ); ?></span>
										</a>
									</div>
									<div class="the-content-wrapper">
										<?php the_content(); ?>
									</div>
									<div class="post-tags">
										<?php the_tags( '<span class="tag-links">', '', '</span>' ); ?>
									</div>
								</article>
								<?php
							endwhile;

							wp_link_pages( array(
								'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'inspiry-builderpress' ),
								'after'  => '</div>',
							) );

						endif;

						$the_author_description = get_the_author_meta( 'description' );
						if ( ! empty( $the_author_description ) ) {
							?>
							<div class="author-detail-wrapper">
								<h2><?php esc_html_e( 'About Author', 'inspiry-builderpress' ) ?></h2>
								<div class="author-detail">
									<div class="row">
										<div class="col-sm-3">
											<a class="author-thumbnail"
											   href="<?php echo esc_url( get_author_posts_url( $post->post_author ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'ID' ), 165 ); ?></a>
										</div>
										<div class="col-sm-9">
											<div class="name-social-wrapper">
												<!--author link-->
												<h3><?php the_author_posts_link(); ?></h3>

												<!--author social profiles-->
												<?php
												$inspiry_user_link_facebook  = get_the_author_meta( 'inspiry_facebook_url', $post->post_author );
												$inspiry_user_link_twitter   = get_the_author_meta( 'inspiry_twitter_url', $post->post_author );
												$inspiry_user_link_google    = get_the_author_meta( 'inspiry_google_url', $post->post_author );
												$inspiry_user_link_instagram = get_the_author_meta( 'inspiry_instagram_url', $post->post_author );
												$inspiry_user_link_youtube   = get_the_author_meta( 'inspiry_youtube_url', $post->post_author );

												if ( ! empty( $inspiry_user_link_twitter ) ||
												     ! empty( $inspiry_user_link_facebook ) ||
												     ! empty( $inspiry_user_link_google ) ||
												     ! empty( $inspiry_user_link_youtube ) ||
												     ! empty( $inspiry_user_link_instagram )

												) {
													?>
													<ul>
														<?php
														if ( ! empty( $inspiry_user_link_twitter ) ) {
															?>
															<li>
																<a target="_blank"
																   href="<?php echo esc_url( $inspiry_user_link_twitter ); ?>"><i
																		class="fa fa-twitter"></i></a>
															</li>
															<?php
														}

														if ( ! empty( $inspiry_user_link_facebook ) ) {
															?>
															<li>
																<a target="_blank"
																   href="<?php echo esc_url( $inspiry_user_link_facebook ); ?>"><i
																		class="fa fa-facebook-square"></i></a>
															</li>
															<?php
														}

														if ( ! empty( $inspiry_user_link_google ) ) {
															?>
															<li>
																<a target="_blank"
																   href="<?php echo esc_url( $inspiry_user_link_google ); ?>"><i
																		class="fa fa-google-plus"></i></a>
															</li>
															<?php
														}

														if ( ! empty( $inspiry_user_link_youtube ) ) {
															?>
															<li>
																<a target="_blank"
																   href="<?php echo esc_url( $inspiry_user_link_youtube ); ?>"><i
																		class="fa fa-youtube-play"></i></a>
															</li>
															<?php
														}

														if ( ! empty( $inspiry_user_link_instagram ) ) {
															?>
															<li>
																<a target="_blank"
																   href="<?php echo esc_url( $inspiry_user_link_instagram ); ?>"><i
																		class="fa fa-instagram"></i></a>
															</li>
															<?php
														}
														?>
													</ul>
													<?php
												}
												?>
											</div>

											<p><?php echo esc_html($the_author_description); ?></p>

											<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"
											   class="view-all bp-lined"><?php esc_html_e( 'View All Posts', 'inspiry-builderpress' ); ?></a>

										</div>
									</div>
								</div>
							</div>

							<?php
						}
						comments_template();
						?>


					</div>

				</div>

				<div class="col-md-4">
					<?php get_sidebar(); ?>
				</div>

			</div>
		</div>
	</div>

<?php get_footer() ?>