<?php
if ( ! class_exists( 'inspiry_recent_posts_with_thumbnails' ) ) {
	class inspiry_recent_posts_with_thumbnails extends WP_Widget {
		public function __construct() {
			$widget_ops = array(
				'classname'   => 'inspiry_recent_posts_with_thumbnails',
				'description' => esc_html__( 'Custom Post Type - Recent posts with thumbnails.', 'inspiry-builderpress' )
			);
			parent::__construct( 'inspiry_recent_posts_with_thumbnails', esc_html__( 'BuilderPress - Recent Posts With Thumbnails', 'inspiry-builderpress' ), $widget_ops );
		}


		public function widget( $args, $instance ) {

			if ( ! isset( $args['widget_id'] ) ) {
				$args['widget_id'] = $this->id;
			}

			$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : esc_html__( 'Recent Posts', 'inspiry-builderpress' );

			/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
			$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

			$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
			if ( ! $number ) {
				$number = 5;
			}

			$posttype = $instance['posttype'];
			$post_types = get_post_types( array( 'public' => true), 'objects' );
			if ( array_key_exists( $posttype, (array) $post_types ) ) {

				$r = new WP_Query( apply_filters( 'widget_posts_args', array(
					'post_type'           => $posttype,
					'posts_per_page'      => $number,
					'no_found_rows'       => true,
					'post_status'         => 'publish',
					'ignore_sticky_posts' => true
				) ) );

				if ( $r->have_posts() ) :
					?>
					<?php echo ( $args['before_widget'] ); ?>
					<?php if ( $title ) {
					echo ( $args['before_title'] . esc_html( $title ) . $args['after_title'] );
				} ?>
					<ul>
						<?php while ( $r->have_posts() ) : $r->the_post(); ?>
							<li>
								<?php if ( has_post_thumbnail() ) { ?>
									<a class="widget-thumb"
									   href="<?php the_permalink(); ?>"><?php the_post_thumbnail( array(
											150,
											150
										) ); ?></a>
								<?php } ?>
								<a class="list-heading" href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a>
							</li>
						<?php endwhile; ?>
					</ul>
					<?php echo ( $args['after_widget'] ); ?>
					<?php
					// Reset the global $the_post as this query will have stomped on it
					wp_reset_postdata();

				endif;

			}

		}

		public function form( $instance ) {
			$title    = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
			$number   = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
			$posttype = isset( $instance['posttype'] ) ? $instance['posttype'] : 'post';

			$post_types = get_post_types( array( 'public' => true, 'publicly_queryable'=> true  ), 'objects' );

			?>

			<p><label
					for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'inspiry-builderpress' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
				       value="<?php echo esc_attr( $title ); ?>"/></p>
			<?php

			printf(
				'<p><label for="%1$s">%2$s</label>' .
				'<select class="widefat" id="%1$s" name="%3$s">',
				$this->get_field_id( 'posttype' ),
				esc_html__( 'Post Type:', 'inspiry-builderpress' ),
				$this->get_field_name( 'posttype' )
			);

			foreach ( $post_types as $post_type => $value ) {
				if ( 'attachment' === $post_type ) {
					continue;
				}

				printf(
					'<option value="%s"%s>%s</option>',
					esc_attr( $post_type ),
					selected( $post_type, $posttype, false ),
					( $value->label )
				);

			}

			echo '</select>';

			?>



			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of posts to show:', 'inspiry-builderpress' ); ?></label>
				<input class="tiny-text" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number" step="1" min="1"
				       value="<?php echo esc_attr( $number ); ?>" size="3"/></p>


			<?php
		}

		public function update( $new_instance, $old_instance ) {
			$instance             = $old_instance;
			$instance['title']    = sanitize_text_field( $new_instance['title'] );
			$instance['posttype'] = strip_tags( $new_instance['posttype'] );
			$instance['number']   = (int) $new_instance['number'];

			return $instance;
		}


	}


}

