<?php
/**
 * The current version of the theme.
 */
define( 'INSPIRY_THEME_VERSION', '1.0.4' );

//define path for customizer
define( 'INSPIRY_CUSTOMIZER', get_template_directory() . '/inc/customizer/' );

// Widgets Path
define( 'INSPIRY_WIDGETS', get_template_directory() . '/inc/widgets/' );

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 750;
}

if ( ! function_exists( 'inspiry_theme_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since 1.0.0
	 */
	function inspiry_theme_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 */
		load_theme_textdomain( 'inspiry-builderpress', get_template_directory() . '/languages' );

		/* Add default posts and comments RSS feed links to head. */
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Custom Background Support
		 */
		add_theme_support( 'custom-background' );

		/*
		 * Custom Logo
		 */
		add_theme_support( 'custom-logo' );

		/*
		 * WooCommerce Theme Support
		 */
		add_theme_support( 'woocommerce' );

		/*
		 * Let WordPress manage the document title.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 */
		add_theme_support( 'post-thumbnails' );

		/*
		 * Set Post Thumbnail Size
		 */
		set_post_thumbnail_size( 750, 440, true );

		/*
		 * Image Sizes
		 */
		add_image_size( 'inspiry_image_size_1140_760', 1140, 760, true );
		add_image_size( 'inspiry_image_size_720_540', 720, 540, true );
		add_image_size( 'inspiry_image_size_570_525', 570, 525, true );
		add_image_size( 'inspiry_image_size_360_270', 360, 270, true );

		/*
		 * Theme theme uses wp_nav_menu in one location.
		 */
		register_nav_menus( array( 'primary' => esc_html__( 'Header Menu', 'inspiry-builderpress' ) ) );

	}

	add_action( 'after_setup_theme', 'inspiry_theme_setup' );
endif;

/*-----------------------------------------------------------------------------------*/
/*	Include inspiry woocommerce functions
/*-----------------------------------------------------------------------------------*/
require_once( get_template_directory() . '/inc/inspiry-woocommerce-functions.php' );

/*-----------------------------------------------------------------------------------*/
/*	include required plugins
/*-----------------------------------------------------------------------------------*/
require_once( get_template_directory() . '/inc/tgm/inspiry-required-plugins.php' );


/*-----------------------------------------------------------------------------------*/
/*	Add SVG Icons Upload Support
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_bp_mime_types' ) ) {

	function inspiry_bp_mime_types( $mimes ) {
		$mimes['svg'] = 'image/svg+xml';

		return $mimes;
	}

	add_filter( 'upload_mimes', 'inspiry_bp_mime_types' );
}

/*-----------------------------------------------------------------------------------*/
/*	Google Fonts Enqueue URI
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_google_fonts' ) ):

	function inspiry_google_fonts() {

		$fonts_url = '';

		$poppins    = _x( 'on', 'Poppins font: on or off', 'inspiry-builderpress' );
		$montserrat = _x( 'on', 'Poppins font: on or off', 'inspiry-builderpress' );

		if ( 'off' !== $poppins || 'off' !== $montserrat ) {
			$font_families = array();

			if ( 'off' !== $poppins ) {
				$font_families[] = 'Poppins:300,400,500,600,700';
			}

			if ( 'off' !== $montserrat ) {
				$font_families[] = 'Montserrat:400,700';
			}

			$query_args = array(
				'family' => urlencode( implode( '|', $font_families ) ),
				'subset' => urlencode( 'latin,latin-ext' ),
			);

			$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
		}

		return esc_url_raw( $fonts_url );
	}

endif;


if ( ! function_exists( 'inspiry_enqueue_styles' ) ) :
	/**
	 * Enqueue required styles for front end
	 * @return  void
	 */
	function inspiry_enqueue_styles() {

		if ( ! is_admin() ) :

			$inspiry_template_directory_uri = get_template_directory_uri();

			// Google Font
			wp_enqueue_style(
				'inspiry_google_fonts',
				inspiry_google_fonts(),
				array(),
				INSPIRY_THEME_VERSION
			);

			// flexslider
			wp_enqueue_style( 'bootstrap',
				$inspiry_template_directory_uri . '/css/bootstrap.min.css',
				array(),
				'3.3.5'
			);

			// owl carousel
			wp_enqueue_style( 'bootstrap-theme',
				$inspiry_template_directory_uri . '/css/bootstrap-theme.min.css',
				array(),
				'3.3.5'
			);

			// Mean Menu
			wp_enqueue_style( 'mean-menu',
				$inspiry_template_directory_uri . '/css/meanmenu.css',
				array(),
				'2.0.7'
			);

			// font awesome
			wp_enqueue_style( 'font-awesome',
				$inspiry_template_directory_uri . '/css/font-awesome.min.css',
				array(),
				'4.5.0'
			);

			// Owl carousel
			wp_enqueue_style( 'owl-carousel',
				$inspiry_template_directory_uri . '/css/owl.carousel.min.css',
				array(),
				'1.3.3'
			);

			// Owl carousel theme default
			wp_enqueue_style( 'owl-carousel-theme',
				$inspiry_template_directory_uri . '/css/owl.theme.default.min.css',
				array(),
				'1.3.3'
			);

			// flexslider css
			wp_enqueue_style( 'flexslider',
				$inspiry_template_directory_uri . '/css/flexslider.css',
				array(),
				'1.3.3'
			);

			// animate.css
			wp_enqueue_style( 'animate-css',
				$inspiry_template_directory_uri . '/css/animate.css',
				array(),
				'1.3.3'
			);

			// select2.css
			wp_enqueue_style( 'select-2',
				$inspiry_template_directory_uri . '/css/select2.min.css',
				array(),
				'4.0.3'
			);

			// main styles
			wp_enqueue_style( 'inspiry-main',
				$inspiry_template_directory_uri . '/css/main.css',
				array(),
				INSPIRY_THEME_VERSION
			);


			// parent theme style.css
			wp_enqueue_style( 'inspiry-parent-default',
				get_stylesheet_uri(),
				array( 'inspiry-main' ),
				INSPIRY_THEME_VERSION
			);

			// parent theme css/custom.css
			wp_enqueue_style( 'inspiry-parent-custom',
				$inspiry_template_directory_uri . '/css/custom.css',
				array(),
				INSPIRY_THEME_VERSION
			);

		endif;

	}

	add_action( 'wp_enqueue_scripts', 'inspiry_enqueue_styles' );

endif; // inspiry_enqueue_styles


if ( ! function_exists( 'inspiry_enqueue_scripts' ) ) :
	/**
	 * Enqueue required java scripts for front end
	 * @since   1.0.0
	 * @return  void
	 */
	function inspiry_enqueue_scripts() {

		if ( ! is_admin() ) :

			$inspiry_template_directory_uri = get_template_directory_uri();

			// JQuery ui tabs
			wp_enqueue_script( 'jquery-ui-tabs' );


			// jquery scrollTo
			wp_enqueue_script( 'scrollTo',
				$inspiry_template_directory_uri . '/js/jquery.scrollTo.min.js',
				array( 'jquery' ),
				'2.1.3',
				true
			);

			// jquery modernizr
			wp_enqueue_script( 'modernizr',
				$inspiry_template_directory_uri . '/js/modernizr.custom.97074.js',
				array( 'jquery' ),
				'2.6.2',
				true
			);

			// jquery hoverdir
			wp_enqueue_script( 'hoverdir',
				$inspiry_template_directory_uri . '/js/jquery.hoverdir.js',
				array( 'jquery' ),
				'1.1.2',
				true
			);

			// owl Carousel
			wp_enqueue_script( 'owl-carousel',
				$inspiry_template_directory_uri . '/js/owl.carousel.js',
				array( 'jquery' ),
				'2.1.4',
				true
			);

			// flexslider
			wp_enqueue_script( 'flex-slider',
				$inspiry_template_directory_uri . '/js/jquery.flexslider-min.js',
				array( 'jquery' ),
				'2.1.4',
				true
			);

			// select 2
			wp_enqueue_script( 'select-2',
				$inspiry_template_directory_uri . '/js/select2.min.js',
				array( 'jquery' ),
				'4.0.3',
				true
			);

			// Mean Menu
			wp_enqueue_script( 'meanmenu',
				$inspiry_template_directory_uri . '/js/jquery.meanmenu.min.js',
				array( 'jquery' ),
				'2.0.8',
				true
			);

			// Comment reply script
			if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
				wp_enqueue_script( 'comment-reply' );
			}

			// Main js
			wp_enqueue_script( 'custom',
				$inspiry_template_directory_uri . '/js/custom.js',
				array( 'jquery' ),
				INSPIRY_THEME_VERSION,
				true
			);

			// Google Map API
			$google_maps_key = get_theme_mod( 'inspiry_google_maps_api_key' );
			if ( ! empty( $google_maps_key ) ) {
				$google_map_arguments = array();
				wp_enqueue_script(
					'google-map-api',
					esc_url_raw(
						add_query_arg(
							apply_filters(
								'inspiry_google_map_arguments',
								$google_map_arguments
							),
							'//maps.google.com/maps/api/js'
						)
					),
					array(),
					'3.21',
					false
				);
			}

		endif;

	}

	add_action( 'wp_enqueue_scripts', 'inspiry_enqueue_scripts' );

endif;


if ( ! function_exists( 'inspiry_theme_sidebars' ) ) :
	/**
	 * Register theme sidebars
	 *
	 */
	function inspiry_theme_sidebars() {

		// Location: Default Sidebar
		register_sidebar( array(
			'name'          => esc_html__( 'Default Sidebar', 'inspiry-builderpress' ),
			'id'            => 'default-sidebar',
			'description'   => esc_html__( 'Sidebar for main blog page and archive pages.', 'inspiry-builderpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		// Location: footer 1st column
		register_sidebar( array(
			'name'          => esc_html__( 'Footer 1st column', 'inspiry-builderpress' ),
			'id'            => 'footer-1st-column',
			'description'   => esc_html__( 'Sidebar for footer first column.', 'inspiry-builderpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		//location: footer 2nd column
		register_sidebar( array(
			'name'          => esc_html__( 'Footer 2nd column', 'inspiry-builderpress' ),
			'id'            => 'footer-2nd-column',
			'description'   => esc_html__( 'Sidebar for footer second column.', 'inspiry-builderpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		//location: footer 3rd column
		register_sidebar( array(
			'name'          => esc_html__( 'Footer 3rd column', 'inspiry-builderpress' ),
			'id'            => 'footer-3rd-column',
			'description'   => esc_html__( 'Sidebar for footer third column.', 'inspiry-builderpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		//location: footer 4th column
		register_sidebar( array(
			'name'          => esc_html__( 'Footer 4th column', 'inspiry-builderpress' ),
			'id'            => 'footer-4th-column',
			'description'   => esc_html__( 'Sidebar for footer 4th column.', 'inspiry-builderpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

	}

	add_action( 'widgets_init', 'inspiry_theme_sidebars' );

endif;


if ( ! function_exists( 'inspiry_add_editor_style' ) ) :
	/**
	 * Add editor styles and fonts
	 */
	function inspiry_add_editor_style() {
		add_editor_style( array( 'css/editor-styles.css', inspiry_google_fonts() ) );
	}

	add_action( 'admin_init', 'inspiry_add_editor_style' );
endif;


if ( ! function_exists( 'inspiry_new_excerpt_more' ) ) {
	/**
	 * Excerpt More
	 */
	function inspiry_new_excerpt_more( $more ) {
		return '...';
	}

	add_filter( 'excerpt_more', 'inspiry_new_excerpt_more' );
}


if ( ! function_exists( 'inspiry_theme_comment' ) ) {
	/**
	 * Theme Custom Comment Template
	 */
	function inspiry_theme_comment( $comment, $args, $depth ) {

		$GLOBALS['comment'] = $comment;
		switch ( $comment->comment_type ) :
			case 'pingback' :
			case 'trackback' :
				?>
				<li class="pingback">
					<p><?php esc_html_e( 'Pingback:', 'inspiry-builderpress' ); ?><?php comment_author_link(); ?><?php edit_comment_link( esc_html__( '(Edit)', 'inspiry-builderpress' ), ' ' ); ?></p>
				</li>
				<?php
				break;

			default :
				?>
			<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
				<article id="comment-<?php comment_ID(); ?>" class="comment-wrapper">
					<div class="row">
						<div class="col-sm-2">
							<a class="avatar" href="<?php comment_author_url(); ?>">
								<?php echo get_avatar( $comment, 96 ) ?>
							</a>
						</div>
						<div class="col-sm-10">
							<div class="comment-list-heading clearfix">
								<h3><?php echo get_comment_author_link(); ?></h3>
								<span class="comment-date">  <time
										datetime="<?php comment_time( 'c' ); ?>"><?php echo get_comment_date(); ?></time></span>
							</div>

							<?php comment_text(); ?>
							<?php comment_reply_link( array_merge( array( 'before' => '' ), array(
								'depth'     => $depth,
								'max_depth' => $args['max_depth']
							) ) ); ?>

						</div>

					</div>
				</article>
				<!-- end of comment -->
				<?php
				break;

		endswitch;
	}
}


if ( ! function_exists( 'wpb_move_comment_field_to_bottom' ) ) {
	/**
	 * comment form textarea area move to bottom
	 */
	function wpb_move_comment_field_to_bottom( $fields ) {
		$comment_field = $fields['comment'];
		unset( $fields['comment'] );
		$fields['comment'] = $comment_field;

		return $fields;
	}

	add_filter( 'comment_form_fields', 'wpb_move_comment_field_to_bottom' );
}


if ( ! function_exists( 'inspiry_pagination' ) ) :
	/**
	 * Output pagination
	 *
	 * @param $query
	 */
	function inspiry_pagination( $query ) {

		echo "<nav class='paging-navigation pagination clearfix'>";

		$big = 999999999; // need an unlikely integer
		echo paginate_links( array(
			'base'               => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format'             => '?paged=%#%',
			'prev_text'          => esc_html__( 'PREV', 'inspiry-builderpress' ),
			'next_text'          => esc_html__( 'NEXT', 'inspiry-builderpress' ),
			'current'            => max( 1, get_query_var( 'paged' ) ),
			'total'              => $query->max_num_pages,
			'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'inspiry-builderpress' ) . ' </span>',

		) );
		echo "</nav>";

	}

endif;


/*-----------------------------------------------------------------------------------*/
/*	widgets
/*-----------------------------------------------------------------------------------*/

include_once( INSPIRY_WIDGETS . 'recent-posts-with-thumbnail.php' );
include_once( INSPIRY_WIDGETS . 'builderpress-services.php' );
include_once( INSPIRY_WIDGETS . 'contact-list.php' );

if ( ! function_exists( 'register_theme_widgets' ) ) {
	/**
	 * Register custom widgets
	 */
	function register_theme_widgets() {
		register_widget( 'inspiry_recent_posts_with_thumbnails' );
		register_widget( 'inspiry_builderpress_services' );
		register_widget( 'inspiry_contact_list' );
	}

	add_action( 'widgets_init', 'register_theme_widgets' );
}


/*-----------------------------------------------------------------------------------*/
/*	Google Map API Key
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_google_maps_api_key' ) ) :
	/**
	 * This function adds API key ( if provided in settings ) to google maps arguments
	 */
	function inspiry_google_maps_api_key( $google_map_arguments ) {
		/* Get Google Maps API Key if available */
		$google_maps_api_key = get_theme_mod( 'inspiry_google_maps_api_key' );
		if ( ! empty( $google_maps_api_key ) ) {
			$google_map_arguments['key'] = urlencode( $google_maps_api_key );
		}

		return $google_map_arguments;
	}

	add_filter( 'inspiry_google_map_arguments', 'inspiry_google_maps_api_key' );

endif;

/*-----------------------------------------------------------------------------------*/
/*	Include Customizer
/*-----------------------------------------------------------------------------------*/
require_once( INSPIRY_CUSTOMIZER . 'customizer.php' );


/*-----------------------------------------------------------------------------------*/
/*	One Click Demo Import
/*-----------------------------------------------------------------------------------*/
require_once( get_template_directory() . '/inc/demo/one-click-demo-import.php' );
/*-----------------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/*	Include Breadcrumbs
/*-----------------------------------------------------------------------------------*/
require_once( get_template_directory() . '/inc/breadcrumbs.php' );

/*-----------------------------------------------------------------------------------*/
/*	Include metaboxes
/*-----------------------------------------------------------------------------------*/
require_once( get_template_directory() . '/inc/theme-meta-box.php' );

/*-----------------------------------------------------------------------------------*/
/*	Include VC classes ext
/*-----------------------------------------------------------------------------------*/
require_once( get_template_directory() . '/inc/vc-classes-ext.php' );

/*-----------------------------------------------------------------------------------*/
/*	Color Schemes for Theme
/*-----------------------------------------------------------------------------------*/
require_once( get_template_directory() . '/inc/color-schemes/color-schemes.php' );


