<?php
/*-----------------------------------------------------------------------------------*/
/*	why choose shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_home_why_choose_shortcodes' ) ) {
	function inspiry_home_why_choose_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"inspiry_class" => '',

			), $atts
		);

		$why_choose_structure = '<div class="section-why-choose common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$why_choose_structure .= '<div class="qualities-box">';

		$why_choose_structure .= '<div class="left-items">';
		$why_choose_structure .= '<div class="wrapper-qualities">';
		$why_choose_structure .= '</div>';
		$why_choose_structure .= '</div>';
		$why_choose_structure .= '<div class="right-items">';
		$why_choose_structure .= '</div>';

		$why_choose_structure .= do_shortcode( $content );


		$why_choose_structure .= '</div>';
		$why_choose_structure .= '</div>';


		return $why_choose_structure;
	}

	add_shortcode( 'inspiry_why_choose_parent', 'inspiry_home_why_choose_shortcodes' );
}


//why choose list
if ( ! function_exists( 'insinspiry_home_why_choose_qualities_shortcodes' ) ) {
	function insinspiry_home_why_choose_qualities_shortcodes( $atts, $content = null ) {
		$atts              = shortcode_atts(
			array(
				"inspiry_class"         => '',
				"inspiry_quality_title" => '',
				"inspiry_quality_icon"  => '',
				"inspiry_quality_text"  => '',
			), $atts
		);
		$quality_structure = '<div class="quality-inner ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$quality_structure .= '<span class="quality-icon"><img src="' . esc_url( wp_get_attachment_url( $atts['inspiry_quality_icon'] ) ) . '" alt="' . esc_html( $atts['inspiry_quality_title'] ) . '"></span>';
		$quality_structure .= '<h3>' . esc_html( $atts['inspiry_quality_title'] ) . '</h3>';
		$quality_structure .= '<p>' . esc_html( $atts['inspiry_quality_text'] ) . '</p>';
		$quality_structure .= '</div>';

		return $quality_structure;

	}

	add_shortcode( 'inspiry_why_choose_qualities', 'insinspiry_home_why_choose_qualities_shortcodes' );
}

//images
if ( ! function_exists( 'insinspiry_home_why_choose_images_shortcodes' ) ) {
	function insinspiry_home_why_choose_images_shortcodes( $atts, $content = null ) {
		$atts             = shortcode_atts(
			array(
				"why_choose_image" => '',
				"alt_title"        => 'Image',
				"border_radius"    => '',
				"pos_left"         => '',
				"pos_top"          => '',
				"pos_right"        => '',
				"pos_bottom"       => '',
				"z_index"          => '',
			), $atts
		);
		$pos_left         = esc_attr( $atts['pos_left'] );
		$pos_top          = esc_attr( $atts['pos_top'] );
		$pos_right        = esc_attr( $atts['pos_right'] );
		$pos_bottom       = esc_attr( $atts['pos_bottom'] );
		$z_index          = esc_attr( $atts['z_index'] );
		$images_structure = '<div class="image-wrapper thumb-experience" style=" z-index:' . $z_index . '; top:' . $pos_top . '; left:' . $pos_left . '; right:' . $pos_right . '; bottom:' . $pos_bottom . ';">';
		$images_structure .= '<img style="border-radius: ' . esc_attr( $atts['border_radius'] ) . 'px;" class="value-icon" src="' . esc_url( wp_get_attachment_url( $atts['why_choose_image'] ) ) . '" alt="' . esc_html( $atts['alt_title'] ) . '">';
		$images_structure .= '</div>';

		return $images_structure;

	}

	add_shortcode( 'inspiry_why_choose_images', 'insinspiry_home_why_choose_images_shortcodes' );
}

/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_why_choose_parent' ) ) {
	function inspiry_vc_why_choose_parent() {
		vc_map( array(
				"name"            => esc_html__( "Why Choose Us?", "builderpress-pack" ),
				"base"            => "inspiry_why_choose_parent",
				"class"           => "",
				"as_parent"       => array( 'only' => 'inspiry_why_choose_qualities,inspiry_why_choose_images' ),
				"category"        => esc_html__( "BuilderPress", "builderpress-pack" ),
				"content_element" => true,
				"is_container"    => true,
				"js_view"         => 'VcColumnView',
				"params"          => array(
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),


				),

			)
		);
	}

	add_action( 'vc_before_init', 'inspiry_vc_why_choose_parent' );
}

// Home why choose child
if ( ! function_exists( 'inspiry_vc_why_choose_child' ) ) {
	function inspiry_vc_why_choose_child() {
		vc_map( array(
				"name"     => esc_html__( "Qualities", "builderpress-pack" ),
				"base"     => "inspiry_why_choose_qualities",
				"as_child" => array( 'only' => 'inspiry_why_choose_parent' ),
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(


					array(
						"type"       => "attach_image",
						"heading"    => esc_html__( "Icon", "builderpress-pack" ),
						"param_name" => 'inspiry_quality_icon',
					),

					array(
						"type"       => "textfield",
						"heading"    => esc_html__( "Title", "builderpress-pack" ),
						"param_name" => 'inspiry_quality_title',
					),

					array(
						"type"       => "textarea",
						"heading"    => esc_html__( "Text", "builderpress-pack" ),
						"param_name" => 'inspiry_quality_text',
					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),

				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_why_choose_child' );
}

if ( ! function_exists( 'inspiry_vc_why_choose_child_image' ) ) {
	function inspiry_vc_why_choose_child_image() {
		vc_map( array(
				"name"     => esc_html__( "Image", "builderpress-pack" ),
				"base"     => "inspiry_why_choose_images",
				"as_child" => array( 'only' => 'inspiry_why_choose_parent' ),
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(

					array(
						"type"        => "attach_image",
						"heading"     => esc_html__( "Image", "builderpress-pack" ),
						"param_name"  => 'why_choose_image',
						"description" => esc_html__( "All positions set to 0 if image is needed to be center. Recommended maximum width of image is 360px.", "builderpress-pack" )
					),
					array(
						"type"       => "textfield",
						"heading"    => esc_html__( "Alt Title", "builderpress-pack" ),
						"param_name" => 'alt_title',
					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Border Radius", "builderpress-pack" ),
						"param_name"  => 'border_radius',
						"description" => esc_html__( "default is 5px", "builderpress-pack" )
					),
					array(
						"type"       => "textfield",
						"heading"    => esc_html__( "Position from left", "builderpress-pack" ),
						"param_name" => 'pos_left',
					),
					array(
						"type"       => "textfield",
						"heading"    => esc_html__( "Position from top", "builderpress-pack" ),
						"param_name" => 'pos_top',
					),
					array(
						"type"       => "textfield",
						"heading"    => esc_html__( "Position from right", "builderpress-pack" ),
						"param_name" => 'pos_right',
					),
					array(
						"type"       => "textfield",
						"heading"    => esc_html__( "Position from bottom", "builderpress-pack" ),
						"param_name" => 'pos_bottom',
					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Stack Order (z-index)", "builderpress-pack" ),
						"param_name"  => 'z_index',
						"description" => esc_html__( "Image with higher number will stay on top", 'builderpress-pack' )
					)

				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_why_choose_child_image' );
}

