<?php
/*-----------------------------------------------------------------------------------*/
/*	Testimonials var1 shortcodes
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'inspiry_testimonials_shortcodes' ) ) {
	function inspiry_testimonials_shortcodes( $atts, $content = null ) {
		$atts                            = shortcode_atts(
			array(
				"inspiry_class"                   => '',
				"testimonials-bg-color"           => '#fffffff',
				"testimonials-text-color"         => '#737373',
				"testimonials-heading-color"      => '#1a1a1a',
				"testimonials-separator-color"    => '',
				"testimonials-byline-color"       => '#9fa3a7',
				"testimonials-byline-hover-color" => '#1a1a1a',
				"testi_count"                     => '',


			), $atts
		);
		$testimonials_to_show            = $atts['testi_count'];
		$testimonials_byline_color       = esc_attr( $atts['testimonials-byline-color'] );
		$testimonials_byline_hover_color = esc_attr( $atts['testimonials-byline-hover-color'] );

		$args = array(
			'post_type'      => 'testimonial',
			'posts_per_page' => $testimonials_to_show,
		);

		$test_query             = new WP_Query( $args );
		$testimonials_structure = "";
		if ( $test_query->have_posts() ):
			$testimonials_structure = '<div class="testimonials-section text-center common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '" >';
			$testimonials_structure .= '<div class="testimonials-slider owl-carousel owl-theme">';

			while ( $test_query->have_posts() ):

				$test_query->the_post();
				$email_gravatar = get_post_meta( get_the_ID(), '_gravatar_email', true );
				$by_line        = get_post_meta( get_the_ID(), '_byline', true );
				$url            = get_post_meta( get_the_ID(), '_url', true );

				$testimonials_structure .= '<div>';
				$testimonials_structure .= '<div class="wrapper-slider-testimonials">';
				$testimonials_structure .= '<div class="testimonials-text">';
				$testimonials_structure .= '<p style="color: ' . esc_attr( $atts['testimonials-text-color'] ) . '">' . get_the_content() . '</p>';
				$testimonials_structure .= '<span class="bg-testimonials" style="background: ' . esc_attr( $atts['testimonials-bg-color'] ) . '"></span>';
				$testimonials_structure .= '</div>';
				$testimonials_structure .= '<span class="author-image">';
				if ( ! empty( $email_gravatar ) ) {
					$testimonials_structure .= get_avatar( $email_gravatar, 130 );
				} elseif ( has_post_thumbnail() ) {
					$testimonials_structure .= get_the_post_thumbnail( get_the_ID(), 'thumbnail' );
				} else {
					$static_gravatar = get_template_directory_uri() . '/images/gravatar.jpg';
					$testimonials_structure .= '<img src="' . $static_gravatar . '" alt="Gravatar">';
				}
				$testimonials_structure .= '</span>';
				$testimonials_structure .= '<h3 style="color: ' . esc_attr( $atts['testimonials-heading-color'] ) . '">' . get_the_title() . '</h3>';
				if ( ! empty( $testimonials_byline_hover_color ) ) {
					$mouseHover = " onmouseover=\" this.style.color = ' $testimonials_byline_hover_color ';\"  ";
				}
				if ( ! empty( $testimonials_byline_color ) ) {
					$mouseNormal = " onmouseout=\" this.style.color = '  $testimonials_byline_color ';\"";
				}
				$testimonials_structure .= '<a class="author-designation" style="color:' . $testimonials_byline_color . '" href="' . esc_url( $url ) . '"';
				if ( ! empty( $mouseHover ) ) {
					$testimonials_structure .= $mouseHover;
				}
				if ( ! empty( $mouseNormal ) ) {
					$testimonials_structure .= $mouseNormal;
				}
				$testimonials_structure .= '>' . esc_html( $by_line ) . '</a>';
				$testimonials_structure .= '<span class="testimonial-short-border" style="background: ' . esc_attr( $atts['testimonials-separator-color'] ) . '"></span>';
				$testimonials_structure .= '</div>';
				$testimonials_structure .= '</div>';

			endwhile;
			wp_reset_postdata();
			$testimonials_structure .= '</div>';
			$testimonials_structure .= '</div>';
		endif;

		return $testimonials_structure;


	}

	add_shortcode( 'inspiry_testimonials', 'inspiry_testimonials_shortcodes' );
}

/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'inspiry_vc_testimonials_wrapper' ) ) {
	function inspiry_vc_testimonials_wrapper() {
		vc_map( array(
				"name"     => esc_html__( "Testimonials 1", "builderpress-pack" ),
				"base"     => "inspiry_testimonials",
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(


					array(
						"type"       => "dropdown",
						"heading"    => esc_html__( "Max Number of Testimonials to be shown", 'builderpress-pack' ),
						"param_name" => 'testi_count',
						"value"      => array(
							esc_html__( '2', 'builderpress-pack' )  => 2,
							esc_html__( '4', 'builderpress-pack' )  => 4,
							esc_html__( '6', 'builderpress-pack' )  => 6,
							esc_html__( '8', 'builderpress-pack' )  => 8,
							esc_html__( '10', 'builderpress-pack' ) => 10,
						),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Testimonials Single Background Color", "builderpress-pack" ),
						"param_name"  => "testimonials-bg-color",
						"description" => esc_html__( "Default color is #ffffff", "builderpress-pack" ),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Text Color", "builderpress-pack" ),
						"param_name"  => "testimonials-text-color",
						"description" => esc_html__( "Default color is #737373", "builderpress-pack" ),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Author Color", "builderpress-pack" ),
						"param_name"  => "testimonials-heading-color",
						"description" => esc_html__( "Default color is #1a1a1a", "builderpress-pack" ),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Designation Color", "builderpress-pack" ),
						"param_name"  => "testimonials-byline-color",
						"description" => esc_html__( "Default color is #9fa3a7", "builderpress-pack" ),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Designation Hover Color", "builderpress-pack" ),
						"param_name"  => "testimonials-byline-hover-color",
						"description" => esc_html__( "Default color is #1a1a1a", "builderpress-pack" ),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Bottom Border Color", "builderpress-pack" ),
						"param_name"  => "testimonials-separator-color",
						"description" => esc_html__( "Default color is #ffd800", "builderpress-pack" ),
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),

				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_testimonials_wrapper' );
}