<?php
/*-----------------------------------------------------------------------------------*/
/*	services home shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_home_services_shortcodes' ) ) {
	function inspiry_home_services_shortcodes( $atts, $content = null ) {
		$atts              = shortcode_atts(
			array(
				"inspiry_class"     => '',
				"services_btn_link" => '',
				"number_of_posts"   => 3,
			), $atts
		);
		$number_of_posts   = esc_html( $atts['number_of_posts'] );
		$service_structure = '<div class="inspiry-scheme-section-colors services-section text-center common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$service_structure .= '<div class="services-box">';
		$args          = array(
			'post_type'      => 'service',
			'posts_per_page' => $number_of_posts,
		);
		$service_query = new WP_Query( $args );
		if ( $service_query->have_posts() ):
			while ( $service_query->have_posts() ):
				$service_query->the_post();

				$service_structure .= '<div class="single-service-wrapper">';
				$service_structure .= '<div class="single-service">';
				$service_structure .= '<a class="image-anchor" href="' . get_permalink() . '">' . get_the_post_thumbnail( get_the_ID() ) . '</a>';
				$service_structure .= '<div class="service-single-content">';
				$service_structure .= '<h3><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>';
				$service_structure .= '<p>' . get_the_excerpt() . '</p>';

				$service_structure .= '</div>';
				$service_structure .= '</div>';
				$service_structure .= '</div>';
			endwhile;
			wp_reset_postdata();
		endif;
		$service_structure .= '</div>';
		$btn_link     = vc_build_link( $atts['services_btn_link'] );
		$btn_link_var = array_filter( $btn_link );


		$link_target      = $btn_link['target'];
		$link_target_atts = '';
		if ( ! empty( $link_target ) ) {
			$link_target_atts = 'target = "' . esc_attr( $link_target ) . '"';
		}


		if ( ! empty( $btn_link_var ) ) {
			$service_structure .= '<div class="wrapper-button-services"><a class="bp-button bp-button-plain button-dark hover-to-yellow"  ' . $link_target_atts . ' href="' . esc_url( $btn_link['url'] ) . '">' . esc_html( $btn_link['title'] ) . '</a></div>';
		}
		$service_structure .= '</div>';

		return $service_structure;

	}

	add_shortcode( 'inspiry_home_services', 'inspiry_home_services_shortcodes' );
}

/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_home_services_wrapper' ) ) {
	function inspiry_vc_home_services_wrapper() {
		vc_map( array(
				"name"     => esc_html__( "Services 1", "builderpress-pack" ),
				"base"     => "inspiry_home_services",
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(

					array(
						"type"       => "vc_link",
						"heading"    => esc_html__( "Select Button URL and Title", "builderpress-pack" ),
						"param_name" => "services_btn_link",
					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( 'Number Of Post To Be Shown', 'builderpress-pack' ),
						"param_name"  => "number_of_posts",
						"description" => esc_html__( 'Default value is 3', 'builderpress-pack' )
					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),


				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_home_services_wrapper' );
}