<?php
/*-----------------------------------------------------------------------------------*/
/*	services home var2 shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_home_services_var2_shortcodes' ) ) {
	function inspiry_home_services_var2_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"inspiry_class" => '',
				"cta_btn_link"  => '',
				"post_count"    => 4,
			), $atts
		);

		$posts_to_show = $atts['post_count'];

		$service_structure = '<div class="services-section services-section-var2 common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$service_structure .= '<div class="row">';
		$args           = array(
			'post_type'      => 'service',
			'posts_per_page' => $posts_to_show,
		);
		$count_clearfix = 1;
		$service_query  = new WP_Query( $args );
		if ( $service_query->have_posts() ):
			while ( $service_query->have_posts() ):
				$service_query->the_post();

				$service_structure .= '<div class="col-lg-6 custom-class-services-2">';
				$service_structure .= '<div class="service-box-var2 theme-box-shadow theme-box-shadow-hover">';
				$service_structure .= '<div class="image-service">';
				$service_structure .= '<a class="image-anchor" href="' . get_permalink() . '">' . get_the_post_thumbnail( get_the_ID(), 'inspiry_image_size_360_270' ) . '</a>';
				$service_structure .= '</div>';
				$service_structure .= '<div class="detail-service">';
				$service_structure .= '<h3><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>';
				$service_structure .= '<p>' . wp_trim_words( get_the_excerpt(), 12 ) . '</p>';
				$service_structure .= '</div>';
				$service_structure .= '</div>';
				$service_structure .= '</div>';


				if ( $count_clearfix % 2 == 0 ) {

					$service_structure .= '<div class="clearfix visible-md"></div>';
					$service_structure .= '<div class="clearfix visible-lg"></div>';

				}
				$count_clearfix ++;

			endwhile;
			wp_reset_postdata();
		endif;
		$service_structure .= '</div>';
		$btn_link = vc_build_link( $atts['cta_btn_link'] );


		$link_target      = $btn_link['target'];
		$link_target_atts = '';
		if ( ! empty( $link_target ) ) {
			$link_target_atts = 'target = "' . esc_attr( $link_target ) . '"';
		}

		$service_structure .= '<div class="text-center services-button-wrapper">';
		$service_structure .= '<a class="bp-button bp-button-plain button-yellow"  ' . $link_target_atts . ' href="' . esc_url( $btn_link['url'] ) . '">' . esc_html( $btn_link['title'] ) . '</a>';
		$service_structure .= '</div>';
		$service_structure .= '</div>';

		return $service_structure;

	}

	add_shortcode( 'inspiry_home_services_var2', 'inspiry_home_services_var2_shortcodes' );
}
/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_home_services_var2_wrapper' ) ) {
	function inspiry_vc_home_services_var2_wrapper() {
		vc_map( array(
				"name"     => esc_html__( "Services 2", "builderpress-pack" ),
				"base"     => "inspiry_home_services_var2",
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(


					array(
						"type"       => "dropdown",
						"heading"    => esc_html__( "Max Number of Services to be shown", 'builderpress-pack' ),
						"param_name" => 'post_count',
						"std"        => "4",
						"value"      => array(
							esc_html__( '2', 'builderpress-pack' )  => 2,
							esc_html__( '4', 'builderpress-pack' )  => 4,
							esc_html__( '6', 'builderpress-pack' )  => 6,
							esc_html__( '8', 'builderpress-pack' )  => 8,
							esc_html__( '10', 'builderpress-pack' ) => 10,
						),
					),

					array(
						"type"       => "vc_link",
						"heading"    => esc_html__( "Select Button URL and Title", "builderpress-pack" ),
						"param_name" => "cta_btn_link",
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),


				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_home_services_var2_wrapper' );
}