<?php
/*-----------------------------------------------------------------------------------*/
/*	Section headings and intro Shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_section_heading_shortcodes' ) ) {
	function inspiry_section_heading_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				'text_position'         => 'text-center',
				'title'                 => '',
				'detail'                => '',
				'text_width'            => '',
				'section_heading_color' => '#1a1a1a',
				'section_text_color'    => '#808080',
			), $atts
		);

		$section_heading = '<div class="section-heading-intro common-vc-class ' . esc_attr( $atts['text_position'] ) . '">';
		$section_heading .= '<h2 style="color:' . esc_attr( $atts['section_heading_color'] ) . '">' . esc_html( $atts['title'] ) . '</h2>';
		$detail     = $atts['detail'];
		$text_width = $atts['text_width'];
		if ( ! empty( $detail ) ) {
			if ( $text_width == 'true' ) {
				$section_heading .= '<p style="color:' . esc_attr( $atts['section_text_color'] ) . '; max-width: none; " class="section-text">' . esc_html( $atts['detail'] ) . '</p>';
			} else {
				$section_heading .= '<p style="color:' . esc_attr( $atts['section_text_color'] ) . '" class="section-text">' . esc_html( $atts['detail'] ) . '</p>';
			}
		}
		$section_heading .= '</div>';

		return $section_heading;
	}

	add_shortcode( 'inspiry_section_heading', 'inspiry_section_heading_shortcodes' );
}

/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'inspiry_vc_section_heading' ) ) {
	function inspiry_vc_section_heading() {
		vc_map( array(
				"name"     => esc_html__( "Section Heading and Intro", "builderpress-pack" ),
				"base"     => "inspiry_section_heading",
				"class"    => "",
				"weight"   => 99,
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),

				"params" => array(
					array(
						"type"       => "dropdown",
						"heading"    => esc_html__( "Select Text Align", "builderpress-pack" ),
						"param_name" => "text_position",
						"value"      => array(
							esc_html__( 'Text center', 'builderpress-pack' ) => 'text-center',
							esc_html__( 'Text left', 'builderpress-pack' )   => 'text-left',
							esc_html__( 'Text right', 'builderpress-pack' )  => 'text-right',
						),
					),
					array(
						"type"        => "textfield",
						"class"       => "",
						"heading"     => esc_html__( "Section Heading", "builderpress-pack" ),
						"param_name"  => "title",
						"description" => esc_html__( "Enter section heading.", "builderpress-pack" )
					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Heading Color", "builderpress-pack" ),
						"param_name"  => "section_heading_color",
						"description" => esc_html__( "default color is #1a1a1a.", "builderpress-pack" )
					),

					array(
						"type"        => "textarea",
						"heading"     => esc_html__( "Section Text", "builderpress-pack" ),
						"param_name"  => "detail",
						"description" => esc_html__( "Enter section text.", "builderpress-pack" )
					),

					array(
						"type"       => "dropdown",
						"heading"    => esc_html__( "Full width text?", "builderpress-pack" ),
						"param_name" => "text_width",
						"value"      => array(
							esc_html__( 'No', 'builderpress-pack' )  => 'false',
							esc_html__( 'Yes', 'builderpress-pack' ) => 'true',
						),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Text Color", "builderpress-pack" ),
						"param_name"  => "section_text_color",
						"description" => esc_html__( "default color is #808080.", "builderpress-pack" )
					),


				)
			)
		);
	}

	add_action( 'vc_before_init', 'inspiry_vc_section_heading' );
}