<?php
/*-----------------------------------------------------------------------------------*/
/*	portfolio shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_home_portfolio_shortcodes' ) ) {
	function inspiry_home_portfolio_shortcodes( $atts, $content = null ) {
		$atts                   = shortcode_atts(
			array(
				"inspiry_class"                    => '',
				"project_categories_color"         => '',
				"project_thumbnail_heading_color"  => '',
				"project_thumbnail_location_color" => '',
			), $atts
		);
		$project_cat_color      = $atts['project_categories_color'];
		$project_heading_color  = $atts['project_thumbnail_heading_color'];
		$project_location_color = $atts['project_thumbnail_location_color'];

		$project_structure = '<div class="portfolio-section text-center common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">'; //div 1
		$project_structure .= '<div class="wrapper-portfolio-slider">'; // div 2
		$project_structure .= '<div class="owl-theme">';
		$project_structure .= '<div class="owl-controls">';
		$project_structure .= '<div id="customDots" class="owl-dots"></div>';
		$project_structure .= '</div>';
		$project_structure .= '</div>';
		$project_structure .= '<div id="portfolio-slider-owl" class="portfolio-slider-owl owl-carousel owl-theme">'; // div slider

		$custom_terms = get_terms( array( 'taxonomy' => 'project-category' ) );

		array_unshift( $custom_terms, "All" );


		foreach ( $custom_terms as $custom_term ) {

			$args = array(
				'post_type'      => 'project',
				'posts_per_page' => 50,
			);

			if ( $custom_term != 'All' ) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'project-category',
						'field'    => 'slug',
						'terms'    => $custom_term->slug,
					),
				);
			}


			$cat_counter = 0; //counter


			$loop          = new WP_Query( $args );
			$categorycount = $loop->post_count; // get total number of post in a category

			if ( $loop->have_posts() ):
				if ( $custom_term == 'All' ) {
					$project_structure .= '<div class="item" data-dot=\'<a style=" color:' . $project_cat_color . '; " href=" # " >' . esc_html__( 'All', 'builderpress-pack' ) . '</a>\'>';
				} else {
					$project_structure .= '<div class="item" data-dot=\'<a style=" color:' . $project_cat_color . '; " href=" # " >' . esc_html( $custom_term->name ) . '</a>\'>';
				}
				$project_structure .= '<div class="item-owl">';
				$project_structure .= '<div class="wrapper-inner-owl">';
				$project_structure .= '<div class="inner-slider-owl" >';
				while ( $loop->have_posts() ) : $loop->the_post();
					if ( has_post_thumbnail() ) {
						$project_location = get_post_meta( get_the_ID(), 'bp-location', true );
						if ( $cat_counter % 2 == 0 ) {
							$project_structure .= '<div>';
							$project_structure .= '<div class="inner-detail-slide">';
						}
						$project_structure .= '<div class="item-box">';
						$project_structure .= '<a class="test-class-hover" href="' . get_permalink() . '">';
						$project_structure .= get_the_post_thumbnail( get_the_ID(), 'inspiry_image_size_720_540' );
						$project_structure .= '<div class="overlay-slide hoverdir-item">';
						$project_structure .= '<h3 style="color: ' . $project_heading_color . '">' . get_the_title() . '</h3>';
						$project_structure .= '<p style=" color: ' . $project_location_color . ' ">' . esc_html( $project_location ) . '</p>';
						$project_structure .= '</div>';
						$project_structure .= '</a>';
						$project_structure .= '</div>';

						$cat_counter ++;

						if ( $cat_counter % 2 == 0 ) {
							$project_structure .= '</div>';
							$project_structure .= '</div>';
						} elseif ( $cat_counter == $categorycount ) {
							$project_structure .= '</div>';
							$project_structure .= '</div>';
						}
					}

				endwhile;
				wp_reset_postdata();

				$project_structure .= '</div>';
				$project_structure .= '</div>';
				$project_structure .= '</div>';
				$project_structure .= '</div>';
			endif;
		}
		$project_structure .= '</div>'; //div slider end
		$project_structure .= '</div>'; //div 2 end
		$project_structure .= '</div>'; //div 1 end

		return $project_structure;
	}

	add_shortcode( 'inspiry_home_portfolio', 'inspiry_home_portfolio_shortcodes' );
}

/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'inspiry_vc_home_portfolio_wrapper' ) ) {
	function inspiry_vc_home_portfolio_wrapper() {
		vc_map( array(
				"name"     => esc_html__( "Recent Projects", "builderpress-pack" ),
				"base"     => "inspiry_home_portfolio",
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Project Categories Color", "builderpress-pack" ),
						"param_name"  => "project_categories_color",
						"description" => esc_html__( "Default Color is #ffffff", "builderpress-pack" ),

					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Project Thumbnail Heading Color", "builderpress-pack" ),
						"param_name"  => "project_thumbnail_heading_color",
						"description" => esc_html__( "Default Color is ##1a1a1a", "builderpress-pack" ),

					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Project Thumbnail Location Color", "builderpress-pack" ),
						"param_name"  => "project_thumbnail_location_color",
						"description" => esc_html__( "Default Color is #7a6d25", "builderpress-pack" ),

					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),

				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_home_portfolio_wrapper' );
}