<?php
/*-----------------------------------------------------------------------------------*/
/*	featured projects 2 shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_home_featured_var2_shortcodes' ) ) {
	function inspiry_home_featured_var2_shortcodes( $atts, $content = null ) {
		$atts           = shortcode_atts(
			array(
				"inspiry_class"     => '',
				"featured_btn_text" => 'VIEW PROJECT',
			), $atts
		);
		$args           = array(
			'post_type'      => 'project',
			'posts_per_page' => 20,
		);
		$featured_query = new WP_Query( $args );
		$count          = 0;
		$slider_data    = array();
		if ( $featured_query->have_posts() ):
			while ( $featured_query->have_posts() ):
				$featured_query->the_post();
				$feature_checked = get_post_meta( get_the_ID(), 'bp-featured', true );
				if ( $feature_checked == 1 ) {
					if ( has_post_thumbnail() ) {
						$slider_data[ $count ]['image-thumb'] = get_the_post_thumbnail( get_the_ID(), 'inspiry_image_size_360_270' );
						$slider_data[ $count ]['image']       = get_the_post_thumbnail( get_the_ID(), 'inspiry_image_size_570_525' );
					} else {
						$slider_data[ $count ]['image-thumb'] = null;
						$slider_data[ $count ]['image']       = null;

					}
					$slider_data[ $count ]['title']    = get_the_title( get_the_ID() );
					$slider_data[ $count ]['location'] = get_post_meta( get_the_ID(), 'bp-location', true );
					$count ++;
				}
			endwhile;
			wp_reset_postdata();
		endif;
		$featured_structure = '<div class="featured-section common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$featured_structure .= '<div class="featured-section-var2">';

		$featured_structure .= '<div class="wrapper-left-tabs">';
		$featured_structure .= '<div id="scroll-to-this"></div>';
		$featured_structure .= '<ul class="left-tabs">';
		$tab_count = 0;
		if ( ! empty( $slider_data ) ) {
			foreach ( $slider_data as $data ) {
				$featured_structure .= '<li class="carousel-single">';


				$featured_structure .= '<div class="hidden-xs hidden-sm wrapper-inner-single-feature">';
				$featured_structure .= '<a class="scroll-center" href="#tab' . $tab_count . '">';
				$featured_structure .= '<div class="image-wrapper_tabs">';
				$featured_structure .= '<div class="hidden-xs hidden-sm">' . $data['image-thumb'] . '</div>';

				$featured_structure .= '</div>';
				$featured_structure .= '<div class="text-wrapper">';
				$featured_structure .= '<h3>' . esc_html( $data['title'] ) . '</h3>';
				$featured_structure .= '<p><i class="fa fa-map-marker"></i>' . esc_html( $data['location'] ) . '</p>';
				$featured_structure .= '</div>';

				$featured_structure .= '</a>';
				$featured_structure .= '</div>';


				$featured_structure .= '<div class="visible-sm visible-xs wrapper-inner-single-feature single-inner-sm-class">';
				$featured_structure .= '<a class="scroll-center" href="' . get_permalink() . ' ">';
				$featured_structure .= '<div class="image-wrapper_tabs">';
				$featured_structure .= $data['image'];

				$featured_structure .= '</div>';
				$featured_structure .= '<div class="text-wrapper">';
				$featured_structure .= '<h3>' . esc_html( $data['title'] ) . '</h3>';
				$featured_structure .= '<p><i class="fa fa-map-marker"></i>' . esc_html( $data['location'] ) . '</p>';
				$featured_structure .= '</div>';

				$featured_structure .= '</a>';
				$featured_structure .= '</div>';


				$featured_structure .= '</li>';
				$tab_count ++;
			}
		}
		$featured_structure .= '</ul>';
		$featured_structure .= '</div>';

		$featured_structure .= '<div class=" hidden-sm hidden-xs wrapper-tabs-large">';
		$featured_structure .= '<div class="slider-right">';
		$image_count = 0;
		foreach ( $slider_data as $data ) {
			$featured_structure .= '<div class="slide wrapper-tab-contents" id="tab' . $image_count . '">';
			$featured_structure .= $data['image'];
			$featured_structure .= '<div class="image-overlay"></div>';

			$featured_structure .= '<div class="button-wrapper">';
			$featured_structure .= '<a class="bp-button bp-button-plain button-yellow" href="' . get_permalink() . '">' . esc_html( $atts['featured_btn_text'] ) . '</a>';
			$featured_structure .= '</div>';
			$featured_structure .= '</div>';
			$image_count ++;
		}
		$featured_structure .= '</div>';
		$featured_structure .= '</div>';


		$featured_structure .= '</div>';
		$featured_structure .= '</div>';

		return $featured_structure;

	}


	add_shortcode( 'inspiry_home_featured_var2', 'inspiry_home_featured_var2_shortcodes' );
}
/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_home_featured_var2_wrapper' ) ) {
	function inspiry_vc_home_featured_var2_wrapper() {
		vc_map( array(
			"name"        => esc_html__( "Featured Projects 2", "builderpress-pack" ),
			"base"        => "inspiry_home_featured_var2",
			"category"    => esc_html__( "BuilderPress", "builderpress-pack" ),
			"description" => esc_html__( 'Display projects that are marked featured (variation 2)', 'builderpress-pack' ),
			"params"      => array(

				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Button Text", "builderpress-pack" ),
					"param_name"  => 'featured_btn_text',
					"description" => esc_html__( "Default text is \"VIEW PROJECT\". This button will be shown on right large image while hover.", "builderpress-pack" )

				),
				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
					"param_name"  => 'inspiry_class',
					"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
				),


			),
		) );
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_home_featured_var2_wrapper' );
}