<?php
/*-----------------------------------------------------------------------------------*/
/*	cta-bar shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_cta_bar_shortcodes' ) ) {
	function inspiry_cta_bar_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				'cta_heading'              => '',
				'cta_heading_color'        => '',
				'cta_text'                 => '',
				'cta_text_color'           => '',
				'cta_btn_link'             => '',
				'cta_btn_text_color'       => '#ffffff',
				'cta_btn_text_hover_color' => '#1a1a1a',
				'cta_btn_bg_color'         => '#1a1a1a',
				'cta_btn_bg_hover_color'   => '#ffffff',
				'cta_bar_bg_color'         => '',
				'cta_bar_bg_image'         => '',
			), $atts
		);

		$cta_bar_bg_color = $atts['cta_bar_bg_color'];
		$cta_bar_bg_image = $atts['cta_bar_bg_image'];

		$cta_bg_color = '';
		if ( ! empty( $cta_bar_bg_color ) ) {
			$cta_bg_color = 'style="background:' . $cta_bar_bg_color . '; " ';
		}
		$cta_bg_image = '';
		if ( ! empty( $cta_bar_bg_image ) ) {
			$cta_bg_image = 'style="background-image:url(' . esc_url( wp_get_attachment_url( $cta_bar_bg_image ) ) . ');"';
		}

		$cta_structure = '<div class="wrapper-vc-cta common-vc-class" ' . $cta_bg_image . '>';

		$cta_structure .= '<div class="vc-cta-overlay" ' . $cta_bg_color . '></div>';
		$cta_structure .= '<div class="container-cta">';
		$cta_structure .= '<div class="vc-wrapper-quote-box">';
		$cta_structure .= '<div class="flex-item text-cta">';
		$cta_structure .= '<h2 style="color:' . esc_attr( $atts['cta_heading_color'] ) . '">' . esc_html( $atts['cta_heading'] ) . '</h2>';
		$cta_structure .= '<p style="color: ' . esc_attr( $atts['cta_text_color'] ) . '">' . esc_html( $atts['cta_text'] ) . '</p>';
		$cta_structure .= '</div>';
		$cta_structure .= '<div class="flex-item">';
		$btn_link = vc_build_link( $atts['cta_btn_link'] );

		$link_target      = $btn_link['target'];
		$link_target_atts = '';
		if ( ! empty( $link_target ) ) {
			$link_target_atts = 'target = "' . esc_attr( $link_target ) . '"';
		}

		$cta_btn_text_color       = esc_attr( $atts['cta_btn_text_color'] );
		$cta_btn_text_hover_color = esc_attr( $atts['cta_btn_text_hover_color'] );
		$cta_btn_bg_color         = esc_attr( $atts['cta_btn_bg_color'] );
		$cta_btn_bg_hover_color   = esc_attr( $atts['cta_btn_bg_hover_color'] );
		if ( ! empty( $cta_btn_bg_hover_color ) || ! empty( $cta_btn_text_color ) ) {
			$mouseHover = " onmouseover=\"this.style.background='  $cta_btn_bg_hover_color '; this.style.color=' $cta_btn_text_hover_color ';\"  ";
		}
		if ( ! empty( $cta_btn_bg_color ) || ! empty( $cta_btn_text_color ) ) {
			$mouseNormal = " onmouseout=\"this.style.background= ' $cta_btn_bg_color '; this.style.color = '  $cta_btn_text_color ';\"";
		}

		if ( ! empty( $btn_link['url'] ) && ! empty( $btn_link['title'] ) ) {
			$cta_structure .= '<a class="bp-button bp-button-plain" ';
			$cta_structure .= 'style=" background: ' . $cta_btn_bg_color . '; color: ' . $cta_btn_text_color . ' "';
			if ( ! empty( $mouseHover ) ) {
				$cta_structure .= $mouseHover;
			}
			if ( ! empty( $mouseNormal ) ) {
				$cta_structure .= $mouseNormal;
			}

			$cta_structure .= ' href="' . esc_url( $btn_link['url'] ) . '" ' . $link_target_atts . '>' . esc_html( $btn_link['title'] ) . '</a>';
		}

		$cta_structure .= '</div>';
		$cta_structure .= '</div>';
		$cta_structure .= '</div>';
		$cta_structure .= '</div>';

		return $cta_structure;

	}

	add_shortcode( 'inspiry_cta_bar', 'inspiry_cta_bar_shortcodes' );
}

/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_cta_bar' ) ) {
	function inspiry_vc_cta_bar() {

		vc_map( array(
				"name"        => esc_html__( "Call To Action Bar", "builderpress-pack" ),
				"base"        => "inspiry_cta_bar",
				"class"       => "",
				"category"    => esc_html__( "BuilderPress", "builderpress-pack" ),
				"description" => esc_html__( 'Display Call To Action bar', 'builderpress-pack' ),
				"params"      => array(
					array(
						"type"       => "textfield",
						"heading"    => esc_html__( "Heading", "builderpress-pack" ),
						"param_name" => "cta_heading",

					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Heading Color", "builderpress-pack" ),
						"param_name"  => "cta_heading_color",
						"description" => esc_html__( "Default Color is #1a1a1a", "builderpress-pack" ),

					),
					array(
						"type"       => "textarea",
						"heading"    => esc_html__( "Text", "builderpress-pack" ),
						"param_name" => "cta_text",

					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Text Color", "builderpress-pack" ),
						"param_name"  => "cta_text_color",
						"description" => esc_html__( "Default color is #4b493d", "builderpress-pack" ),
					),
					array(
						"type"       => "vc_link",
						"heading"    => esc_html__( "Select Button URL and Title", "builderpress-pack" ),
						"param_name" => "cta_btn_link",

					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Button Text Color", "builderpress-pack" ),
						"param_name"  => "cta_btn_text_color",
						"description" => esc_html__( "Default Color is #ffffff", "builderpress-pack" ),

					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Button Text Hover Color", "builderpress-pack" ),
						"param_name"  => "cta_btn_text_hover_color",
						"description" => esc_html__( "Default Color is #1a1a1a", "builderpress-pack" ),
					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Button Background Color", "builderpress-pack" ),
						"param_name"  => "cta_btn_bg_color",
						"description" => esc_html__( "Default Color is #1a1a1a", "builderpress-pack" ),

					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Button Background Hover Color", "builderpress-pack" ),
						"param_name"  => "cta_btn_bg_hover_color",
						"description" => esc_html__( "Default Color is #ffffff", "builderpress-pack" ),

					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "CTA Background Color", "builderpress-pack" ),
						"param_name"  => "cta_bar_bg_color",
						"description" => esc_html__( 'Display Background Color is #FFD800. It will work as overlay if image is set as background', 'builderpress-pack' ),
					),
					array(
						"type"       => "attach_image",
						"heading"    => esc_html__( "Select Image For CTA Background", "builderpress-pack" ),
						"param_name" => 'cta_bar_bg_image',
					),

				),

			)
		);
	}

	add_action( 'vc_before_init', 'inspiry_vc_cta_bar' );
}
?>