<?php
/*-----------------------------------------------------------------------------------*/
/*	cta-bar shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_contact_detail_wrapper_shortcodes' ) ) {
	function inspiry_contact_detail_wrapper_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				'inspiry_class' => '',
			), $atts
		);

		$contact_structure = '<div class="contact-detail-list common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$contact_structure .= '<ul>';
		$contact_structure .= do_shortcode( $content );
		$contact_structure .= '</ul>';
		$contact_structure .= '</div>';

		return $contact_structure;

	}

	add_shortcode( 'inspiry_contact_detail_wrapper', 'inspiry_contact_detail_wrapper_shortcodes' );
}

if ( ! function_exists( 'inspiry_contact_details_list_shortcodes' ) ) {
	function inspiry_contact_details_list_shortcodes( $atts, $content = null ) {
		$atts         = shortcode_atts(
			array(
				"inspiry_class" => '',
				"label"         => '',
				"detail"        => '',
				"icon_image"    => '',
			), $atts
		);
		$contact_icon = $atts['icon_image'];
		$contact_list = '<li class="contact-list ' . esc_attr( $atts['inspiry_class'] ) . '">';
		if ( ! empty( $contact_icon ) ) {
			$contact_list .= '<span class="icon"><img src="' . esc_url( wp_get_attachment_url( $contact_icon ) ) . '" alt="' . esc_attr( $atts['label'] ) . '"></span>';
		}
		$contact_list .= '<span class="small">' . esc_html( $atts['label'] ) . '</span>';
		$contact_list .= '<span class="detail">' . esc_html( $atts['detail'] ) . '</span>';

		$contact_list .= '</li>';

		return $contact_list;


	}

	add_shortcode( 'inspiry_contact_detail_list', 'inspiry_contact_details_list_shortcodes' );
}

if ( ! function_exists( 'inspiry_contact_opening_hours_shortcodes' ) ) {
	function inspiry_contact_opening_hours_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"inspiry_class" => '',
				"label"         => '',
				"opening_days"  => '',
				"opening_hours" => '',
				"half_day"      => '',
				"half_hours"    => '',
				"close_day"     => '',
				"close_text"    => '',
				"icon_image"    => '',
			), $atts
		);

		$opening_days  = $atts['opening_days'];
		$opening_hours = $atts['opening_hours'];
		$half_day      = $atts['half_day'];
		$half_hours    = $atts['half_hours'];
		$close_day     = $atts['close_day'];
		$close_text    = $atts['close_text'];

		$contact_list = '<li class="contact-list ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$contact_list .= '<span class="icon"><img src="' . esc_url( wp_get_attachment_url( $atts['icon_image'] ) ) . '" alt="' . esc_html( $atts['label'] ) . '"></span>';
		$contact_list .= '<span class="small">' . esc_html( $atts['label'] ) . '</span>';
		$contact_list .= '<div class="detail">';

		if ( ! empty( $opening_days ) ) {
			$contact_list .= '<div class="inner-row">';
			$contact_list .= '<span>' . esc_html( $opening_days ) . '</span>';
			$contact_list .= '<span>' . esc_html( $opening_hours ) . '</span>';
			$contact_list .= '</div>';
		}

		if ( ! empty( $half_day ) ) {
			$contact_list .= '<div class="inner-row">';
			$contact_list .= '<span>' . esc_html( $half_day ) . '</span>';
			$contact_list .= '<span>' . esc_html( $half_hours ) . '</span>';
			$contact_list .= '</div>';
		}

		if ( $close_day ) {
			$contact_list .= '<div class="inner-row">';
			$contact_list .= '<span>' . esc_html( $close_day ) . '</span>';
			$contact_list .= '<span>' . esc_html( $close_text ) . '</span>';
			$contact_list .= '</div>';
		}

		$contact_list .= '</div>';

		$contact_list .= '</li>';

		return $contact_list;


	}

	add_shortcode( 'inspiry_contact_opening_hours', 'inspiry_contact_opening_hours_shortcodes' );
}


/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_contact_detail' ) ) {
	function inspiry_vc_contact_detail() {

		vc_map( array(
			"name"                    => esc_html__( "Contact Details", "builderpress-pack" ),
			"base"                    => "inspiry_contact_detail_wrapper",
			"as_parent"               => array( 'only' => 'inspiry_contact_detail_list,inspiry_contact_opening_hours' ),
			// Use only|except attributes to limit child shortcodes (separate multiple values with comma)
			"content_element"         => true,
			"is_container"            => true,
			"show_settings_on_create" => true,
			"category"                => esc_html__( "BuilderPress", "builderpress-pack" ),
			"js_view"                 => 'VcColumnView',
			"description"             => esc_html__( 'Add and display contact details', 'builderpress-pack' ),
			"params"                  => array(
				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
					"param_name"  => 'inspiry_class',
					"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )

				),

			),

		) );
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_contact_detail' );
}

if ( ! function_exists( 'inspiry_vc_contact_form_list' ) ) {
	function inspiry_vc_contact_form_list() {
		vc_map( array(
			"name"     => esc_html__( "Contact Detail List", "builderpress-pack" ),
			"base"     => "inspiry_contact_detail_list",
			"as_child" => array( 'only' => 'inspiry_contact_detail_wrapper' ),
			// Use only|except attributes to limit parent (separate multiple values with comma)
			"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
			"params"   => array(

				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Label", "builderpress-pack" ),
					"param_name"  => 'label',
					"description" => esc_html__( "Label for contact detail", "builderpress-pack" )

				),
				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Detail", "builderpress-pack" ),
					"param_name"  => 'detail',
					"description" => esc_html__( "Enter Phone/Fax/Email/Address detail", "builderpress-pack" )
				),
				array(
					"type"        => "attach_image",
					"heading"     => esc_html__( "Select Icon", 'builderpress-pack' ),
					"param_name"  => 'icon_image',
					"description" => esc_html__( "Select SVG/png/jpg icon of recommended size 25x25", "builderpress-pack" )
				),

				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
					"param_name"  => 'inspiry_class',
					"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )

				),

			),
		) );
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_contact_form_list' );
}


if ( ! function_exists( 'inspiry_vc_contact_opening_hours' ) ) {
	function inspiry_vc_contact_opening_hours() {
		vc_map( array(
				"name"     => esc_html__( "Office Opening Days/Ours", "builderpress-pack" ),
				"base"     => "inspiry_contact_opening_hours",
				"as_child" => array( 'only' => 'inspiry_contact_detail_wrapper' ),
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(


					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Label", "builderpress-pack" ),
						"param_name"  => 'label',
						"description" => esc_html__( "Label for opening days/hours", "builderpress-pack" )

					),


					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Opening Days", "builderpress-pack" ),
						"param_name"  => 'opening_days',
						"description" => esc_html__( "Office opening days range i.e. Monday-Friday", "builderpress-pack" )
					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Opening Hours", "builderpress-pack" ),
						"param_name"  => 'opening_hours',
						"description" => esc_html__( "Office opening hours range i.e. 09:00-17:00", "builderpress-pack" )
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Half Day", "builderpress-pack" ),
						"param_name"  => 'half_day',
						"description" => esc_html__( "Office half opening day (if any) i.e. Saturday", "builderpress-pack" )
					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Half Day Hours", "builderpress-pack" ),
						"param_name"  => 'half_hours',
						"description" => esc_html__( "Office half day opening hours range i.e. 10:00-14:00", "builderpress-pack" )
					),


					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Close Day", "builderpress-pack" ),
						"param_name"  => 'close_day',
						"description" => esc_html__( "Office Close day (if any) i.e. Sunday", "builderpress-pack" )
					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Close Day Text", "builderpress-pack" ),
						"param_name"  => 'close_text',
						"description" => esc_html__( "Office Close day Text i.e. Closed", "builderpress-pack" )
					),

					array(
						"type"        => "attach_image",
						"heading"     => esc_html__( "Select Icon", "builderpress-pack" ),
						"param_name"  => 'icon_image',
						"description" => esc_html__( "Select SVG/png/jpg icon of recommended size 25x25", "builderpress-pack" )
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )

					),


				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_contact_opening_hours' );

}
