<?php
/*-----------------------------------------------------------------------------------*/
/*	carousel values shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_values_carousel_shortcodes' ) ) {
	function inspiry_values_carousel_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"inspiry_class"             => '',
				"inspiry_carousel_count"    => '3',
				"inspiry_carousel_loop"     => 'yes',
				"inspiry_carousel_autoplay" => 'yes',
				"inspiry_carousel_margin"   => '30',
				"text_position"             => 'text-left',
			), $atts
		);


		$slider_structure = '<div class="wrapper-vc-carousel common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . esc_attr( $atts['text_position'] ) . '" style="position: relative;">';
		$slider_structure .= '<div class="wrapper-slider-values owl-carousel owl-theme inspiry-carousel"
    data-items-per-view = "' . esc_js( $atts['inspiry_carousel_count'] ) . '"
    data-loop = "' . esc_js( $atts['inspiry_carousel_loop'] ) . '"
    data-autoplay = "' . esc_js( $atts['inspiry_carousel_autoplay'] ) . '"
    data-margin = "' . esc_js( $atts['inspiry_carousel_margin'] ) . '"
    >';
		$slider_structure .= do_shortcode( $content );
		$slider_structure .= '</div>';
		$slider_structure .= '</div>';


		return $slider_structure;
	}

	add_shortcode( 'inspiry_carousel', 'inspiry_values_carousel_shortcodes' );
}


if ( ! function_exists( 'inspiry_values_carousel_child_shortcodes' ) ) {
	function inspiry_values_carousel_child_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"carousel_image"   => '',
				"carousel_heading" => '',
				"carousel_detail"  => '',
			), $atts
		);

		$carousel_item_image   = $atts['carousel_image'];
		$carousel_item_heading = $atts['carousel_heading'];
		$carousel_item_detail  = $atts['carousel_detail'];

		$slider_structure_child = '<div class="single-slide-value">';

		if ( ! empty( $carousel_item_image ) ) {
			$slider_structure_child .= '<div class="value-icon-wrapper">';
			$slider_structure_child .= '<img class="value-icon" src="' . esc_url( wp_get_attachment_url( $carousel_item_image ) ) . '" alt="' . esc_attr( $atts['carousel_heading'] ) . '">';
			$slider_structure_child .= '</div>';
		}
		if ( ! empty( $carousel_item_heading ) ) {
			$slider_structure_child .= '<h3>' . esc_html( $carousel_item_heading ) . '</h3>';
		}
		if ( ! empty( $carousel_item_detail ) ) {
			$slider_structure_child .= '<p>' . esc_html( $carousel_item_detail ) . '</p>';
		}

		$slider_structure_child .= '</div>';

		return $slider_structure_child;
	}

	add_shortcode( 'inspiry_carousel_child', 'inspiry_values_carousel_child_shortcodes' );
}


/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'inspiry_vc_carousel_values' ) ) {
	function inspiry_vc_carousel_values() {
		vc_map( array(
			"name"                    => esc_html__( "Core Values Carousel", "builderpress-pack" ),
			"base"                    => "inspiry_carousel",
			"as_parent"               => array( 'only' => 'inspiry_carousel_child' ),
			"content_element"         => true,
			"is_container"            => true,
			"show_settings_on_create" => true,
			"class"                   => "",
			"category"                => esc_html__( "BuilderPress", "builderpress-pack" ),
			"js_view"                 => 'VcColumnView',
			"description"             => esc_html__( 'Add and display Core values in a carousel', 'builderpress-pack' ),
			"params"                  => array(
				array(
					"type"       => "dropdown",
					"heading"    => esc_html__( "Select position of contents", "builderpress-pack" ),
					"param_name" => "text_position",
					"value"      => array(
						esc_html__( 'Left', 'builderpress-pack' )   => 'text-left',
						esc_html__( 'Center', 'builderpress-pack' ) => 'text-center',
						esc_html__( 'Right', 'builderpress-pack' )  => 'text-right',
					),
				),


				array(
					"type"       => "dropdown",
					"heading"    => esc_html__( "Enter Number of carousel items per view", "builderpress-pack" ),
					"param_name" => 'inspiry_carousel_count',
					"value"      => array(
						esc_html__( '3', 'builderpress-pack' ) => 3,
						esc_html__( '4', 'builderpress-pack' ) => 4,
						esc_html__( '5', 'builderpress-pack' ) => 5,

					),
				),
				array(
					"type"       => "dropdown",
					"heading"    => esc_html__( "Loop", "builderpress-pack" ),
					"param_name" => 'inspiry_carousel_loop',
					"value"      => array(
						esc_html__( 'Yes', 'builderpress-pack' ) => 'true',
						esc_html__( 'No', 'builderpress-pack' )  => 'false',
					),
				),
				array(
					"type"       => "dropdown",
					"heading"    => esc_html__( "Autoplay", "builderpress-pack" ),
					"param_name" => 'inspiry_carousel_autoplay',
					"value"      => array(
						esc_html__( 'Yes', 'builderpress-pack' ) => 'true',
						esc_html__( 'No', 'builderpress-pack' )  => 'false',
					),
				),
				array(
					"type"       => "textfield",
					"heading"    => esc_html__( "Enter margin between items", "builderpress-pack" ),
					"param_name" => 'inspiry_carousel_margin',
				),

				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
					"param_name"  => 'inspiry_class',
					"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )

				),

			),
		) );
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_carousel_values' );

}

// Inspiry Value Carousel Child
if ( ! function_exists( 'inspiry_vc_carousel_child' ) ) {
	function inspiry_vc_carousel_child() {
		vc_map( array(
			"name"     => esc_html__( "Core Values Item", "builderpress-pack" ),
			"base"     => "inspiry_carousel_child",
			"as_child" => array( 'only' => 'inspiry_carousel' ),
			// Use only|except attributes to limit parent (separate multiple values with comma)

			"class"    => "",
			"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
			"params"   => array(
				array(
					"type"        => "attach_image",
					"heading"     => esc_html__( "Select Image", 'builderpress-pack' ),
					"param_name"  => 'carousel_image',
					"description" => esc_html__( 'SVG/png/jpg icon size 72x72 ', 'builderpress-pack' )
				),
				array(
					"type"       => "textfield",
					"heading"    => esc_html__( "Heading", 'builderpress-pack' ),
					"param_name" => 'carousel_heading',
				),
				array(
					"type"       => "textarea",
					"heading"    => esc_html__( "Detail", 'builderpress-pack' ),
					"param_name" => 'carousel_detail',
				),
			),
		) );
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_carousel_child' );
}

