<?php
/*-----------------------------------------------------------------------------------*/
/*	client carousel
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_client_carousel_shortcodes' ) ) {
	function inspiry_client_carousel_shortcodes( $atts, $content = null ) {
		$atts                             = shortcode_atts(
			array(
				"inspiry_class"                    => '',
				"inspiry_clients_carousel_options" => '',
			), $atts
		);
		$inspiry_clients_carousel_options = $atts['inspiry_clients_carousel_options'];
		$carousel_client                  = '<div class="partners-section text-center ' . esc_attr( $atts['inspiry_class'] ) . '" style="position: relative;">';
		if ( $inspiry_clients_carousel_options == false ) {
			$carousel_client .= '<div class="clients-partners-wrapper common-vc-class">';
		} else {
			$carousel_client .= '<div class="slider-partners owl-carousel owl-theme">';
		}
		$carousel_client .= do_shortcode( $content );
		$carousel_client .= '</div>';
		$carousel_client .= '</div>';


		return $carousel_client;
	}
	add_shortcode( 'inspiry_carousel_client', 'inspiry_client_carousel_shortcodes' );
}

if ( ! function_exists( 'inspiry_client_carousel_child_shortcodes' ) ) {
	function inspiry_client_carousel_child_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"carousel_image"      => '',
				"inspiry_client_name" => '',
			), $atts
		);

		$carousel_client_child = '<div class="client-wrapper">';
		$carousel_client_child .= '<img src="' . esc_url( wp_get_attachment_url( $atts['carousel_image'] ) ) . '" alt="' . esc_attr( $atts['inspiry_client_name'] ) . '" title = "' . esc_attr( $atts['inspiry_client_name'] ) . '">';

		$carousel_client_child .= '</div>';

		return $carousel_client_child;
	}
	add_shortcode( 'inspiry_carousel_client_child', 'inspiry_client_carousel_child_shortcodes' );
}


/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/


if ( ! function_exists( 'inspiry_vc_carousel_clients' ) ) {
	function inspiry_vc_carousel_clients() {
		vc_map( array(
			"name"                    => esc_html__( "Client and Partners", "builderpress-pack" ),
			"base"                    => "inspiry_carousel_client",
			"as_parent"               => array( 'only' => 'inspiry_carousel_client_child' ),
			"content_element"         => true,
			"is_container"            => true,
			"show_settings_on_create" => true,
			"category"                => esc_html__( "BuilderPress", "builderpress-pack" ),
			"js_view"                 => 'VcColumnView',
			"params"                  => array(

				array(
					"type"        => "dropdown",
					"heading"     => esc_html__( " Do you display clients in carousel?", "builderpress-pack" ),
					"param_name"  => 'inspiry_clients_carousel_options',
					"description" => esc_html__( "Contents will be displayed as carousel if option is \"Yes\". ", "builderpress-pack" ),
					"value"       => array(
						esc_html__( 'No', 'builderpress-pack' )  => false,
						esc_html__( 'Yes', 'builderpress-pack' ) => true,
					),
				),

				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
					"param_name"  => 'inspiry_class',
					"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )

				),


			),
		) );
	}
	add_action( 'vc_after_init_base', 'inspiry_vc_carousel_clients' );

}
// Inspiry Client Carousel Child
if ( ! function_exists( 'inspiry_vc_carousel_clients_child' ) ) {
	function inspiry_vc_carousel_clients_child() {
		vc_map( array(
			"name"     => esc_html__( "Client and Partner Item", "builderpress-pack" ),
			"base"     => "inspiry_carousel_client_child",
			"as_child" => array( 'only' => 'inspiry_carousel_client' ),
			"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
			"params"   => array(

				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Name of Client or Partner", "builderpress-pack" ),
					"param_name"  => 'inspiry_client_name',
					"description" => esc_html__( "Name will be shown as alt attribute of the image", "builderpress-pack" )

				),
				array(
					"type"        => "attach_image",
					"heading"     => esc_html__( "Select Image", "builderpress-pack" ),
					"param_name"  => 'carousel_image',
					"description" => esc_html__( "Recommended image size 200x120", "builderpress-pack" )
				),
				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
					"param_name"  => 'inspiry_class',
					"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )

				),

			),
		) );
	}
	add_action( 'vc_after_init_base', 'inspiry_vc_carousel_clients_child' );
}

