<?php
if ( ! function_exists( 'list_caret_shortcode' ) ) {
	function list_caret_shortcode( $atts, $content = null ) {
		return '<div class="list-caret-wrapper">' . do_shortcode( $content ) . '</div>';
	}

	add_shortcode( 'caret_list', 'list_caret_shortcode' );
}

/* ------------------------------------------------------------------------*
 * Messages Shortcode
 * ------------------------------------------------------------------------*/

// Information
if ( ! function_exists( 'bp_show_info' ) ) {
	function bp_show_info( $atts, $content = null ) {
		return '<p class="message bg-info text-info">' . do_shortcode( $content ) . '<button type="button" class="close" aria-hidden="true">&times;</button></p>';
	}

	add_shortcode( 'info', 'bp_show_info' );
}

// Tip
if ( ! function_exists( 'bp_show_tip' ) ) {
	function bp_show_tip( $atts, $content = null ) {
		return '<p class="message bg-warning text-warning">' . do_shortcode( $content ) . '<button type="button" class="close" aria-hidden="true">&times;</button></p>';
	}

	add_shortcode( 'tip', 'bp_show_tip' );
}

// Error
if ( ! function_exists( 'bp_show_error' ) ) {
	function bp_show_error( $atts, $content = null ) {
		return '<p class="message bg-danger text-danger">' . do_shortcode( $content ) . '<button type="button" class="close" aria-hidden="true">&times;</button></p>';
	}

	add_shortcode( 'error', 'bp_show_error' );
}

// Success
if ( ! function_exists( 'bp_show_success' ) ) {
	function bp_show_success( $atts, $content = null ) {
		return '<p class="message bg-success text-success">' . do_shortcode( $content ) . '<button type="button" class="close" aria-hidden="true">&times;</button></p>';
	}

	add_shortcode( 'success', 'bp_show_success' );
}

/* ------------------------------------------------------------------------*
 * Columns
 * ------------------------------------------------------------------------*/

// columns wrapper
if ( ! function_exists( 'bp_show_columns' ) ) {
	function bp_show_columns( $atts, $content = null ) {
		return '<div class="row">' . do_shortcode( $content ) . '</div>';
	}

	add_shortcode( 'columns', 'bp_show_columns' );
}

// single column
if ( ! function_exists( 'bo_show_single_column' ) ) {
	function bo_show_single_column( $atts, $content = null ) {
		return '<div class="col-lg-12 col-md-12 col-sm-12">' . do_shortcode( $content ) . '</div>';
	}

	add_shortcode( 'single_column', 'bo_show_single_column' );
}

// two columns
if ( ! function_exists( 'bp_show_two_column' ) ) {
	function bp_show_two_column( $atts, $content = null ) {
		return '<div class="col-lg-6 col-md-6 col-sm-6">' . do_shortcode( $content ) . '</div>';
	}

	add_shortcode( 'one_half', 'bp_show_two_column' );
}

// three columns
if ( ! function_exists( 'bp_show_one_third' ) ) {
	function bp_show_one_third( $atts, $content = null ) {
		return '<div class="col-lg-4 col-md-4 col-sm-4">' . do_shortcode( $content ) . '</div>';
	}

	add_shortcode( 'one_third', 'bp_show_one_third' );
}


// four columns
if ( ! function_exists( 'bp_show_one_fourth' ) ) {
	function bp_show_one_fourth( $atts, $content = null ) {
		return '<div class="col-lg-3 col-md-3 col-sm-3">' . do_shortcode( $content ) . '</div>';
	}

	add_shortcode( 'one_fourth', 'bp_show_one_fourth' );
}


// six columns
if ( ! function_exists( 'bp_show_one_sixth' ) ) {
	function bp_show_one_sixth( $atts, $content = null ) {
		return '<div class="col-lg-2 col-md-2 col-sm-2">' . do_shortcode( $content ) . '</div>';
	}

	add_shortcode( 'one_sixth', 'bp_show_one_sixth' );
}

// three columns
if ( ! function_exists( 'bp_show_three_fourth' ) ) {
	function bp_show_three_fourth( $atts, $content = null ) {
		return '<div class="col-lg-9 col-md-9 col-sm-9">' . do_shortcode( $content ) . '</div>';
	}

	add_shortcode( 'three_fourth', 'bp_show_three_fourth' );
}

/* ------------------------------------------------------------------------*
 * Buttons
 * ------------------------------------------------------------------------*/

// Default Button
if ( ! function_exists( 'default_button' ) ) {
	function default_button( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'link'   => '#',
			'target' => ''
		), $atts ) );
		$link   = $atts['link'];
		$target = $atts['target'];

		return '<a class="Shortcode_btn bp-button bp-button-plain button-yellow btn-slider" href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">' . do_shortcode( $content ) . '</a>';
	}

	add_shortcode( 'default_button', 'default_button' );
}

// Button Black to White
if ( ! function_exists( 'button_black_to_white' ) ) {
	function button_black_to_white( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'link'   => '#',
			'target' => ''
		), $atts ) );
		$link   = $atts['link'];
		$target = $atts['target'];

		return '<a class="Shortcode_btn bp-button bp-button-plain button-dark" href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">' . do_shortcode( $content ) . '</a>';
	}

	add_shortcode( 'button_black_to_white', 'button_black_to_white' );
}

// Default Button bordered
if ( ! function_exists( 'button_with_border' ) ) {
	function button_with_border( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'link'   => '#',
			'target' => ''
		), $atts ) );
		$link   = $atts['link'];
		$target = $atts['target'];

		return '<a class="Shortcode_btn bp-button bp-button-plain button-yellow button-yellow-border" href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">' . do_shortcode( $content ) . '</a>';
	}

	add_shortcode( 'button_with_border', 'button_with_border' );
}

// Default Black to Yellow
if ( ! function_exists( 'button_black_to_yellow' ) ) {
	function button_black_to_yellow( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'link'   => '#',
			'target' => ''
		), $atts ) );
		$link   = $atts['link'];
		$target = $atts['target'];

		return '<a class="Shortcode_btn bp-button bp-button-plain button-dark hover-to-yellow " href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">' . do_shortcode( $content ) . '</a>';
	}

	add_shortcode( 'button_black_to_yellow', 'button_black_to_yellow' );
}

// Default Button Read More
if ( ! function_exists( 'read_more_button' ) ) {
	function read_more_button( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'link'   => '#',
			'target' => ''
		), $atts ) );
		$link   = $atts['link'];
		$target = $atts['target'];

		return '<a class="Shortcode_btn read-more bp-lined" href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">' . do_shortcode( $content ) . '</a>';
	}

	add_shortcode( 'read_more_button', 'read_more_button' );
}

