<?php
/**
 * Plugin Name:		BuilderPress Pack
 * Description:		This plugin provide required custom post types and shortcodes for BuilderPress theme.
 * Version:			1.0.3
 * Author:			Inspiry Themes
 * Author URI:		https://inspirythemes.com/
 * Text Domain:		builderpress-pack
 * Domain Path:		/languages
 */

/*
 *  Make sure the plugin is accessed through the appropriate channels
 */
defined( 'ABSPATH' ) || die;


/**
 * Load plugin text domain.
 */
function builderpress_pack_load_textdomain() {
	load_plugin_textdomain( 'builderpress-pack', false, plugin_basename( dirname( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'builderpress_pack_load_textdomain' );


/*
 * define path for visual composer functions
 */
define( 'INSPIRY_VISUAL_COMPOSER', plugin_dir_path( __FILE__ ) . 'inc/vc-elements/' );


/*
 * Include Meta Boxes
 */
include_once( plugin_dir_path( __FILE__ ) . 'admin/bp-meta-box.php' );


if ( ! function_exists( 'inspiry_builderpress_pack_js' ) ) {
	/**
	 * Enqueue inspiry-plugin.js file
	 */
	function inspiry_builderpress_pack_js() {
		wp_enqueue_script( 'inspiry-plugin', plugin_dir_url( __FILE__ ) . 'js/inspiry-plugin.js' );
	}

	add_action( 'admin_enqueue_scripts', 'inspiry_builderpress_pack_js' );
}


if ( ! function_exists( 'inspiry_register_services_cpt' ) ) {
	/**
	 * Register service post type
	 */
	function inspiry_register_services_cpt() {
		$theme_labels = array(
			'name'               => esc_html__( 'Services', 'builderpress-pack' ),
			'singular_name'      => esc_html__( 'Service', 'builderpress-pack' ),
			'add_new'            => esc_html__( 'Add New', 'builderpress-pack' ),
			'add_new_item'       => esc_html__( 'Add New Service', 'builderpress-pack' ),
			'edit_item'          => esc_html__( 'Edit Service', 'builderpress-pack' ),
			'new_item'           => esc_html__( 'New Service', 'builderpress-pack' ),
			'view_item'          => esc_html__( 'View Service', 'builderpress-pack' ),
			'search_items'       => esc_html__( 'Search Service', 'builderpress-pack' ),
			'not_found'          => esc_html__( 'No service found', 'builderpress-pack' ),
			'not_found_in_trash' => esc_html__( 'No service found in Trash', 'builderpress-pack' ),
		);

		$theme_post_args = array(
			'labels'              => $theme_labels,
			'public'              => true,
			'exclude_from_search' => true,
			'publicly_queryable'  => true,
			'show_ui'             => true,
			'query_var'           => true,
			'menu_icon'           => 'dashicons-hammer',
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'has_archive'         => true,
			'menu_position'       => 5,
			'supports'            => array( 'title', 'excerpt', 'thumbnail', 'editor' ),
			'rewrite'             => array( 'slug' => esc_html__( 'product-features', 'builderpress-pack' ) )
		);

		register_post_type( 'service', $theme_post_args );

	}

	add_action( 'init', 'inspiry_register_services_cpt' );
}


if ( ! function_exists( 'inspiry_register_projects_cpt' ) ) {
	/**
	 * Register project post type
	 */
	function inspiry_register_projects_cpt() {
		$theme_labels = array(
			'name'               => esc_html__( 'Projects', 'builderpress-pack' ),
			'singular_name'      => esc_html__( 'Project', 'builderpress-pack' ),
			'add_new'            => esc_html__( 'Add New', 'builderpress-pack' ),
			'add_new_item'       => esc_html__( 'Add New Project', 'builderpress-pack' ),
			'edit_item'          => esc_html__( 'Edit Project', 'builderpress-pack' ),
			'new_item'           => esc_html__( 'New Project', 'builderpress-pack' ),
			'view_item'          => esc_html__( 'View Project', 'builderpress-pack' ),
			'search_items'       => esc_html__( 'Search Project', 'builderpress-pack' ),
			'not_found'          => esc_html__( 'No Project found', 'builderpress-pack' ),
			'not_found_in_trash' => esc_html__( 'No project found in Trash', 'builderpress-pack' ),
		);

		$theme_post_args = array(
			'labels'              => $theme_labels,
			'public'              => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'show_ui'             => true,
			'query_var'           => true,
			'menu_icon'           => 'dashicons-portfolio',
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'menu_position'       => 5,
			'has_archive'         => true,
			'supports'            => array( 'title', 'excerpt', 'thumbnail', 'editor' ),
			'rewrite'             => array( 'slug' => esc_html__( 'projects', 'builderpress-pack' ) )
		);

		register_post_type( 'project', $theme_post_args );

	}

	add_action( 'init', 'inspiry_register_projects_cpt' );
}


if ( ! function_exists( 'inspiry_register_project_taxonomy' ) ) {
	/**
	 * Register project category taxonomy
	 */
	function inspiry_register_project_taxonomy() {

		$theme_category_labels = array(
			'name'                       => esc_html__( 'Projects Categories', 'builderpress-pack' ),
			'singular_name'              => esc_html__( 'Project Category', 'builderpress-pack' ),
			'search_items'               => esc_html__( 'Search Project Category', 'builderpress-pack' ),
			'popular_items'              => esc_html__( 'Popular Project Categories', 'builderpress-pack' ),
			'all_items'                  => esc_html__( 'All Project Categories', 'builderpress-pack' ),
			'parent_item'                => esc_html__( 'Parent Project Category', 'builderpress-pack' ),
			'parent_item_colon'          => esc_html__( 'Parent Project Category:', 'builderpress-pack' ),
			'edit_item'                  => esc_html__( 'Edit Project Category', 'builderpress-pack' ),
			'update_item'                => esc_html__( 'Update Project Category', 'builderpress-pack' ),
			'add_new_item'               => esc_html__( 'Add New Project Category', 'builderpress-pack' ),
			'new_item_name'              => esc_html__( 'New Project Category Name', 'builderpress-pack' ),
			'separate_items_with_commas' => esc_html__( 'Separate Project Category with commas', 'builderpress-pack' ),
			'add_or_remove_items'        => esc_html__( 'Add or Remove Project Category', 'builderpress-pack' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Project categories', 'builderpress-pack' ),
			'menu_name'                  => esc_html__( 'Project Categories', 'builderpress-pack' )
		);

		register_taxonomy(
			'project-category',
			array( 'project' ),
			array(
				'hierarchical'        => true,
				'labels'              => $theme_category_labels,
				'exclude_from_search' => false,
				'show_ui'             => true,
				'public'              => true,
				'query_var'           => true,
				'rewrite'             => array( 'slug' => esc_html__( 'project-category', 'builderpress-pack' ) ),
			)
		);
	}

	add_action( 'init', 'inspiry_register_project_taxonomy', 0 );
}


if ( ! function_exists( 'inspiry_register_team_cpt' ) ) {
	/**
	 * Register Team post type
	 */
	function inspiry_register_team_cpt() {
		$theme_labels = array(
			'name'               => esc_html__( 'Team', 'builderpress-pack' ),
			'singular_name'      => esc_html__( 'Team Member', 'builderpress-pack' ),
			'add_new'            => esc_html__( 'Add New Member', 'builderpress-pack' ),
			'add_new_item'       => esc_html__( 'Add New Member', 'builderpress-pack' ),
			'edit_item'          => esc_html__( 'Edit Member', 'builderpress-pack' ),
			'new_item'           => esc_html__( 'New Member', 'builderpress-pack' ),
			'view_item'          => esc_html__( 'View Member', 'builderpress-pack' ),
			'search_items'       => esc_html__( 'Search Member', 'builderpress-pack' ),
			'not_found'          => esc_html__( 'No Member found', 'builderpress-pack' ),
			'not_found_in_trash' => esc_html__( 'No Member found in Trash', 'builderpress-pack' ),
		);

		$theme_post_args = array(
			'labels'              => $theme_labels,
			'public'              => true,
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			'show_ui'             => true,
			'query_var'           => true,
			'menu_icon'           => 'dashicons-groups',
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'menu_position'       => 5,
			'supports'            => array( 'title', 'thumbnail', 'editor' ),
			'rewrite'             => array( 'slug' => esc_html__( 'members', 'builderpress-pack' ) )
		);

		register_post_type( 'members', $theme_post_args );

	}

	add_action( 'init', 'inspiry_register_team_cpt' );
}


/*-----------------------------------------------------------------------------------*/
/*	Custom columns
/*-----------------------------------------------------------------------------------*/
if ( is_admin() ) {
	global $pagenow;

	/*------------------------------------*/
	/* Custom columns for project
	/*------------------------------------*/
	if ( $pagenow == 'edit.php' && isset( $_GET[ 'post_type' ] ) && esc_attr( $_GET[ 'post_type' ] ) == 'project' ) {

		add_action( 'manage_posts_custom_column', 'inspiry_project_columns_content' );
		add_filter( 'manage_edit-project_columns', 'inspiry_edit_project_columns' );

		function inspiry_edit_project_columns( $columns ) {

			$columns = array(
				'cb'         => '<input type="checkbox" />',
				'title'      => esc_html__( 'Title', 'builderpress-pack' ),
				"thumbnail"  => esc_html__( 'Photo', 'builderpress-pack' ),
				"location"   => esc_html__( 'Location', 'builderpress-pack' ),
				"completion" => esc_html__( 'Completion', 'builderpress-pack' ),
				"size"       => wp_kses( __( 'Size m<sup>2</sup>', 'builderpress-pack' ), array( 'sup' => array() ) ),
				'date'       => esc_html__( 'Date', 'builderpress-pack' )
			);

			return $columns;
		}

	}


	function inspiry_project_columns_content( $column_name ) {
		switch ( $column_name ) {
			case 'thumbnail':
				if ( has_post_thumbnail( get_the_ID() ) ) {
					?><a href="<?php the_permalink(); ?>" target="_blank"><?php the_post_thumbnail( array(
						130,
						130
					) ); ?></a><?php
				} else {
					esc_html_e( 'NA', 'builderpress-pack' );
				}
				break;

			case 'location':
				$location_meta_value = get_post_meta( get_the_ID(), 'bp-location', true );
				if ( ! empty ( $location_meta_value ) ) {
					echo $location_meta_value;
				} else {
					esc_html_e( 'NA', 'builderpress-pack' );
				}
				break;

			case 'completion':
				$date_meta_value = get_post_meta( get_the_ID(), 'bp-completion-date-text', true );
				if ( ! empty ( $date_meta_value ) ) {
					echo $date_meta_value;
				} else {
					esc_html_e( 'NA', 'builderpress-pack' );
				}
				break;

			case 'size':
				$area_meta_value = get_post_meta( get_the_ID(), 'bp-area', true );
				if ( ! empty ( $area_meta_value ) ) {
					echo $area_meta_value;
				} else {
					esc_html_e( 'NA', 'builderpress-pack' );
				}
				break;

			default:
				break;
		}

	}


	/*------------------------------------*/
	/* custom columns for services
	/*------------------------------------*/
	if ( $pagenow == 'edit.php' && isset( $_GET[ 'post_type' ] ) && esc_attr( $_GET[ 'post_type' ] ) == 'service' ) {
		add_action( 'manage_posts_custom_column', 'inspiry_service_columns_content' );
		add_filter( 'manage_edit-service_columns', 'inspiry_edit_service_columns' );

		function inspiry_edit_service_columns( $columns ) {

			$columns = array(
				'cb'              => '<input type="checkbox" />',
				'title'           => esc_html__( 'Title', 'builderpress-pack' ),
				"thumbnail"       => esc_html__( 'Photo', 'builderpress-pack' ),
				"related-project" => esc_html__( 'Related Projects', 'builderpress-pack' ),
				'date'            => esc_html__( 'Date', 'builderpress-pack' )
			);

			return $columns;
		}
	}
	function inspiry_service_columns_content( $column_name ) {
		switch ( $column_name ) {
			case 'thumbnail':
				if ( has_post_thumbnail( get_the_ID() ) ) {
					?><a href="<?php the_permalink(); ?>" target="_blank"><?php the_post_thumbnail( array(
						130,
						130
					) ); ?></a><?php
				} else {
					esc_html_e( 'NA', 'builderpress-pack' );
				}
				break;

			case 'related-project':
				$project_to_service = get_post_meta( get_the_ID(), 'bp-listed-projects-to-service', false );
				if ( ! empty( $project_to_service ) ) {

					$args = array(
						'post_type'      => 'project',
						'posts_per_page' => 100,
						'post__in'       => $project_to_service

					);

					$query = new WP_Query( $args );
					if ( $query->have_posts() ):
						?>
						<ul style="list-style: disc">
							<?php
							while ( $query->have_posts() ):
								$query->the_post();
								?>
								<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>

								<?php
							endwhile;
							wp_reset_postdata();
							?>
						</ul>
						<?php
					endif;
				}
				break;
			default:
				break;
		}

	}

}

/*-----------------------------------------------------------------------------------*/
/*	User Social Profile To Contact Info
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'inspiry_user_social_profiles' ) ) :
	/**
	 * Adds user social profiles to contact info.
	 *
	 * @since 1.0.0
	 *
	 * @param array $user_contact
	 *
	 * @return array Array of contact methods with theme additions.
	 */
	function inspiry_user_social_profiles( $user_contact ) {
		$user_contact['inspiry_twitter_url']   = esc_html__( 'Twitter URL', 'inspiry-builderpress' );
		$user_contact['inspiry_facebook_url']  = esc_html__( 'Facebook URL', 'inspiry-builderpress' );
		$user_contact['inspiry_google_url']    = esc_html__( 'Google Plus URL', 'inspiry-builderpress' );
		$user_contact['inspiry_youtube_url']   = esc_html__( 'Youtube URL', 'inspiry-builderpress' );
		$user_contact['inspiry_instagram_url'] = esc_html__( 'Instagram URL', 'inspiry-builderpress' );

		return $user_contact;
	}

	add_filter( 'user_contactmethods', 'inspiry_user_social_profiles' );

endif;

/*-----------------------------------------------------------------------------------*/
/*	Shortcodes included
/*-----------------------------------------------------------------------------------*/
include_once ( plugin_dir_path( __FILE__ ) . 'inc/vc-elements/inspiry-vc-functions.php' );
include_once ( plugin_dir_path( __FILE__ ) . 'inc/shortcodes/shortcodes.php' );