/**ABDB**/CREATE TABLE `#__ak_params` (
  `tag` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ak_params`  VALUES 
('update_version', '3.6.1');
/**ABDB**/CREATE TABLE `#__ak_profiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` longtext COLLATE utf8mb4_unicode_ci,
  `filters` longtext COLLATE utf8mb4_unicode_ci,
  `quickicon` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ak_profiles`  VALUES 
('1', 'Default Backup Profile', '###AES128###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', '', '1');
/**ABDB**/CREATE TABLE `#__ak_stats` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` longtext COLLATE utf8mb4_unicode_ci,
  `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` enum('run','fail','complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'run',
  `origin` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'backend',
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'full',
  `profile_id` bigint(20) NOT NULL DEFAULT '1',
  `archivename` longtext COLLATE utf8mb4_unicode_ci,
  `absolute_path` longtext COLLATE utf8mb4_unicode_ci,
  `multipart` int(11) NOT NULL DEFAULT '0',
  `tag` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backupid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesexist` tinyint(3) NOT NULL DEFAULT '1',
  `remote_filename` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_size` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fullstatus` (`filesexist`,`status`),
  KEY `idx_stale` (`status`,`origin`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ak_stats`  VALUES 
('1', 'Backup taken on Thursday, 21 November 2019 10:20', '', '2019-11-21 10:20:34', '0000-00-00 00:00:00', 'complete', 'backend', 'full', '1', 'site-portal.osmiumhostmanager.com-20191121-102034utc.zip', '/home/portalosmiumhost/public_html/wp-content/plugins/akeebabackupwp/app/backups/site-portal.osmiumhostmanager.com-20191121-102034utc.zip', '0', 'backend', 'id1', '1', NULL, '0');
/**ABDB**/CREATE TABLE `#__ak_storage` (
  `tag` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ak_storage`  VALUES 
('liveupdate_lastcheck', '2019-11-21 10:20:04', '1574331604'),
('liveupdate', '2019-11-21 10:20:04', '{\"stuck\":0,\"software\":\"Akeeba Backup for WordPress\",\"version\":\"3.6.1\",\"link\":\"https:\\/\\/www.akeebabackup.com\\/download\\/backupwp\\/3-6-1\\/akeebabackupwp-3-6-1-pro-zip.zip\",\"date\":\"2019-10-21\",\"releasenotes\":\"<h3>What\'s new<\\/h3><p>    <strong>Database dump produces multiline queries, supports PROCEDUREs, FUNCTIONs and TRIGGERs even better<\\/strong>.    In the past, Akeeba Backup\'s database dumps generated single line queries for all data definition language and    insert queries. While this works great for all tables and views and most procedures, functions and triggers there    were some cases where the latter three entities were corrupt or impossible to restore e.g. when their definition    included comments or required preservation of whitespace. The backup and restoration engines have now been updated    to create and restore multiline queries, much like you\'d get with mysqldump\\/mysql or phpMyAdmin. As a result the    more complicated procedures, functions and triggers are now supported. IMPORTANT! Your database user must still be    able to retrieve the definition of these databases entities to run a backup and define or overwrite them to restore    the backup. These are limitations imposed by MySQL and controlled exclusively by MySQL privileges. Akeeba Backup    CAN NOT magically override your database access control features \\u2013 such a thing is <em>impossible<\\/em>.<\\/p><p>    <strong>Preliminary work for PHP future 7.4 compatibility<\\/strong>. This work is experimental since PHP 7.4 is still    in alpha.<\\/p><p>    <strong>Akeeba Backup for WordPress: Prevent site display and show link to the restoration script when the    installation folder is present and contains ANGIE<\\/strong>.    In the past we had a few users who were confused as to how the restoration of their database content is supposed to    work because, apparently, they didn\'t read the text on their screen when extracting the backup archive. Moreover, we    had users who left the installation folder on their site after restoration, despite a clear warning about the    security implications of that on their screen. We can\'t force people to read their screens unless we also prevent    them from doing anything else. This is exactly our solution now! The Akeeba Backup for WordPress plugin will disable    access to the site if the restoration script is present, telling people to either run the restoration script to    finalize their site\'s restoration or, if they already did that, to delete the installation folder.<\\/p><p>    <strong>Bug fixes<\\/strong>. We regularly fix smaller and bigger issues. Please consult the CHANGELOG below and the full change history available from the software\'s main page by clicking the CHANGELOG button.<\\/p><h3>PHP versions supported<\\/h3><p>    We only officially support using our software with PHP 5.6, 7.1, 7.2 or 7.3. We strongly advise you to run the latest available version of PHP on a branch currently maintained by the PHP project for security and performance reasons. Older versions of PHP have known major security issues which are being actively exploited to hack sites and they have stopped receiving security updates, leaving you exposed to these issues. Moreover, they are slower, therefore consuming more server resources to perform the same tasks.<\\/p><p>    Kindly note that our policy is to officially support only the PHP versions which are not yet End Of Life per the official PHP project with a voluntarily extension of support for 6 to 9 months after they become End of Life. After that time we stop providing any support for these obsolete versions of PHP without any further notice.<\\/p><h3>WordPress versions supported<\\/h3><p>    We officially support only the latest WordPress 4.9 and 5.x release.<\\/p><p>    We have received reports that Akeeba Backup for WordPress has been installed on WordPress sites as old as 3.8.    Backing up and restoring sites that old should be possible but it\'s not tested and not officially supported. It is a    bad idea running an unsupported version of WordPress due to security and performance concerns.<\\/p><h3>Changelog<\\/h3><h4>Bug fixes<\\/h4><ul>\\t<li>[HIGH] Obsolete backup record quotas would also remove Remote records<\\/li>\\t<li>[LOW] Fixed ALICE memory check when the server has no limit set<\\/li>\\t<li>[LOW] Obsolete backup record quotas would not run when there are no \\\"OK\\\" (files locally present) backup records in the backup profile<\\/li>\\t<li>[LOW] Transfer wizard, Yes\\/No switches rendered without styling<\\/li>\\t<li>[MEDIUM] WordPress restoration: blog name and tagline were not updated<\\/li><\\/ul><h4>New features<\\/h4><ul>\\t<li>Database dump produces multiline queries, supports PROCEDUREs, FUNCTIONs and TRIGGERs even better<\\/li><\\/ul><h4>Miscellaneous changes<\\/h4><ul>\\t<li>Preliminary work for PHP future 7.4 compatibility<\\/li><\\/ul>\",\"infourl\":\"https:\\/\\/www.akeebabackup.com\\/download\\/backupwp\\/3-6-1.html\",\"md5\":\"e7e5355d4e044fa112bbccc92789f519\",\"sha1\":\"82ce66ca68c78f248f11908e9f0c80da84d3e60d\",\"sha256\":\"96750c69f979c9ee0dceef692136441a81cfd1f541a7ceed02119b30f04eb395\",\"sha384\":\"a99c788e2a18e6547ec8228ddc0546ba2ee6046f59c8e08a98907c143b0af88d21277c8468800e7db01d5ae4b3811bc8\",\"sha512\":\"9a8a492ba9a3bf6a79e7934c5ab7d4a5a81d4010e47936a357df763bf80b36dfac28484f0360a627a64a8e57908d9afce743471ad8fbac4a2f8449bf5619d8fb\",\"platforms\":\"classicpress\\/1.0,php\\/5.6,php\\/7.0,php\\/7.1,php\\/7.2,php\\/7.3,wordpress\\/3.8+\",\"loadedUpdate\":1,\"stability\":\"stable\"}');
/**ABDB**/CREATE TABLE `#__ak_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parameters` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__akeeba_common` (
  `key` varchar(190) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeeba_common`  VALUES 
('stats_siteurl', '1f77c7aa556253ff5e94a597cf4611bb'),
('stats_siteid', '34e78733c52c69ca27045fdb43101e67e841679d'),
('stats_lastrun', '1574331474');
/**ABDB**/CREATE TABLE `#__commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/**ABDB**/INSERT INTO `#__commentmeta`  VALUES 
('1', '2', 'rating', '5'),
('2', '2', 'verified', '0'),
('3', '2', '_wxr_import_user', '1'),
('4', '3', 'rating', '5'),
('5', '3', 'verified', '0'),
('6', '3', '_wxr_import_user', '1'),
('7', '4', 'rating', '2'),
('8', '4', 'verified', '0'),
('9', '4', '_wxr_import_user', '1'),
('10', '5', 'rating', '5'),
('11', '5', 'verified', '0'),
('12', '5', '_wxr_import_user', '1'),
('13', '6', 'rating', '3'),
('14', '6', 'verified', '0'),
('15', '6', '_wxr_import_user', '1'),
('16', '7', 'rating', '4'),
('17', '7', 'verified', '0'),
('18', '7', '_wxr_import_user', '1');
/**ABDB**/CREATE TABLE `#__comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/**ABDB**/INSERT INTO `#__comments`  VALUES 
('2', '167', 'John Doe', 'robot@inspirythemes.com', 'http://inspirythemes.com/', '39.55.125.129', '2017-04-19 17:29:17', '2017-04-19 17:29:17', 'This is a test review for demo purpose. Morbi leo risus, porta ac consectetur ac, vestibulum at eros.', '0', '1', '', '', '0', '0'),
('3', '178', 'John Doe', 'robot@inspirythemes.com', 'http://inspirythemes.com/', '39.55.125.129', '2017-04-19 17:30:41', '2017-04-19 17:30:41', 'This review is for demo purpose only. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Morbi leo risus, porta ac consectetur ac, vestibulum at eros.', '0', '1', '', '', '0', '0'),
('4', '184', 'John Doe', 'robot@inspirythemes.com', 'http://inspirythemes.com/', '39.55.125.129', '2017-04-19 17:32:11', '2017-04-19 17:32:11', 'BuilderPress provides an amazing design. Morbi leo risus, porta ac consectetur ac, vestibulum at eros.', '0', '1', '', '', '0', '0'),
('5', '188', 'John Doe', 'robot@inspirythemes.com', 'http://inspirythemes.com/', '39.55.125.129', '2017-04-19 17:31:32', '2017-04-19 17:31:32', 'Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Morbi leo risus, porta ac consectetur ac, vestibulum at eros.', '0', '1', '', '', '0', '0'),
('6', '192', 'John Doe', 'robot@inspirythemes.com', 'http://inspirythemes.com/', '39.55.125.129', '2017-04-19 17:31:13', '2017-04-19 17:31:13', 'Morbi leo risus, porta ac consectetur ac, vestibulum at eros. This is a demo review.', '0', '1', '', '', '0', '0'),
('7', '194', 'John Doe', 'robot@inspirythemes.com', 'http://inspirythemes.com/', '39.55.125.129', '2017-04-19 17:30:09', '2017-04-19 17:30:09', 'This review is for demo purpose only. Morbi leo risus, porta ac consectetur ac, vestibulum at eros.', '0', '1', '', '', '0', '0');
/**ABDB**/CREATE TABLE `#__links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/**ABDB**/CREATE TABLE `#__options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=2134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/**ABDB**/INSERT INTO `#__options`  VALUES 
('1', 'siteurl', 'http://portal.osmiumhostmanager.com', 'yes'),
('2', 'home', 'http://portal.osmiumhostmanager.com', 'yes'),
('3', 'blogname', 'Smartbuilders CRM', 'yes'),
('4', 'blogdescription', 'CRM for Home Builders', 'yes'),
('5', 'users_can_register', '0', 'yes'),
('6', 'admin_email', 'dmmdust@gmail.com', 'yes'),
('7', 'start_of_week', '1', 'yes'),
('8', 'use_balanceTags', '0', 'yes'),
('9', 'use_smilies', '1', 'yes'),
('10', 'require_name_email', '1', 'yes'),
('11', 'comments_notify', '1', 'yes'),
('12', 'posts_per_rss', '10', 'yes'),
('13', 'rss_use_excerpt', '0', 'yes'),
('14', 'mailserver_url', 'mail.example.com', 'yes'),
('15', 'mailserver_login', 'login@example.com', 'yes'),
('16', 'mailserver_pass', 'password', 'yes'),
('17', 'mailserver_port', '110', 'yes'),
('18', 'default_category', '1', 'yes'),
('19', 'default_comment_status', 'open', 'yes'),
('20', 'default_ping_status', 'open', 'yes'),
('21', 'default_pingback_flag', '0', 'yes'),
('22', 'posts_per_page', '10', 'yes'),
('23', 'date_format', 'F j, Y', 'yes'),
('24', 'time_format', 'g:i a', 'yes'),
('25', 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
('26', 'comment_moderation', '0', 'yes'),
('27', 'moderation_notify', '1', 'yes'),
('28', 'permalink_structure', '/%postname%/', 'yes'),
('29', 'rewrite_rules', 'a:190:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:19:\"product-features/?$\";s:27:\"index.php?post_type=service\";s:49:\"product-features/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=service&feed=$matches[1]\";s:44:\"product-features/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=service&feed=$matches[1]\";s:36:\"product-features/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=service&paged=$matches[1]\";s:11:\"projects/?$\";s:27:\"index.php?post_type=project\";s:41:\"projects/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:36:\"projects/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:28:\"projects/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"project-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project-category=$matches[1]&feed=$matches[2]\";s:52:\"project-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project-category=$matches[1]&feed=$matches[2]\";s:33:\"project-category/([^/]+)/embed/?$\";s:49:\"index.php?project-category=$matches[1]&embed=true\";s:45:\"project-category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project-category=$matches[1]&paged=$matches[2]\";s:27:\"project-category/([^/]+)/?$\";s:38:\"index.php?project-category=$matches[1]\";s:44:\"product-features/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"product-features/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"product-features/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"product-features/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"product-features/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"product-features/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"product-features/([^/]+)/embed/?$\";s:40:\"index.php?service=$matches[1]&embed=true\";s:37:\"product-features/([^/]+)/trackback/?$\";s:34:\"index.php?service=$matches[1]&tb=1\";s:57:\"product-features/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?service=$matches[1]&feed=$matches[2]\";s:52:\"product-features/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?service=$matches[1]&feed=$matches[2]\";s:45:\"product-features/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?service=$matches[1]&paged=$matches[2]\";s:52:\"product-features/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?service=$matches[1]&cpage=$matches[2]\";s:41:\"product-features/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?service=$matches[1]&page=$matches[2]\";s:33:\"product-features/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"product-features/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"product-features/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"product-features/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"product-features/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"product-features/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"projects/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"projects/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"projects/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"projects/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"projects/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"projects/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"projects/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:29:\"projects/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:49:\"projects/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:44:\"projects/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:37:\"projects/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:44:\"projects/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:33:\"projects/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:25:\"projects/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"projects/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"projects/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"projects/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"projects/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"projects/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"members/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"members/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"members/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"members/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"members/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"members/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"members/([^/]+)/embed/?$\";s:40:\"index.php?members=$matches[1]&embed=true\";s:28:\"members/([^/]+)/trackback/?$\";s:34:\"index.php?members=$matches[1]&tb=1\";s:36:\"members/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?members=$matches[1]&paged=$matches[2]\";s:43:\"members/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?members=$matches[1]&cpage=$matches[2]\";s:32:\"members/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?members=$matches[1]&page=$matches[2]\";s:24:\"members/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"members/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"members/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"members/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"members/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"members/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=141&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}', 'yes'),
('30', 'hack_file', '0', 'yes'),
('31', 'blog_charset', 'UTF-8', 'yes'),
('32', 'moderation_keys', '', 'no'),
('33', 'active_plugins', 'a:8:{i:0;s:33:\"akeebabackupwp/akeebabackupwp.php\";i:1;s:39:\"builderpress-pack/builderpress-pack.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:29:\"easy-wp-smtp/easy-wp-smtp.php\";i:4;s:27:\"js_composer/js_composer.php\";i:5;s:21:\"meta-box/meta-box.php\";i:6;s:47:\"one-click-demo-import/one-click-demo-import.php\";i:7;s:59:\"quick-and-easy-testimonials/quick-and-easy-testimonials.php\";}', 'yes'),
('34', 'category_base', '', 'yes'),
('35', 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
('36', 'comment_max_links', '2', 'yes'),
('37', 'gmt_offset', '0', 'yes'),
('38', 'default_email_category', '1', 'yes'),
('39', 'recently_edited', 'a:2:{i:0;s:81:\"/var/www/crm.toolasoft.com/wp-content/themes/inspiry-builderpress-child/style.css\";i:1;s:0:\"\";}', 'no'),
('40', 'template', 'inspiry-builderpress', 'yes'),
('41', 'stylesheet', 'inspiry-builderpress-child', 'yes'),
('42', 'comment_whitelist', '1', 'yes'),
('43', 'blacklist_keys', '', 'no'),
('44', 'comment_registration', '0', 'yes'),
('45', 'html_type', 'text/html', 'yes'),
('46', 'use_trackback', '0', 'yes'),
('47', 'default_role', 'subscriber', 'yes'),
('48', 'db_version', '45805', 'yes'),
('49', 'uploads_use_yearmonth_folders', '1', 'yes'),
('50', 'upload_path', '', 'yes'),
('51', 'blog_public', '0', 'yes'),
('52', 'default_link_category', '2', 'yes'),
('53', 'show_on_front', 'page', 'yes'),
('54', 'tag_base', '', 'yes'),
('55', 'show_avatars', '1', 'yes'),
('56', 'avatar_rating', 'G', 'yes'),
('57', 'upload_url_path', '', 'yes'),
('58', 'thumbnail_size_w', '150', 'yes'),
('59', 'thumbnail_size_h', '150', 'yes'),
('60', 'thumbnail_crop', '1', 'yes'),
('61', 'medium_size_w', '300', 'yes'),
('62', 'medium_size_h', '300', 'yes'),
('63', 'avatar_default', 'mystery', 'yes'),
('64', 'large_size_w', '1024', 'yes'),
('65', 'large_size_h', '1024', 'yes'),
('66', 'image_default_link_type', 'none', 'yes'),
('67', 'image_default_size', '', 'yes'),
('68', 'image_default_align', '', 'yes'),
('69', 'close_comments_for_old_posts', '0', 'yes'),
('70', 'close_comments_days_old', '14', 'yes'),
('71', 'thread_comments', '1', 'yes'),
('72', 'thread_comments_depth', '5', 'yes'),
('73', 'page_comments', '0', 'yes'),
('74', 'comments_per_page', '50', 'yes'),
('75', 'default_comments_page', 'newest', 'yes'),
('76', 'comment_order', 'asc', 'yes'),
('77', 'sticky_posts', 'a:0:{}', 'yes'),
('78', 'widget_categories', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('79', 'widget_text', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
('80', 'widget_rss', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
('81', 'uninstall_plugins', 'a:2:{s:29:\"easy-wp-smtp/easy-wp-smtp.php\";s:17:\"swpsmtp_uninstall\";s:33:\"akeebabackupwp/akeebabackupwp.php\";a:2:{i:0;s:14:\"AkeebaBackupWP\";i:1;s:9:\"uninstall\";}}', 'no'),
('82', 'timezone_string', '', 'yes'),
('83', 'page_for_posts', '139', 'yes'),
('84', 'page_on_front', '141', 'yes'),
('85', 'default_post_format', '0', 'yes'),
('86', 'link_manager_enabled', '0', 'yes'),
('87', 'finished_splitting_shared_terms', '1', 'yes'),
('88', 'site_icon', '673', 'yes'),
('89', 'medium_large_size_w', '768', 'yes'),
('90', 'medium_large_size_h', '0', 'yes'),
('91', 'wp_page_for_privacy_policy', '', 'yes'),
('92', 'show_comments_cookies_opt_in', '0', 'yes'),
('93', 'initial_db_version', '38590', 'yes'),
('94', 'wp_user_roles', 'a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:114:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}', 'yes'),
('95', 'fresh_site', '0', 'yes'),
('96', 'widget_search', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('97', 'widget_recent-posts', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('98', 'widget_recent-comments', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('99', 'widget_archives', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('100', 'widget_meta', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('101', 'sidebars_widgets', 'a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"default-sidebar\";a:1:{i:0;s:38:\"inspiry_recent_posts_with_thumbnails-1\";}s:17:\"footer-1st-column\";a:1:{i:0;s:31:\"inspiry_builderpress_services-1\";}s:17:\"footer-2nd-column\";a:1:{i:0;s:10:\"nav_menu-2\";}s:17:\"footer-3rd-column\";a:1:{i:0;s:38:\"inspiry_recent_posts_with_thumbnails-3\";}s:17:\"footer-4th-column\";a:1:{i:0;s:22:\"inspiry_contact_list-1\";}s:13:\"array_version\";i:3;}', 'yes'),
('102', 'widget_pages', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('103', 'widget_calendar', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('104', 'widget_media_audio', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('105', 'widget_media_image', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('106', 'widget_media_gallery', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('107', 'widget_media_video', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('108', 'widget_tag_cloud', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('109', 'widget_nav_menu', 'a:2:{i:2;a:2:{s:5:\"title\";s:11:\"Quick Links\";s:8:\"nav_menu\";i:41;}s:12:\"_multiwidget\";i:1;}', 'yes'),
('110', 'widget_custom_html', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('111', 'cron', 'a:12:{i:1574333234;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1574333768;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1574338654;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"6182248e6f43e5483da886a89416eda3\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:678;}}}}i:1574354834;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1574380800;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1574398046;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1574398568;a:1:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1574398578;a:1:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1574404990;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1574409368;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1574417714;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}', 'yes'),
('112', 'theme_mods_twentyseventeen', 'a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1539924457;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}', 'yes'),
('138', 'current_theme', 'Inspiry BuilderPress Child', 'yes'),
('139', 'theme_mods_inspiry-builderpress', 'a:35:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:41;}s:18:\"custom_css_post_id\";i:427;s:27:\"inspiry_google_maps_api_key\";s:39:\"AIzaSyD9H1v86oL8VDiWwUT8cDq1Yn4Hd_DKNO8\";s:19:\"inspiry-cta-heading\";s:60:\"Looking for a professional team to build your dream project?\";s:16:\"inspiry-cta-text\";s:75:\"We offer the top-notch construction services to make your dreams come true.\";s:23:\"inspiry-cta-button-text\";s:11:\"Get A Quote\";s:16:\"inspiry-cta-page\";s:2:\"11\";s:27:\"inspiry-shop-posts-per-page\";s:1:\"9\";s:15:\"header-tag-line\";s:32:\"Builder and Developer Since 1980\";s:12:\"working-days\";s:10:\"Mon to Fri\";s:13:\"working-hours\";s:14:\"09:00 to 05:00\";s:10:\"close-days\";s:0:\"\";s:10:\"close-text\";s:0:\"\";s:19:\"contact-phone-label\";s:9:\"Toll Free\";s:20:\"contact-phone-number\";s:14:\"1-800-555-1234\";s:19:\"contact-email-label\";s:5:\"Email\";s:21:\"contact-email-address\";s:21:\"info@builderpress.com\";s:25:\"inspiry-header-quote-text\";s:11:\"Get A Quote\";s:25:\"inspiry-header-quote-page\";s:2:\"11\";s:22:\"enable-top-social-link\";s:4:\"true\";s:12:\"twitter-link\";s:33:\"https://twitter.com/inspirythemes\";s:13:\"facebook-link\";s:33:\"https://twitter.com/inspirythemes\";s:11:\"google-link\";s:31:\"https://plus.google.com/+envato\";s:12:\"youtube-link\";s:35:\"https://www.youtube.com/user/Envato\";s:14:\"instagram-link\";s:33:\"https://www.instagram.com/envato/\";s:21:\"inspiry_header_layout\";s:3:\"one\";s:19:\"inspiry-footer-logo\";s:70:\"http://localhost/buildpress/wp-content/uploads/2018/10/footer-logo.png\";s:19:\"inspiry-footer-text\";s:195:\"Leverage agile frameworks to provide a robust synopsis for high level overviews. Iterative approaches to corporate strategy foster collaborative thinking to further the overall value proposition.\";s:24:\"inspiry-know-more-button\";s:9:\"Know More\";s:23:\"inspiry-footer-btn-link\";s:3:\"202\";s:22:\"inspiry-copyright-text\";s:56:\"© Copyright 2017. All Rights Reserved by InspiryThemes.\";s:11:\"custom_logo\";i:510;s:17:\"inspiry_page_load\";s:5:\"false\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1539949939;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"default-sidebar\";a:8:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";i:6;s:38:\"inspiry_recent_posts_with_thumbnails-1\";i:7;s:11:\"tag_cloud-1\";}s:17:\"footer-1st-column\";a:1:{i:0;s:31:\"inspiry_builderpress_services-1\";}s:17:\"footer-2nd-column\";a:1:{i:0;s:38:\"inspiry_recent_posts_with_thumbnails-2\";}s:17:\"footer-3rd-column\";a:1:{i:0;s:38:\"inspiry_recent_posts_with_thumbnails-3\";}s:17:\"footer-4th-column\";a:1:{i:0;s:22:\"inspiry_contact_list-1\";}s:4:\"shop\";a:5:{i:0;s:25:\"woocommerce_widget_cart-1\";i:1;s:26:\"woocommerce_price_filter-1\";i:2;s:22:\"woocommerce_products-1\";i:3;s:32:\"woocommerce_product_categories-1\";i:4;s:32:\"woocommerce_top_rated_products-1\";}}}}', 'yes'),
('140', 'theme_switched', '', 'yes'),
('141', 'widget_inspiry_recent_posts_with_thumbnails', 'a:3:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:8:\"posttype\";s:4:\"post\";s:6:\"number\";i:5;}i:3;a:3:{s:5:\"title\";s:10:\"Blog Posts\";s:8:\"posttype\";s:4:\"post\";s:6:\"number\";i:3;}s:12:\"_multiwidget\";i:1;}', 'yes'),
('142', 'widget_inspiry_builderpress_services', 'a:2:{i:1;a:1:{s:5:\"title\";s:16:\"Product Features\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
('143', 'widget_inspiry_contact_list', 'a:2:{i:1;a:5:{s:5:\"title\";s:12:\"Get in Touch\";s:5:\"phone\";s:11:\"+1 0000 000\";s:3:\"fax\";s:0:\"\";s:5:\"email\";s:33:\"info@portal.osmiumhostmanager.com\";s:7:\"address\";s:42:\"03. Bentam Street, VIC, <br />\r\nAustralia.\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
('160', 'vc_version', '5.6', 'yes'),
('161', 'wpcf7', 'a:4:{s:7:\"version\";s:5:\"5.1.5\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1539924949;s:7:\"version\";s:5:\"5.0.4\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}s:9:\"recaptcha\";N;s:23:\"recaptcha_v2_v3_warning\";b:1;}', 'yes'),
('164', 'woocommerce_store_address', '', 'yes'),
('165', 'woocommerce_store_address_2', '', 'yes'),
('166', 'woocommerce_store_city', '', 'yes'),
('167', 'woocommerce_default_country', 'GB', 'yes'),
('168', 'woocommerce_store_postcode', '', 'yes'),
('169', 'woocommerce_allowed_countries', 'all', 'yes'),
('170', 'woocommerce_all_except_countries', '', 'yes'),
('171', 'woocommerce_specific_allowed_countries', '', 'yes'),
('172', 'woocommerce_ship_to_countries', '', 'yes'),
('173', 'woocommerce_specific_ship_to_countries', '', 'yes'),
('174', 'woocommerce_default_customer_address', 'geolocation', 'yes'),
('175', 'woocommerce_calc_taxes', 'no', 'yes'),
('176', 'woocommerce_enable_coupons', 'yes', 'yes'),
('177', 'woocommerce_calc_discounts_sequentially', 'no', 'no'),
('178', 'woocommerce_currency', 'GBP', 'yes'),
('179', 'woocommerce_currency_pos', 'left', 'yes'),
('180', 'woocommerce_price_thousand_sep', ',', 'yes'),
('181', 'woocommerce_price_decimal_sep', '.', 'yes'),
('182', 'woocommerce_price_num_decimals', '2', 'yes'),
('183', 'woocommerce_shop_page_id', '', 'yes'),
('184', 'woocommerce_cart_redirect_after_add', 'no', 'yes'),
('185', 'woocommerce_enable_ajax_add_to_cart', 'yes', 'yes'),
('186', 'woocommerce_weight_unit', 'kg', 'yes'),
('187', 'woocommerce_dimension_unit', 'cm', 'yes'),
('188', 'woocommerce_enable_reviews', 'yes', 'yes'),
('189', 'woocommerce_review_rating_verification_label', 'yes', 'no'),
('190', 'woocommerce_review_rating_verification_required', 'no', 'no'),
('191', 'woocommerce_enable_review_rating', 'yes', 'yes'),
('192', 'woocommerce_review_rating_required', 'yes', 'no'),
('193', 'woocommerce_manage_stock', 'yes', 'yes'),
('194', 'woocommerce_hold_stock_minutes', '60', 'no'),
('195', 'woocommerce_notify_low_stock', 'yes', 'no'),
('196', 'woocommerce_notify_no_stock', 'yes', 'no'),
('197', 'woocommerce_stock_email_recipient', 'dmmdust@gmail.com', 'no'),
('198', 'woocommerce_notify_low_stock_amount', '2', 'no'),
('199', 'woocommerce_notify_no_stock_amount', '0', 'yes'),
('200', 'woocommerce_hide_out_of_stock_items', 'no', 'yes'),
('201', 'woocommerce_stock_format', '', 'yes'),
('202', 'woocommerce_file_download_method', 'force', 'no'),
('203', 'woocommerce_downloads_require_login', 'no', 'no'),
('204', 'woocommerce_downloads_grant_access_after_payment', 'yes', 'no'),
('205', 'woocommerce_prices_include_tax', 'no', 'yes'),
('206', 'woocommerce_tax_based_on', 'shipping', 'yes'),
('207', 'woocommerce_shipping_tax_class', 'inherit', 'yes'),
('208', 'woocommerce_tax_round_at_subtotal', 'no', 'yes'),
('209', 'woocommerce_tax_classes', 'Reduced rate\r\nZero rate', 'yes'),
('210', 'woocommerce_tax_display_shop', 'excl', 'yes'),
('211', 'woocommerce_tax_display_cart', 'excl', 'yes'),
('212', 'woocommerce_price_display_suffix', '', 'yes'),
('213', 'woocommerce_tax_total_display', 'itemized', 'no'),
('214', 'woocommerce_enable_shipping_calc', 'yes', 'no'),
('215', 'woocommerce_shipping_cost_requires_address', 'no', 'yes'),
('216', 'woocommerce_ship_to_destination', 'billing', 'no'),
('217', 'woocommerce_shipping_debug_mode', 'no', 'yes'),
('218', 'woocommerce_enable_guest_checkout', 'yes', 'no'),
('219', 'woocommerce_enable_checkout_login_reminder', 'no', 'no'),
('220', 'woocommerce_enable_signup_and_login_from_checkout', 'no', 'no'),
('221', 'woocommerce_enable_myaccount_registration', 'no', 'no'),
('222', 'woocommerce_registration_generate_username', 'yes', 'no'),
('223', 'woocommerce_registration_generate_password', 'yes', 'no'),
('224', 'woocommerce_erasure_request_removes_order_data', 'no', 'no'),
('225', 'woocommerce_erasure_request_removes_download_data', 'no', 'no'),
('226', 'woocommerce_registration_privacy_policy_text', 'Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our [privacy_policy].', 'yes'),
('227', 'woocommerce_checkout_privacy_policy_text', 'Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our [privacy_policy].', 'yes'),
('228', 'woocommerce_delete_inactive_accounts', 'a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}', 'no'),
('229', 'woocommerce_trash_pending_orders', '', 'no'),
('230', 'woocommerce_trash_failed_orders', '', 'no'),
('231', 'woocommerce_trash_cancelled_orders', '', 'no'),
('232', 'woocommerce_anonymize_completed_orders', 'a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}', 'no'),
('233', 'woocommerce_email_from_name', 'ToolaSoft Builders CRM', 'no'),
('234', 'woocommerce_email_from_address', 'dmmdust@gmail.com', 'no'),
('235', 'woocommerce_email_header_image', '', 'no'),
('236', 'woocommerce_email_footer_text', '{site_title}', 'no'),
('237', 'woocommerce_email_base_color', '#96588a', 'no'),
('238', 'woocommerce_email_background_color', '#f7f7f7', 'no'),
('239', 'woocommerce_email_body_background_color', '#ffffff', 'no'),
('240', 'woocommerce_email_text_color', '#3c3c3c', 'no'),
('241', 'woocommerce_cart_page_id', '', 'yes'),
('242', 'woocommerce_checkout_page_id', '', 'yes'),
('243', 'woocommerce_myaccount_page_id', '', 'yes'),
('244', 'woocommerce_terms_page_id', '', 'no'),
('245', 'woocommerce_force_ssl_checkout', 'no', 'yes'),
('246', 'woocommerce_unforce_ssl_checkout', 'no', 'yes'),
('247', 'woocommerce_checkout_pay_endpoint', 'order-pay', 'yes'),
('248', 'woocommerce_checkout_order_received_endpoint', 'order-received', 'yes'),
('249', 'woocommerce_myaccount_add_payment_method_endpoint', 'add-payment-method', 'yes'),
('250', 'woocommerce_myaccount_delete_payment_method_endpoint', 'delete-payment-method', 'yes'),
('251', 'woocommerce_myaccount_set_default_payment_method_endpoint', 'set-default-payment-method', 'yes'),
('252', 'woocommerce_myaccount_orders_endpoint', 'orders', 'yes'),
('253', 'woocommerce_myaccount_view_order_endpoint', 'view-order', 'yes'),
('254', 'woocommerce_myaccount_downloads_endpoint', 'downloads', 'yes'),
('255', 'woocommerce_myaccount_edit_account_endpoint', 'edit-account', 'yes'),
('256', 'woocommerce_myaccount_edit_address_endpoint', 'edit-address', 'yes'),
('257', 'woocommerce_myaccount_payment_methods_endpoint', 'payment-methods', 'yes'),
('258', 'woocommerce_myaccount_lost_password_endpoint', 'lost-password', 'yes'),
('259', 'woocommerce_logout_endpoint', 'customer-logout', 'yes'),
('260', 'woocommerce_api_enabled', 'no', 'yes'),
('261', 'woocommerce_single_image_width', '600', 'yes'),
('262', 'woocommerce_thumbnail_image_width', '300', 'yes'),
('263', 'woocommerce_checkout_highlight_required_fields', 'yes', 'yes'),
('264', 'woocommerce_demo_store', 'no', 'no'),
('265', 'woocommerce_permalinks', 'a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}', 'yes'),
('266', 'current_theme_supports_woocommerce', 'yes', 'yes'),
('267', 'woocommerce_queue_flush_rewrite_rules', 'no', 'yes'),
('268', '_transient_wc_attribute_taxonomies', 'a:0:{}', 'yes'),
('270', 'default_product_cat', '15', 'yes'),
('273', 'woocommerce_version', '3.4.7', 'yes'),
('274', 'woocommerce_db_version', '3.4.7', 'yes'),
('275', 'woocommerce_admin_notices', 'a:3:{i:0;s:7:\"install\";i:1;s:20:\"no_secure_connection\";i:2;s:14:\"template_files\";}', 'yes'),
('276', '_transient_woocommerce_webhook_ids', 'a:0:{}', 'yes'),
('277', 'widget_woocommerce_widget_cart', 'a:2:{i:1;a:2:{s:5:\"title\";s:4:\"Cart\";s:13:\"hide_if_empty\";i:1;}s:12:\"_multiwidget\";i:1;}', 'yes'),
('278', 'widget_woocommerce_layered_nav_filters', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('279', 'widget_woocommerce_layered_nav', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('280', 'widget_woocommerce_price_filter', 'a:2:{i:1;a:1:{s:5:\"title\";s:15:\"Filter By Price\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
('281', 'widget_woocommerce_product_categories', 'a:2:{i:1;a:7:{s:5:\"title\";s:18:\"Product Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
('282', 'widget_woocommerce_product_search', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('283', 'widget_woocommerce_product_tag_cloud', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('284', 'widget_woocommerce_products', 'a:2:{i:1;a:7:{s:5:\"title\";s:16:\"Products on Sale\";s:6:\"number\";i:3;s:4:\"show\";s:6:\"onsale\";s:7:\"orderby\";s:4:\"rand\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
('285', 'widget_woocommerce_recently_viewed_products', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('286', 'widget_woocommerce_top_rated_products', 'a:2:{i:1;a:2:{s:5:\"title\";s:18:\"Top Rated Products\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
('287', 'widget_woocommerce_recent_reviews', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('288', 'widget_woocommerce_rating_filter', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('292', 'woocommerce_meta_box_errors', 'a:0:{}', 'yes'),
('308', '_transient_product_query-transient-version', '1539925153', 'yes'),
('309', 'category_children', 'a:0:{}', 'yes'),
('311', 'product_cat_children', 'a:0:{}', 'yes'),
('312', 'testimonial-category_children', 'a:0:{}', 'yes'),
('314', 'woocommerce_demo_store_notice', 'This is a demo store for testing purposes &mdash; no orders shall be fulfilled.', 'yes'),
('315', 'woocommerce_shop_page_display', '', 'yes'),
('316', 'woocommerce_category_archive_display', '', 'yes'),
('317', 'woocommerce_default_catalog_orderby', 'date', 'yes'),
('318', 'woocommerce_catalog_columns', '4', 'yes'),
('319', 'woocommerce_thumbnail_cropping', '1:1', 'yes'),
('320', 'woocommerce_thumbnail_cropping_custom_width', '4', 'yes'),
('321', 'woocommerce_thumbnail_cropping_custom_height', '3', 'yes'),
('322', 'woocommerce_checkout_company_field', 'optional', 'yes'),
('323', 'woocommerce_checkout_address_2_field', 'optional', 'yes'),
('324', 'woocommerce_checkout_phone_field', 'required', 'yes'),
('325', 'woocommerce_checkout_terms_and_conditions_checkbox_text', 'I have read and agree to the website [terms]', 'yes'),
('326', 'nav_menus_created_posts', 'a:0:{}', 'yes'),
('327', '_transient_wc_count_comments', 'O:8:\"stdClass\":7:{s:14:\"total_comments\";i:7;s:3:\"all\";i:7;s:8:\"approved\";s:1:\"7\";s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}', 'yes'),
('330', 'woocommerce_maybe_regenerate_images_hash', '991b1ca641921cf0f5baf7a2fe85861b', 'yes'),
('483', 'recently_activated', 'a:0:{}', 'yes'),
('484', 'revslider_servers', 'a:10:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-a.tools\";i:3;s:22:\"themepunch-ext-a.tools\";i:4;s:16:\"themepunch.tools\";i:5;s:22:\"themepunch-ext-a.tools\";i:6;s:22:\"themepunch-ext-a.tools\";i:7;s:22:\"themepunch-ext-a.tools\";i:8;s:22:\"themepunch-ext-a.tools\";i:9;s:22:\"themepunch-ext-a.tools\";}', 'yes'),
('485', 'revslider_server_refresh', '1539941047', 'yes'),
('486', 'revslider-update-check-short', '1539941047', 'yes'),
('487', 'revslider-templates-check', '1539941047', 'yes');
/**ABDB**/INSERT INTO `#__options`  VALUES 
('489', 'rs-templates', 'a:2:{s:6:\"slider\";a:232:{i:0;a:20:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:310:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:20:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:20:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:20:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:439:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:20:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:20:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:20:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:20:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:20:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:20:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:20:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:440:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:20:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:20:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:20:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:20:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:20:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:20:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:20:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:447:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:20:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:20:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:20:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:20:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:20:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:20:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:20:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:346:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:20:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:310:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:20:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:20:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:438:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:20:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:436:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:20:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:20:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:20:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:20:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:20:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:20:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:438:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:20:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:630:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:20:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:508:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:20:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:20:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:20:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:518:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:20:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:20:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:20:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:323:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:20:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:316:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:20:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:20:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:443:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:20:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:20:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:444:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:20:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:444:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:20:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:20:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:20:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:691:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:20:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:693:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:20:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:532:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:20:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:543:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:20:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:661:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:20:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:508:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:20:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:20:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:20:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:20:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:20:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:20:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:20:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:441:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:20:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:447:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:20:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:572:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/revslider-doc/add-on-whiteboard/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:20:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:516:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:23:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:23:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:23:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:23:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:23:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:448:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:23:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:23:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:23:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:23:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:23:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:23:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:23:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:23:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:23:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:23:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:23:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:20:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:20:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:20:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:20:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:23:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:23:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:23:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:23:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:23:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:23:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:23:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:23:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:20:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:20:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:23:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:23:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:23:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:23:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:23:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:20:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:20:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:20:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:105;a:23:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:106;a:23:{s:2:\"id\";s:3:\"108\";s:5:\"title\";s:23:\"Website Builder Package\";s:5:\"alias\";s:22:\"websitebuilder-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"websitebuilder-package\";s:3:\"img\";s:29:\"packages/template_group_2.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:107;a:23:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:108;a:23:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:20:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:426:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/revslider-doc/add-on-typewriter/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:20:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:111;a:23:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:23:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:23:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:23:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;a:23:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:116;a:23:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:117;a:23:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:118;a:23:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:119;a:23:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:120;a:23:{s:2:\"id\";s:3:\"122\";s:5:\"title\";s:20:\"Themeplicity Package\";s:5:\"alias\";s:20:\"themeplicity-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:20:\"themeplicity-package\";s:3:\"img\";s:38:\"packages/templatepack_themeplicity.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:121;a:23:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:122;a:23:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:123;a:23:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:124;a:23:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:125;a:23:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:126;a:23:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:127;a:23:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:128;a:23:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:129;a:23:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:130;a:23:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:568:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:131;a:20:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/80s-style-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:343:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:20:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/blur-effect-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:341:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:20:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/coming-soon-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:134;a:23:{s:2:\"id\";s:3:\"137\";s:5:\"title\";s:22:\"Nice And Clean Package\";s:5:\"alias\";s:22:\"nice-and-clean-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"nice-and-clean-package\";s:3:\"img\";s:38:\"packages/templatepack_niceandclean.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:242:\"<span class=\"ttm_content\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:135;a:20:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/snow-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:164:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:20:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/particle-effect-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:468:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:137;a:20:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/particle-effect-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:138;a:20:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/particle-background-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:463:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:139;a:20:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:421:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:140;a:20:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:190:\"[{\"path\":\"revslider-polyfold-addon\\/revslider-polyfold-addon.php\",\"name\":\"Polyfold Scroll Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:141;a:20:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:142;a:20:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/404-error-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:352:\"[{\"path\":\"revslider-404-addon\\/revslider-404-addon.php\",\"name\":\"404 Page Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"},{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:143;a:20:{s:2:\"id\";s:3:\"146\";s:5:\"title\";s:16:\"Carousel Gallery\";s:5:\"alias\";s:15:\"carouselgallery\";s:3:\"zip\";s:19:\"carouselgallery.zip\";s:3:\"uid\";s:32:\"041838fd32923c40e15c998f0ea19526\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-carousel-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:144;a:20:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:16:\"Filmstrip Effect\";s:5:\"alias\";s:9:\"filmstrip\";s:3:\"zip\";s:13:\"filmstrip.zip\";s:3:\"uid\";s:32:\"7bd142f272cc15d86998a79520e9e581\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/filmstrip-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\r\n There is lots of customization options like animation speed and direction.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:191:\"[{\"path\":\"revslider-filmstrip-addon\\/revslider-filmstrip-addon.php\",\"name\":\"Background FilmStrip Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:145;a:20:{s:2:\"id\";s:3:\"148\";s:5:\"title\";s:11:\"Space Opera\";s:5:\"alias\";s:10:\"spaceopera\";s:3:\"zip\";s:14:\"spaceopera.zip\";s:3:\"uid\";s:32:\"a2c8bffcb138a86c0f373adebb6de046\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/space-opera-presentation/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:146;a:20:{s:2:\"id\";s:3:\"149\";s:5:\"title\";s:13:\"Website Intro\";s:5:\"alias\";s:12:\"websiteintro\";s:3:\"zip\";s:16:\"websiteintro.zip\";s:3:\"uid\";s:32:\"348df76d999456aa19be58c9df56ae20\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/website-intro-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:274:\"<span class=\"ttm_content\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:147;a:20:{s:2:\"id\";s:3:\"150\";s:5:\"title\";s:13:\"Mask Showcase\";s:5:\"alias\";s:12:\"maskshowcase\";s:3:\"zip\";s:16:\"maskshowcase.zip\";s:3:\"uid\";s:32:\"fc943c31e2da9c63b252aeabf554d128\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/minimal-mask-showcase/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:148;a:20:{s:2:\"id\";s:3:\"151\";s:5:\"title\";s:20:\"Parallax Zoom Slices\";s:5:\"alias\";s:18:\"parallaxzoomslices\";s:3:\"zip\";s:22:\"parallaxzoomslices.zip\";s:3:\"uid\";s:32:\"83537cae05709ddb9bcb7375470a5894\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/parallax-zoom-slices-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:249:\"<span class=\"ttm_content\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:149;a:20:{s:2:\"id\";s:3:\"152\";s:5:\"title\";s:22:\"Double Exposure Effect\";s:5:\"alias\";s:20:\"doubleexposureeffect\";s:3:\"zip\";s:24:\"doubleexposureeffect.zip\";s:3:\"uid\";s:32:\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/wordpress-double-exposure-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:150;a:20:{s:2:\"id\";s:3:\"153\";s:5:\"title\";s:24:\"Mountain Parallax Header\";s:5:\"alias\";s:22:\"mountainparallaxheader\";s:3:\"zip\";s:26:\"mountainparallaxheader.zip\";s:3:\"uid\";s:32:\"8dc64663f317a2abdf179bbe341d016e\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/mountain-wordpress-parallax-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:192:\"<span class=\"ttm_content\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:151;a:23:{s:2:\"id\";s:3:\"154\";s:5:\"title\";s:26:\"GoodNews One-Pager Package\";s:5:\"alias\";s:26:\"goodnews-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"goodnews-one-pager-package\";s:3:\"img\";s:44:\"packages/templatepack_goodnews_one_pager.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:8:\"carousel\";i:1;s:6:\"slider\";i:2;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:152;a:23:{s:2:\"id\";s:3:\"155\";s:5:\"title\";s:13:\"GoodNews Menu\";s:5:\"alias\";s:12:\"goodnewsmenu\";s:3:\"zip\";s:22:\"packs/goodnewsmenu.zip\";s:3:\"uid\";s:32:\"4cbc82501ff340fcdc0acf7eb3ba2640\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:153;a:23:{s:2:\"id\";s:3:\"156\";s:5:\"title\";s:15:\"GoodNews Header\";s:5:\"alias\";s:14:\"goodnewsheader\";s:3:\"zip\";s:24:\"packs/goodnewsheader.zip\";s:3:\"uid\";s:32:\"c6660b6bdbf596f38466f569596f5259\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:154;a:23:{s:2:\"id\";s:3:\"157\";s:5:\"title\";s:18:\"GoodNews Whats Hot\";s:5:\"alias\";s:16:\"goodnewswhatshot\";s:3:\"zip\";s:26:\"packs/goodnewswhatshot.zip\";s:3:\"uid\";s:32:\"cb841ce64a99a6644adab049cf5405cd\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:155;a:23:{s:2:\"id\";s:3:\"158\";s:5:\"title\";s:17:\"GoodNews Featured\";s:5:\"alias\";s:16:\"goodnewsfeatured\";s:3:\"zip\";s:26:\"packs/goodnewsfeatured.zip\";s:3:\"uid\";s:32:\"00bde4b09e3700da7183999eaf137ccc\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:156;a:23:{s:2:\"id\";s:3:\"159\";s:5:\"title\";s:18:\"GoodNews Spotlight\";s:5:\"alias\";s:17:\"goodnewsspotlight\";s:3:\"zip\";s:27:\"packs/goodnewsspotlight.zip\";s:3:\"uid\";s:32:\"138076241a828e1c5764379944755f2b\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:157;a:23:{s:2:\"id\";s:3:\"160\";s:5:\"title\";s:17:\"GoodNews Carousel\";s:5:\"alias\";s:16:\"goodnewscarousel\";s:3:\"zip\";s:26:\"packs/goodnewscarousel.zip\";s:3:\"uid\";s:32:\"d29d4460a6015e30d08d2714232d3768\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:158;a:23:{s:2:\"id\";s:3:\"161\";s:5:\"title\";s:16:\"GoodNews Callout\";s:5:\"alias\";s:15:\"goodnewscallout\";s:3:\"zip\";s:25:\"packs/goodnewscallout.zip\";s:3:\"uid\";s:32:\"d9568b3193e96577fae630b3a6728785\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:159;a:23:{s:2:\"id\";s:3:\"162\";s:5:\"title\";s:15:\"GoodNews Footer\";s:5:\"alias\";s:14:\"goodnewsfooter\";s:3:\"zip\";s:24:\"packs/goodnewsfooter.zip\";s:3:\"uid\";s:32:\"34f43f891cb8d55375149dc4bbc38298\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:160;a:23:{s:2:\"id\";s:3:\"163\";s:5:\"title\";s:29:\"GoodNews Content Page Package\";s:5:\"alias\";s:29:\"goodnews-content-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:29:\"goodnews-content-page-package\";s:3:\"img\";s:55:\"packages/templatepack_goodnews_content_page_package.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:161;a:23:{s:2:\"id\";s:3:\"164\";s:5:\"title\";s:18:\"GoodNews Menu Back\";s:5:\"alias\";s:16:\"goodnewsmenuback\";s:3:\"zip\";s:26:\"packs/goodnewsmenuback.zip\";s:3:\"uid\";s:32:\"1340d1aeefba497a7d404d12a1fceed4\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:162;a:23:{s:2:\"id\";s:3:\"165\";s:5:\"title\";s:20:\"GoodNews Blog Header\";s:5:\"alias\";s:18:\"goodnewsblogheader\";s:3:\"zip\";s:28:\"packs/goodnewsblogheader.zip\";s:3:\"uid\";s:32:\"abc4d7c1e48475c6def05f1f6d8bf564\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:163;a:23:{s:2:\"id\";s:3:\"166\";s:5:\"title\";s:21:\"GoodNews Blog Content\";s:5:\"alias\";s:19:\"goodnewsblogcontent\";s:3:\"zip\";s:29:\"packs/goodnewsblogcontent.zip\";s:3:\"uid\";s:32:\"bbf34563da6db2779c29599b503b07e9\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:164;a:23:{s:2:\"id\";s:3:\"167\";s:5:\"title\";s:21:\"GoodNews Testimonials\";s:5:\"alias\";s:20:\"goodnewstestimonials\";s:3:\"zip\";s:30:\"packs/goodnewstestimonials.zip\";s:3:\"uid\";s:32:\"606b7336e86f69c567542d3f43712b56\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:165;a:23:{s:2:\"id\";s:3:\"168\";s:5:\"title\";s:20:\"GoodNews Blog Footer\";s:5:\"alias\";s:18:\"goodnewsblogfooter\";s:3:\"zip\";s:28:\"packs/goodnewsblogfooter.zip\";s:3:\"uid\";s:32:\"1fb88aecfb116fde67ce8d52bd3b5f05\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:166;a:20:{s:2:\"id\";s:3:\"169\";s:5:\"title\";s:19:\"Before After Slider\";s:5:\"alias\";s:17:\"beforeafterslider\";s:3:\"zip\";s:21:\"beforeafterslider.zip\";s:3:\"uid\";s:32:\"6e615091a1fc3037c24b985ce5136fb2\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/before-after-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.3.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">This is the example slider for our Before / After Add-On that allows you to create unique presentations with a comparing functionality.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:358:\"<span class=\"ttm_content\">How to install <a href=\"https://revolution.themepunch.com/direct-customer-benefits/#addoninstall\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:167;a:20:{s:2:\"id\";s:3:\"170\";s:5:\"title\";s:16:\"Product Showcase\";s:5:\"alias\";s:15:\"productshowcase\";s:3:\"zip\";s:19:\"productshowcase.zip\";s:3:\"uid\";s:32:\"a43447670260aaa7e8ff66cedfddb57a\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/wordpress-product-showcase-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:165:\"<span class=\"ttm_content\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:168;a:20:{s:2:\"id\";s:3:\"171\";s:5:\"title\";s:23:\"Overexposure Transition\";s:5:\"alias\";s:22:\"overexposuretransition\";s:3:\"zip\";s:26:\"overexposuretransition.zip\";s:3:\"uid\";s:32:\"13f16bbe6c6d646c7d0cb817a0d3d181\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/overexposure-transition-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:358:\"<span class=\"ttm_content\">How to install <a href=\"https://revolution.themepunch.com/direct-customer-benefits/#addoninstall\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:169;a:20:{s:2:\"id\";s:3:\"172\";s:5:\"title\";s:15:\"Parallax Scroll\";s:5:\"alias\";s:14:\"parallaxscroll\";s:3:\"zip\";s:18:\"parallaxscroll.zip\";s:3:\"uid\";s:32:\"82546ee2f6af6c6682852f495109b3c3\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/parallax-scroll/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A strikingly colourful header for your website with super smooth parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:170;a:23:{s:2:\"id\";s:3:\"173\";s:5:\"title\";s:24:\"TechCo One-Pager Package\";s:5:\"alias\";s:24:\"techco-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:24:\"techco-one-pager-package\";s:3:\"img\";s:28:\"packages/techco_overview.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:171;a:23:{s:2:\"id\";s:3:\"174\";s:5:\"title\";s:11:\"TechCo Menu\";s:5:\"alias\";s:11:\"techco-menu\";s:3:\"zip\";s:21:\"packs/techco-menu.zip\";s:3:\"uid\";s:32:\"55e5efee828cdf1ff7e2d3b90a301ea9\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:172;a:23:{s:2:\"id\";s:3:\"175\";s:5:\"title\";s:13:\"TechCo Header\";s:5:\"alias\";s:13:\"techco-header\";s:3:\"zip\";s:23:\"packs/techco-header.zip\";s:3:\"uid\";s:32:\"fb574d1376de9b1e408c91f51e6497d7\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:173;a:23:{s:2:\"id\";s:3:\"176\";s:5:\"title\";s:12:\"TechCo About\";s:5:\"alias\";s:12:\"techco-about\";s:3:\"zip\";s:22:\"packs/techco-about.zip\";s:3:\"uid\";s:32:\"ba216da8231e55118d87e37d2358812c\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:174;a:23:{s:2:\"id\";s:3:\"177\";s:5:\"title\";s:15:\"TechCo Services\";s:5:\"alias\";s:15:\"techco-services\";s:3:\"zip\";s:25:\"packs/techco-services.zip\";s:3:\"uid\";s:32:\"ef4a8ddbb5e1136133f7bc1227248e22\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:175;a:23:{s:2:\"id\";s:3:\"178\";s:5:\"title\";s:12:\"TechCo Video\";s:5:\"alias\";s:12:\"techco-video\";s:3:\"zip\";s:22:\"packs/techco-video.zip\";s:3:\"uid\";s:32:\"d7bb92281d05f39f9bc9eca71f90e402\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:176;a:23:{s:2:\"id\";s:3:\"179\";s:5:\"title\";s:13:\"TechCo Prices\";s:5:\"alias\";s:13:\"techco-prices\";s:3:\"zip\";s:23:\"packs/techco-prices.zip\";s:3:\"uid\";s:32:\"6291f404efbea12bb181352aba71ef11\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:177;a:23:{s:2:\"id\";s:3:\"180\";s:5:\"title\";s:19:\"TechCo Testimonials\";s:5:\"alias\";s:19:\"techco-testimonials\";s:3:\"zip\";s:29:\"packs/techco-testimonials.zip\";s:3:\"uid\";s:32:\"3460bd51f6b80599266fecb7fbb918be\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:178;a:23:{s:2:\"id\";s:3:\"181\";s:5:\"title\";s:13:\"TechCo Footer\";s:5:\"alias\";s:13:\"techco-footer\";s:3:\"zip\";s:23:\"packs/techco-footer.zip\";s:3:\"uid\";s:32:\"640abcd549137520461a4a71ff758a3b\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:179;a:20:{s:2:\"id\";s:3:\"182\";s:5:\"title\";s:12:\"Live Weather\";s:5:\"alias\";s:7:\"weather\";s:3:\"zip\";s:11:\"weather.zip\";s:3:\"uid\";s:32:\"aab92e69374e4c7b8c6741fe02e574b9\";s:3:\"img\";s:18:\"weather/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-live-weather-add-on/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">Showcasing our weather add-on, this slider show a different cities temperatures and forecast on each slide.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-weather-addon\\/revslider-weather-addon.php\",\"name\":\"Live Weather Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:180;a:20:{s:2:\"id\";s:3:\"183\";s:5:\"title\";s:17:\"360 Panorama Tour\";s:5:\"alias\";s:11:\"360panorama\";s:3:\"zip\";s:15:\"360panorama.zip\";s:3:\"uid\";s:32:\"332720fdacdbb38f65e8327a2a96c52d\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/360-degree-real-estate-virtual-tour/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">An example template for our Panorama 360 tour add-on, created for the real estate market.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:176:\"[{\"path\":\"revslider-panorama-addon\\/revslider-panorama-addon.php\",\"name\":\"Panorama AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:181;a:20:{s:2:\"id\";s:3:\"184\";s:5:\"title\";s:14:\"Duotone Add-on\";s:5:\"alias\";s:14:\"duotone-add-on\";s:3:\"zip\";s:18:\"duotone-add-on.zip\";s:3:\"uid\";s:32:\"a428c6f363b3146e96d20a6f44958922\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-duotone-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:168:\"<span class=\"ttm_content\">This example template showcases 3 of the 30 Duotone filters available in our brand new Duotone Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:372:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"},{\"path\":\"revslider-duotonefilters-addon\\/revslider-duotonefilters-addon.php\",\"name\":\"Duotone AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:182;a:20:{s:2:\"id\";s:3:\"185\";s:5:\"title\";s:13:\"Reveal Add-on\";s:5:\"alias\";s:13:\"reveal-add-on\";s:3:\"zip\";s:17:\"reveal-add-on.zip\";s:3:\"uid\";s:32:\"7fa7525d8ff7fa7365cb98a437e88e32\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-content-reveal-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">An example template that uses our Reveal Add-On, which adds 14 new preloaders combined with reveal loading effects for any slider or hero.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:359:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:201;a:20:{s:2:\"id\";s:3:\"210\";s:5:\"title\";s:21:\"Cryptocurrency Prices\";s:5:\"alias\";s:12:\"cryptoslider\";s:3:\"zip\";s:16:\"cryptoslider.zip\";s:3:\"uid\";s:32:\"c4b02210387f11946223977e940d9e9e\";s:3:\"img\";s:23:\"cryptoslider/slide1.jpg\";s:7:\"preview\";s:95:\"https://revolution.themepunch.com/cryptocurrency-wordpress-price-api-bitcoin-ethereum-litecoin/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:209:\"<span class=\"ttm_content\">This Template can show live, animated cryptocurrency prices. More than 1300 currencies are supported, getting prices via the cryptocompare API.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:436:\"<span class=\"ttm_content\">Please refer to the \"Custom JavaScript\" section of this sliders settings, for info on how to modify currencies. Provide a class to the row / column / group where the currency text elements are located in.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:202;a:23:{s:2:\"id\";s:3:\"211\";s:5:\"title\";s:18:\"Immersion One Page\";s:5:\"alias\";s:26:\"immersion-one-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"immersion-one-page-package\";s:3:\"img\";s:31:\"packages/immersion_overview.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";s:351:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"},{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:203;a:23:{s:2:\"id\";s:3:\"212\";s:5:\"title\";s:16:\"Immersion Header\";s:5:\"alias\";s:16:\"immersion_header\";s:3:\"zip\";s:26:\"packs/immersion_header.zip\";s:3:\"uid\";s:32:\"853da51256308b341ecd030bd4883229\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:204;a:23:{s:2:\"id\";s:3:\"213\";s:5:\"title\";s:19:\"Immersion Mountains\";s:5:\"alias\";s:19:\"immersion-mountains\";s:3:\"zip\";s:29:\"packs/immersion-mountains.zip\";s:3:\"uid\";s:32:\"817167eb3fe22b7e065ba210cbe6d53c\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:205;a:23:{s:2:\"id\";s:3:\"214\";s:5:\"title\";s:17:\"Immersion Product\";s:5:\"alias\";s:17:\"immersion-product\";s:3:\"zip\";s:27:\"packs/immersion-product.zip\";s:3:\"uid\";s:32:\"64134f263484d2bbcd7ef088ffbbfb4b\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:206;a:23:{s:2:\"id\";s:3:\"215\";s:5:\"title\";s:16:\"Immersion Design\";s:5:\"alias\";s:16:\"immersion-design\";s:3:\"zip\";s:26:\"packs/immersion-design.zip\";s:3:\"uid\";s:32:\"91e1d77c1a2826438763804f4d02bc26\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:207;a:23:{s:2:\"id\";s:3:\"216\";s:5:\"title\";s:22:\"Immersion Phototgraphy\";s:5:\"alias\";s:21:\"immersion-photography\";s:3:\"zip\";s:31:\"packs/immersion-photography.zip\";s:3:\"uid\";s:32:\"e3ddf0c577b09740f5cbf2e38ffd684d\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:208;a:23:{s:2:\"id\";s:3:\"217\";s:5:\"title\";s:14:\"Immersion Grid\";s:5:\"alias\";s:14:\"immersion-grid\";s:3:\"zip\";s:24:\"packs/immersion-grid.zip\";s:3:\"uid\";s:32:\"b6903868189bb83b2c7a852fde3a7dc3\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:209;a:20:{s:2:\"id\";s:3:\"218\";s:5:\"title\";s:18:\"Funky Intro Slider\";s:5:\"alias\";s:11:\"funkyslider\";s:3:\"zip\";s:15:\"funkyslider.zip\";s:3:\"uid\";s:32:\"2d4187e3fdad19b976be335253c8925d\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/funky-intro-slider-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">This funky intro slider fits just right if you need a striking introduction to your website! Sleek, beautiful and easily customizable!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:343:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:210;a:23:{s:2:\"id\";s:3:\"219\";s:5:\"title\";s:19:\"Clear View Magazine\";s:5:\"alias\";s:27:\"clear-view-magazine-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"clear-view-magazine-package\";s:3:\"img\";s:41:\"packages/clear_view_magazine_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:211;a:23:{s:2:\"id\";s:3:\"220\";s:5:\"title\";s:15:\"Clear View Menu\";s:5:\"alias\";s:14:\"clearview_menu\";s:3:\"zip\";s:24:\"packs/clearview_menu.zip\";s:3:\"uid\";s:32:\"eaecee5fa5f3c3a7f4d2a96c4616a353\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:212;a:23:{s:2:\"id\";s:3:\"221\";s:5:\"title\";s:17:\"Clear View Header\";s:5:\"alias\";s:16:\"clearview_header\";s:3:\"zip\";s:26:\"packs/clearview_header.zip\";s:3:\"uid\";s:32:\"25e3dd80ad130875d7438a07952cb0cd\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:213;a:23:{s:2:\"id\";s:3:\"222\";s:5:\"title\";s:18:\"Clear View Mission\";s:5:\"alias\";s:17:\"clearview_mission\";s:3:\"zip\";s:27:\"packs/clearview_mission.zip\";s:3:\"uid\";s:32:\"35b2092a49fd2beb549342e69097eb5b\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:214;a:23:{s:2:\"id\";s:3:\"223\";s:5:\"title\";s:17:\"Clear View Slider\";s:5:\"alias\";s:17:\"clear-view-slider\";s:3:\"zip\";s:27:\"packs/clear-view-slider.zip\";s:3:\"uid\";s:32:\"d2e17edffce16ed78c54b0ef23fd7e05\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:215;a:23:{s:2:\"id\";s:3:\"224\";s:5:\"title\";s:15:\"Clear View News\";s:5:\"alias\";s:15:\"clear-view-news\";s:3:\"zip\";s:25:\"packs/clear-view-news.zip\";s:3:\"uid\";s:32:\"5698d3131ba141e9afcfd2906739dd00\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:216;a:23:{s:2:\"id\";s:3:\"225\";s:5:\"title\";s:18:\"Clear View Clients\";s:5:\"alias\";s:18:\"clear-view-clients\";s:3:\"zip\";s:28:\"packs/clear-view-clients.zip\";s:3:\"uid\";s:32:\"b95616a94832e22bdfac5ce60232be1b\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:217;a:23:{s:2:\"id\";s:3:\"226\";s:5:\"title\";s:18:\"Clear View Contact\";s:5:\"alias\";s:18:\"clear-view-contact\";s:3:\"zip\";s:28:\"packs/clear-view-contact.zip\";s:3:\"uid\";s:32:\"0e0cc1d8f6f6500e5f8a2b091fa3b4cb\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:218;a:23:{s:2:\"id\";s:3:\"227\";s:5:\"title\";s:20:\"Clear View Post Page\";s:5:\"alias\";s:28:\"clear-view-post-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"clear-view-post-page-package\";s:3:\"img\";s:42:\"packages/clear_view_post_page_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:219;a:23:{s:2:\"id\";s:3:\"228\";s:5:\"title\";s:22:\"Clear View Single Menu\";s:5:\"alias\";s:22:\"clear-view-single-menu\";s:3:\"zip\";s:32:\"packs/clear-view-single-menu.zip\";s:3:\"uid\";s:32:\"1e80f81982f8a4ea763482d4fa99d321\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:220;a:23:{s:2:\"id\";s:3:\"229\";s:5:\"title\";s:24:\"Clear View Single Header\";s:5:\"alias\";s:24:\"clear-view-single-header\";s:3:\"zip\";s:34:\"packs/clear-view-single-header.zip\";s:3:\"uid\";s:32:\"c8d717627be6cd5e70922ab609694dbf\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:221;a:23:{s:2:\"id\";s:3:\"230\";s:5:\"title\";s:23:\"Clear View Single Media\";s:5:\"alias\";s:23:\"clear-view-single-media\";s:3:\"zip\";s:33:\"packs/clear-view-single-media.zip\";s:3:\"uid\";s:32:\"c480368ded2a64f0cdd44f1674213814\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:222;a:23:{s:2:\"id\";s:3:\"231\";s:5:\"title\";s:22:\"Clear View Single More\";s:5:\"alias\";s:22:\"clear-view-single-more\";s:3:\"zip\";s:32:\"packs/clear-view-single-more.zip\";s:3:\"uid\";s:32:\"9c693190df26218366d1f77e10cf550a\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:223;a:23:{s:2:\"id\";s:3:\"232\";s:5:\"title\";s:25:\"Clear View Single Contact\";s:5:\"alias\";s:25:\"clear-view-single-contact\";s:3:\"zip\";s:35:\"packs/clear-view-single-contact.zip\";s:3:\"uid\";s:32:\"73c0a889f2b654a87b5aba1ff76fbc5c\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:224;a:20:{s:2:\"id\";s:3:\"233\";s:5:\"title\";s:18:\"Clean Landing Page\";s:5:\"alias\";s:16:\"cleanlandingpage\";s:3:\"zip\";s:20:\"cleanlandingpage.zip\";s:3:\"uid\";s:32:\"727a3680d312f22c6a5998ebdb9afe52\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/clean-landing-page-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:203:\"<span class=\"ttm_content\">The Clean Landing Page is a fullscreen Intro Module that is a striking introduction to any minimal website, with no unnecessary elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:225;a:20:{s:2:\"id\";s:3:\"234\";s:5:\"title\";s:9:\"Clear Cut\";s:5:\"alias\";s:8:\"clearcut\";s:3:\"zip\";s:12:\"clearcut.zip\";s:3:\"uid\";s:32:\"07f43c00e9b4d3057a03cdb3385ad2b7\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/clear-cut-portfolio-website-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:240:\"<span class=\"ttm_content\">The Clear Cut Template is an All-In-One Portfolio Website solution that works best for smaller portfolios. Highlight your best work in a striking and mobile friendly fashion!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:226;a:23:{s:2:\"id\";s:3:\"235\";s:5:\"title\";s:22:\"Wonderstruck One-Pager\";s:5:\"alias\";s:30:\"wonderstruck-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:30:\"wonderstruck-one-pager-package\";s:3:\"img\";s:44:\"packages/wonderstruck-one-pager-overview.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:227;a:23:{s:2:\"id\";s:3:\"236\";s:5:\"title\";s:17:\"Wonderstruck Menu\";s:5:\"alias\";s:17:\"wonderstruck_menu\";s:3:\"zip\";s:27:\"packs/wonderstruck_menu.zip\";s:3:\"uid\";s:32:\"0a976e9aaae59c4f795b38f59f5a08d8\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:228;a:23:{s:2:\"id\";s:3:\"237\";s:5:\"title\";s:19:\"Wonderstruck Header\";s:5:\"alias\";s:19:\"wonderstruck_header\";s:3:\"zip\";s:29:\"packs/wonderstruck_header.zip\";s:3:\"uid\";s:32:\"e1379f77a902960a0ce12d44d85a9e0a\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:229;a:23:{s:2:\"id\";s:3:\"238\";s:5:\"title\";s:18:\"Wonderstruck About\";s:5:\"alias\";s:18:\"wonderstruck_about\";s:3:\"zip\";s:28:\"packs/wonderstruck_about.zip\";s:3:\"uid\";s:32:\"d207fb140fd328acc3038300ea52082a\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:230;a:23:{s:2:\"id\";s:3:\"239\";s:5:\"title\";s:18:\"Wonderstruck Works\";s:5:\"alias\";s:18:\"wonderstruck-works\";s:3:\"zip\";s:28:\"packs/wonderstruck-works.zip\";s:3:\"uid\";s:32:\"4476935097e27d92454b0011b7700c1d\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:231;a:23:{s:2:\"id\";s:3:\"240\";s:5:\"title\";s:20:\"Wonderstruck Contact\";s:5:\"alias\";s:20:\"wonderstruck-contact\";s:3:\"zip\";s:30:\"packs/wonderstruck-contact.zip\";s:3:\"uid\";s:32:\"9e4911521f77bce2b8efa40f4c2adc22\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:232;a:20:{s:2:\"id\";s:3:\"241\";s:5:\"title\";s:12:\"Bubble Morph\";s:5:\"alias\";s:11:\"bubblemorph\";s:3:\"zip\";s:15:\"bubblemorph.zip\";s:3:\"uid\";s:32:\"1102d6f5460ab82cb612cbe9f1d9514b\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";s:7:\"preview\";s:75:\"https://revolution.themepunch.com/bubble-morph-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:188:\"<span class=\"ttm_content\">The Bubble Morph Add-On allows you to create interesting Lava-Lamp style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:233;a:20:{s:2:\"id\";s:3:\"242\";s:5:\"title\";s:16:\"Distortion AddOn\";s:5:\"alias\";s:15:\"distortionaddon\";s:3:\"zip\";s:19:\"distortionaddon.zip\";s:3:\"uid\";s:32:\"0ad46c9929bb2fa6316f1e6ced301aaf\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";s:7:\"preview\";s:73:\"https://revolution.themepunch.com/distortion-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Distortion Add-On allows you to create interesting Distortion style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:193:\"[{\"path\":\"revslider-liquideffect-addon\\/revslider-liquideffect-addon.php\",\"name\":\"Distortion Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:234;a:20:{s:2:\"id\";s:3:\"243\";s:5:\"title\";s:10:\"Club Flyer\";s:5:\"alias\";s:9:\"clubflyer\";s:3:\"zip\";s:13:\"clubflyer.zip\";s:3:\"uid\";s:32:\"dab73b9904d0e643a35b0475980998bd\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/club-flyer-landing-page-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This Club Fyler Template for Slider Revolution uses the brand new Exploding Layers Add-On to create a captivating effect. Tap into unlimited creative potential. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:198:\"[{\"path\":\"revslider-explodinglayers-addon\\/revslider-explodinglayers-addon.php\",\"name\":\"Exploding Layers AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:235;a:20:{s:2:\"id\";s:3:\"244\";s:5:\"title\";s:16:\"Paintbrush AddOn\";s:5:\"alias\";s:15:\"paintbrushaddon\";s:3:\"zip\";s:19:\"paintbrushaddon.zip\";s:3:\"uid\";s:32:\"c85c48a6742b4bf72a2590cc1b50f6a0\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";s:7:\"preview\";s:73:\"https://revolution.themepunch.com/paintbrush-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">The Paintbrush Add-On for WordPress allows you to add cool mouse interaction effects to your Slider Revolution content. Examples: Blur Reveal, Color Reveal, Scratch Me Free.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-paintbrush-addon\\/revslider-paintbrush-addon.php\",\"name\":\"Paintbrush AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:236;a:23:{s:2:\"id\";s:3:\"245\";s:5:\"title\";s:18:\"Parallax One-Pager\";s:5:\"alias\";s:26:\"parallax-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"parallax-one-pager-package\";s:3:\"img\";s:39:\"packages/parallax-one-pager-package.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:237;a:23:{s:2:\"id\";s:3:\"246\";s:5:\"title\";s:15:\"Parallax Header\";s:5:\"alias\";s:15:\"parallax_header\";s:3:\"zip\";s:25:\"packs/parallax_header.zip\";s:3:\"uid\";s:32:\"32bf4a0f5136853bd6bd366275a7a60b\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:238;a:23:{s:2:\"id\";s:3:\"247\";s:5:\"title\";s:16:\"Parallax Content\";s:5:\"alias\";s:16:\"parallax_content\";s:3:\"zip\";s:26:\"packs/parallax_content.zip\";s:3:\"uid\";s:32:\"a25c5fb8f74757476ab4dc038e56f90d\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:239;a:23:{s:2:\"id\";s:3:\"248\";s:5:\"title\";s:15:\"Parallax Footer\";s:5:\"alias\";s:15:\"parallax_footer\";s:3:\"zip\";s:25:\"packs/parallax_footer.zip\";s:3:\"uid\";s:32:\"665dff9ea6eaf162a2a1f160f51a9ddb\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:240;a:23:{s:2:\"id\";s:3:\"249\";s:5:\"title\";s:18:\"Le Chef Restaurant\";s:5:\"alias\";s:18:\"le-chef-restaurant\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"le-chef-restaurant-package\";s:3:\"img\";s:39:\"packages/le-chef-restaurant-package.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:241;a:23:{s:2:\"id\";s:3:\"250\";s:5:\"title\";s:12:\"Le Chef Menu\";s:5:\"alias\";s:12:\"le-chef-menu\";s:3:\"zip\";s:22:\"packs/le-chef-menu.zip\";s:3:\"uid\";s:32:\"2f2a6a333431fefe4a7b3b6a982b2ff5\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:242;a:23:{s:2:\"id\";s:3:\"251\";s:5:\"title\";s:14:\"Le Chef Header\";s:5:\"alias\";s:14:\"le-chef-header\";s:3:\"zip\";s:24:\"packs/le-chef-header.zip\";s:3:\"uid\";s:32:\"06450ca3be5a4a8959f3752ab974e574\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:243;a:23:{s:2:\"id\";s:3:\"252\";s:5:\"title\";s:18:\"Le Chef Philosophy\";s:5:\"alias\";s:18:\"le-chef-philosophy\";s:3:\"zip\";s:28:\"packs/le-chef-philosophy.zip\";s:3:\"uid\";s:32:\"a532fd029addeb18106e751409b8e20a\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:244;a:23:{s:2:\"id\";s:3:\"253\";s:5:\"title\";s:12:\"Le Chef Food\";s:5:\"alias\";s:12:\"le-chef-food\";s:3:\"zip\";s:22:\"packs/le-chef-food.zip\";s:3:\"uid\";s:32:\"cd4b6a2cb5de2dd20a0e8ba0c35451df\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:245;a:23:{s:2:\"id\";s:3:\"254\";s:5:\"title\";s:16:\"Le Chef La Carte\";s:5:\"alias\";s:16:\"le-chef-la-carte\";s:3:\"zip\";s:26:\"packs/le-chef-la-carte.zip\";s:3:\"uid\";s:32:\"6f312749679c3ba52c41189a6b8bf729\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:246;a:23:{s:2:\"id\";s:3:\"255\";s:5:\"title\";s:14:\"Le Chef Footer\";s:5:\"alias\";s:14:\"le-chef-footer\";s:3:\"zip\";s:24:\"packs/le-chef-footer.zip\";s:3:\"uid\";s:32:\"12fc241e8e5b9e5df9758c43448e2907\";s:3:\"img\";s:25:\"le-chef-footer/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:247;a:20:{s:2:\"id\";s:3:\"256\";s:5:\"title\";s:20:\"News Magazine Slider\";s:5:\"alias\";s:20:\"news-magazine-slider\";s:3:\"zip\";s:24:\"news-magazine-slider.zip\";s:3:\"uid\";s:32:\"31f2c1506babb1fef459401f051d2d52\";s:3:\"img\";s:31:\"news-magazine-slider/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/news-magazine-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">The Magazine Slider offers various layouts that support static content images, HTML5 and Youtube video. Great for any blog or news website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:248;a:20:{s:2:\"id\";s:3:\"257\";s:5:\"title\";s:18:\"Real Estate Slider\";s:5:\"alias\";s:18:\"real-estate-slider\";s:3:\"zip\";s:22:\"real-estate-slider.zip\";s:3:\"uid\";s:32:\"739ce6336e46815094387c9448e6c804\";s:3:\"img\";s:29:\"real-estate-slider/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/real-estate-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">The Real Estate Slider allows to display real estate offers with a large ken burns background image and additional thumbnail hover images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:249;a:20:{s:2:\"id\";s:3:\"258\";s:5:\"title\";s:14:\"Fashion Header\";s:5:\"alias\";s:14:\"fashion-header\";s:3:\"zip\";s:18:\"fashion-header.zip\";s:3:\"uid\";s:32:\"24ece4e7f4d31cd90377c62abbd9e25a\";s:3:\"img\";s:25:\"fashion-header/slide1.jpg\";s:7:\"preview\";s:75:\"https://revolution.themepunch.com/fashion-shop-header-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:254:\"<span class=\"ttm_content\">The Fashion Shop Header ist the ideal Slider to display as an intro to your shop website or as a separator in between content. Our unique \"Bubble Morph\" effect makes this module stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}}s:6:\"slides\";a:235:{s:16:\"classic-carousel\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"classic-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"classic-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"classic-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"classic-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"classic-carousel/slide5.jpg\";}}s:13:\"classicslider\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"classicslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"classicslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"classicslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"classicslider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:24:\"classicslider/slide5.jpg\";}}s:11:\"contenttabs\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"contenttabs/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"contenttabs/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"contenttabs/slide3.jpg\";}}s:13:\"facebook-feed\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"facebook-feed/slide1.jpg\";}}s:7:\"fashion\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"fashion/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"fashion/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"fashion/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"fashion/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"fashion/slide5.jpg\";}}s:14:\"flickr-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"flickr-gallery/slide1.jpg\";}}s:3:\"gym\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:14:\"gym/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:14:\"gym/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:14:\"gym/slide3.jpg\";}}s:18:\"highlight-carousel\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"highlight-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"highlight-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"highlight-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"highlight-carousel/slide4.jpg\";}}s:18:\"highlight-showcase\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"highlight-showcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"highlight-showcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"highlight-showcase/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"highlight-showcase/slide4.jpg\";}}s:10:\"image-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"imagehero/slide1.jpg\";}}s:13:\"insta-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"insta-gallery/slide1.jpg\";}}s:19:\"levanorestaurantbar\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"levanorestaurantbar/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"levanorestaurantbar/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"levanorestaurantbar/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:30:\"levanorestaurantbar/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:30:\"levanorestaurantbar/slide5.jpg\";}}s:11:\"mainfeature\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"mainfeature/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"mainfeature/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"mainfeature/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"mainfeature/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:22:\"mainfeature/slide7.jpg\";}}s:17:\"media-gallery-two\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"media-gallery-two/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"media-gallery-two/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"media-gallery-two/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"media-gallery-two/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:28:\"media-gallery-two/slide6.jpg\";}}s:23:\"media-carousel-autoplay\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide6.jpg\";}}s:21:\"news-background-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"news-bg-video/slide1.jpg\";}}s:12:\"news-gallery\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"news-gallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"news-gallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"news-gallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"news-gallery/slide4.jpg\";}}s:23:\"news-gallery-post-based\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"news-gallery-post-based/slide1.jpg\";}}s:9:\"news-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"news-hero/slide1.jpg\";}}s:10:\"news-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"news-video/slide1.jpg\";}}s:15:\"newsletter-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"newsletter-hero/slide1.jpg\";}}s:10:\"notgeneric\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"notgeneric/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"notgeneric/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"notgeneric/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:21:\"notgeneric/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:21:\"notgeneric/slide5.jpg\";}}s:11:\"photography\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"photography/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"photography/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"photography/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"photography/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:22:\"photography/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:22:\"photography/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:22:\"photography/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:22:\"photography/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:22:\"photography/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:23:\"photography/slide10.jpg\";}}s:20:\"photography-carousel\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"photography-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"photography-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"photography-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"photography-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:31:\"photography-carousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:31:\"photography-carousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:31:\"photography-carousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:31:\"photography-carousel/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:31:\"photography-carousel/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:32:\"photography-carousel/slide10.jpg\";}}s:16:\"search-form-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"search-form-hero/slide1.jpg\";}}s:16:\"showcasecarousel\";a:9:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"showcasecarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"showcasecarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"showcasecarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"showcasecarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"showcasecarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:27:\"showcasecarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:27:\"showcasecarousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:27:\"showcasecarousel/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:27:\"showcasecarousel/slide9.jpg\";}}s:11:\"sports-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"sportshero/slide1.jpg\";}}s:12:\"twitter-feed\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"twitter-feed/slide1.jpg\";}}s:13:\"vimeo-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"vimeo-gallery/slide1.jpg\";}}s:9:\"vimeohero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"vimeohero/slide1.jpg\";}}s:16:\"web-product-dark\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"web-product-dark/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"web-product-dark/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"web-product-dark/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"web-product-dark/slide4.jpg\";}}s:21:\"web-product-dark-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"web-product-dark-hero/slide1.jpg\";}}s:22:\"web-product-light-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"web-product-light-hero/slide1.jpg\";}}s:15:\"webproductlight\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"webproductlight/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"webproductlight/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"webproductlight/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"webproductlight/slide4.jpg\";}}s:15:\"youtube-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"youtube-gallery/slide1.jpg\";}}s:11:\"youtubehero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"youtubehero/slide1.jpg\";}}s:13:\"scroll-effect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"scrolleffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"scrolleffect/slide3.jpg\";}}s:12:\"content-zoom\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"contentzoom/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"contentzoom/slide3.jpg\";}}s:13:\"food-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"foodcarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"foodcarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"foodcarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"foodcarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:23:\"foodcarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:23:\"foodcarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:23:\"foodcarousel/slide7.jpg\";}}s:14:\"rotating-words\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";}}s:22:\"travel-static-captions\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"travel-static-captions/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"travel-static-captions/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:33:\"travel-static-captions/slide4.jpg\";}}s:7:\"concept\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"concept/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"concept/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"concept/slide3.jpg\";}}s:17:\"fullscreen-button\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"fullscreen-button/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"fullscreen-button/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"fullscreen-button/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:28:\"fullscreen-button/slide5.jpg\";}}s:15:\"creativefreedom\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"creativefreedom/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"creativefreedom/slide3.jpg\";}}s:13:\"parallaxscene\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";}}s:15:\"slidingoverlays\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"slidingoverlays/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"slidingoverlays/slide3.jpg\";}}s:25:\"web-product-light-hero-3d\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";}}s:6:\"woobig\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";}}s:16:\"woocommercesmall\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";}}s:10:\"finedining\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";}}s:12:\"agency-intro\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";}}s:7:\"ourteam\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"ourteam/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"ourteam/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"ourteam/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"ourteam/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:18:\"ourteam/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:18:\"ourteam/slide7.jpg\";}}s:17:\"our-team-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"ourteamcarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"ourteamcarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"ourteamcarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"ourteamcarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"ourteamcarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:26:\"ourteamcarousel/slide7.jpg\";}}s:13:\"betteryoutube\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"betteryoutube/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"betteryoutube/slide3.jpg\";}}s:19:\"agencywebsiteheader\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"agencywebsiteheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"agencywebsiteheader/slide3.jpg\";}}s:10:\"comingsoon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"comingsoon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"comingsoon/slide3.jpg\";}}s:9:\"snowscene\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"snowscene/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"snowscene/slide3.jpg\";}}s:8:\"rockband\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";}}s:16:\"sleeklandingpage\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"sleeklandingpage/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"sleeklandingpage/slide3.jpg\";}}s:14:\"applandingpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";}}s:9:\"deskscene\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";}}s:15:\"cleannewsslider\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"cleannewsslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"cleannewsslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"cleannewsslider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"cleannewsslider/slide5.jpg\";}}s:12:\"imagegallery\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"imagegallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"imagegallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"imagegallery/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:23:\"imagegallery/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:23:\"imagegallery/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:23:\"imagegallery/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:23:\"imagegallery/slide8.jpg\";}}s:19:\"standard-wp-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";}}s:21:\"clean-news-post-based\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";}}s:21:\"interactivewhiteboard\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"interactivewhiteboard/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"interactivewhiteboard/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"interactivewhiteboard/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:32:\"interactivewhiteboard/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:32:\"interactivewhiteboard/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:32:\"interactivewhiteboard/slide8.jpg\";}}s:10:\"innovation\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"innovation/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"innovation/slide3.jpg\";}}s:24:\"dark-fullsite-block-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";}}s:21:\"dark-fullsite-block-1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";}}s:27:\"dark-fullsite-block-2-about\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide2.jpg\";}}s:30:\"dark-fullsite-block-3-services\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide2.jpg\";}}s:30:\"dark-fullsite-block-4-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide5.jpg\";}}s:34:\"dark-fullsite-block-5-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";}}s:29:\"dark-fullsite-block-6-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";}}s:28:\"dark-fullsite-block-7-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";}}s:19:\"fullsite-block-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";}}s:15:\"fullsite-block1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";}}s:22:\"fullsite-block-2-about\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide2.jpg\";}}s:25:\"fullsite-block-3-services\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide2.jpg\";}}s:25:\"fullsite-block-4-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide5.jpg\";}}s:29:\"fullsite-block-5-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";}}s:24:\"fullsite-block-6-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";}}s:23:\"fullsite-block-7-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";}}s:11:\"techjournal\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"techjournal/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"techjournal/slide3.jpg\";}}s:13:\"cardealership\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"cardealership/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"cardealership/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"cardealership/slide4.jpg\";}}s:14:\"fullscreenmenu\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"fullscreenmenu/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"fullscreenmenu/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:25:\"fullscreenmenu/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:25:\"fullscreenmenu/slide5.jpg\";}}s:17:\"creativefrontpage\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"creativefrontpage/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"creativefrontpage/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"creativefrontpage/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:28:\"creativefrontpage/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:28:\"creativefrontpage/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:28:\"creativefrontpage/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:28:\"creativefrontpage/slide8.jpg\";}}s:19:\"websitebuilder-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";}}s:19:\"websitebuilder-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";}}s:22:\"websitebuilder-clients\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";}}s:23:\"websitebuilder-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";}}s:23:\"websitebuilder-discover\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"websitebuilder-discover/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"websitebuilder-discover/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"websitebuilder-discover/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:34:\"websitebuilder-discover/slide5.jpg\";}}s:21:\"websitebuilder-slider\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"websitebuilder-slider/slide2.jpg\";}}s:27:\"websitebuilder-calltoaction\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";}}s:21:\"websitebuilder-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";}}s:13:\"focusparallax\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"focusparallax/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"focusparallax/slide3.jpg\";}}s:7:\"duotone\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"duotone/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"duotone/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"duotone/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"duotone/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:18:\"duotone/slide6.jpg\";}}s:6:\"r_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";}}s:5:\"rhero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";}}s:7:\"r_about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";}}s:10:\"r_products\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"r_products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"r_products/slide3.jpg\";}}s:6:\"r_info\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";}}s:17:\"inspirationheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";}}s:13:\"magazineposts\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"magazineposts/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"magazineposts/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"magazineposts/slide4.jpg\";}}s:17:\"explorationheader\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"explorationheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"explorationheader/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"explorationheader/slide4.jpg\";}}s:16:\"typewritereffect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"typewritereffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"typewritereffect/slide3.jpg\";}}s:15:\"blendmodeheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";}}s:17:\"themeplicity_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";}}s:19:\"themeplicity_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";}}s:18:\"themeplicity_offer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";}}s:21:\"themeplicity_whatwedo\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";}}s:21:\"themeplicity_projects\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"themeplicity_projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"themeplicity_projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"themeplicity_projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:32:\"themeplicity_projects/slide5.jpg\";s:3:\"img\";s:7:\"Slide 5\";}}s:23:\"themeplicity_whatsgreat\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";}}s:19:\"themeplicity_tables\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";}}s:24:\"themeplicity_contactform\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";}}s:19:\"themeplicity_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";}}s:17:\"NiceAndClean_Menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";}}s:19:\"NiceAndClean_Header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";}}s:21:\"NiceAndClean_Services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";}}s:18:\"NiceAndClean_About\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";}}s:18:\"niceandclean_video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";}}s:23:\"niceandclean_highlights\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";}}s:21:\"NiceAndClean_Projects\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide5.jpg\";}}s:23:\"niceandclean_textblocks\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";}}s:20:\"niceandclean_callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";}}s:19:\"niceandclean_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";}}s:3:\"80s\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:14:\"80s/slide1.jpg\";}}s:10:\"blurslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"blurslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"blurslider/slide3.jpg\";}}s:15:\"ComingSoonAddon\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";}}s:9:\"snowaddon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"snowaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"snowaddon/slide3.jpg\";}}s:19:\"particle-effect-one\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"particle-effect-one/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"particle-effect-one/slide3.jpg\";}}s:19:\"particle-effect-two\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";}}s:21:\"particle-effect-three\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";}}s:15:\"portfolioviewer\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"portfolioviewer/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"portfolioviewer/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"portfolioviewer/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"portfolioviewer/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"portfolioviewer/slide6.jpg\";}}s:11:\"appshowcase\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";}}s:13:\"gravitydesign\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";}}s:12:\"404errorpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";}}s:15:\"carouselgallery\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"carouselgallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"carouselgallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"carouselgallery/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"carouselgallery/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"carouselgallery/slide6.jpg\";}}s:9:\"filmstrip\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"filmstrip/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"filmstrip/slide3.jpg\";}}s:10:\"spaceopera\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"spaceopera/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"spaceopera/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:21:\"spaceopera/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:21:\"spaceopera/slide5.jpg\";}}s:12:\"websiteintro\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"websiteintro/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"websiteintro/slide3.jpg\";}}s:12:\"maskshowcase\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"maskshowcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"maskshowcase/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"maskshowcase/slide4.jpg\";}}s:18:\"parallaxzoomslices\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"parallaxzoomslices/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"parallaxzoomslices/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"parallaxzoomslices/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:29:\"parallaxzoomslices/slide5.jpg\";}}s:20:\"doubleexposureeffect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"doubleexposureeffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"doubleexposureeffect/slide3.jpg\";}}s:22:\"mountainparallaxheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";}}s:12:\"goodnewsmenu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";}}s:14:\"goodnewsheader\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"goodnewsheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"goodnewsheader/slide3.jpg\";}}s:16:\"goodnewswhatshot\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";}}s:16:\"goodnewsfeatured\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";}}s:17:\"goodnewsspotlight\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"goodnewsspotlight/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"goodnewsspotlight/slide3.jpg\";}}s:16:\"goodnewscarousel\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"goodnewscarousel/slide2.jpg\";}}s:15:\"goodnewscallout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";}}s:14:\"goodnewsfooter\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";}}s:16:\"goodnewsmenuback\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";}}s:18:\"goodnewsblogheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";}}s:19:\"goodnewsblogcontent\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";}}s:20:\"goodnewstestimonials\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"goodnewstestimonials/slide2.jpg\";}}s:18:\"goodnewsblogfooter\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";}}s:17:\"beforeafterslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"beforeafterslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"beforeafterslider/slide3.jpg\";}}s:15:\"productshowcase\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"productshowcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"productshowcase/slide3.jpg\";}}s:22:\"overexposuretransition\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"overexposuretransition/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"overexposuretransition/slide3.jpg\";}}s:14:\"parallaxscroll\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";}}s:11:\"techco-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";}}s:13:\"techco-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";}}s:12:\"techco-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";}}s:15:\"techco-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";}}s:12:\"techco-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";}}s:13:\"techco-prices\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";}}s:19:\"techco-testimonials\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"techco-testimonials/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"techco-testimonials/slide3.jpg\";}}s:13:\"techco-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";}}s:7:\"weather\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"weather/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"weather/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"weather/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"weather/slide4.jpg\";}}s:11:\"360panorama\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"360panorama/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"360panorama/slide3.jpg\";}}s:14:\"duotone-add-on\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"duotone-add-on/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"duotone-add-on/slide3.jpg\";}}s:13:\"reveal-add-on\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"reveal-add-on/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"reveal-add-on/slide3.jpg\";}}s:16:\"band-tour-poster\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"smartcontent/band-tour-poster/slide1.png\";}}s:14:\"brewery-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide3.png\";}}s:9:\"burgerbar\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide3.png\";}}s:19:\"burger-bar-portrait\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide3.png\";}}s:8:\"car-rent\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"smartcontent/car-rent/slide1.png\";}}s:6:\"coffee\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"smartcontent/coffee/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"smartcontent/coffee/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"smartcontent/coffee/slide3.png\";}}s:14:\"holiday-advert\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/holiday-advert/slide1.png\";}}s:18:\"iphone-cases-light\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:42:\"smartcontent/iphone-cases-light/slide1.png\";}}s:7:\"medical\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"smartcontent/medical/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"smartcontent/medical/slide2.png\";}}s:13:\"mexican-grill\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide3.png\";}}s:20:\"mobile-retail-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide3.png\";}}s:14:\"money-exchange\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide3.png\";}}s:28:\"restaurant-menu-first-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:52:\"smartcontent/restaurant-menu-first-screen/slide1.png\";}}s:29:\"restaurant-menu-second-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:53:\"smartcontent/restaurant-menu-second-screen/slide1.png\";}}s:28:\"restaurant-menu-third-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:52:\"smartcontent/restaurant-menu-third-screen/slide1.png\";}}s:11:\"shoes-store\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide3.png\";}}s:20:\"supermarket-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide3.png\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide4.png\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide5.png\";}}s:16:\"travel-insurance\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"smartcontent/travel-insurance/slide1.png\";}}s:12:\"cryptoslider\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"cryptoslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"cryptoslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"cryptoslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"cryptoslider/slide4.jpg\";}}s:16:\"immersion_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";}}s:19:\"immersion-mountains\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";}}s:17:\"immersion-product\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";}}s:16:\"immersion-design\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";}}s:21:\"immersion-photography\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";}}s:14:\"immersion-grid\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";}}s:11:\"funkyslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"funkyslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"funkyslider/slide3.jpg\";}}s:14:\"clearview_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";}}s:16:\"clearview_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";}}s:17:\"clearview_mission\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";}}s:17:\"clear-view-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"clear-view-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"clear-view-slider/slide3.jpg\";}}s:15:\"clear-view-news\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";}}s:18:\"clear-view-clients\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";}}s:18:\"clear-view-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";}}s:22:\"clear-view-single-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";}}s:24:\"clear-view-single-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";}}s:23:\"clear-view-single-media\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";}}s:22:\"clear-view-single-more\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";}}s:25:\"clear-view-single-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";}}s:16:\"cleanlandingpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";}}s:8:\"clearcut\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:19:\"clearcut/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:19:\"clearcut/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:19:\"clearcut/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:19:\"clearcut/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:19:\"clearcut/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:19:\"clearcut/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:19:\"clearcut/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:19:\"clearcut/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:20:\"clearcut/slide10.jpg\";}}s:17:\"wonderstruck_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";}}s:19:\"wonderstruck_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";}}s:18:\"wonderstruck_about\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"wonderstruck_about/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"wonderstruck_about/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"wonderstruck_about/slide4.jpg\";}}s:18:\"wonderstruck-works\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";}}s:20:\"wonderstruck-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";}}s:11:\"bubblemorph\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"bubblemorph/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"bubblemorph/slide3.jpg\";}}s:15:\"distortionaddon\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"distortionaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"distortionaddon/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"distortionaddon/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"distortionaddon/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"distortionaddon/slide6.jpg\";}}s:9:\"clubflyer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";}}s:15:\"paintbrushaddon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"paintbrushaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"paintbrushaddon/slide3.jpg\";}}s:15:\"parallax_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";}}s:16:\"parallax_content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";}}s:15:\"parallax_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";}}s:12:\"le-chef-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";}}s:14:\"le-chef-header\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"le-chef-header/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"le-chef-header/slide3.jpg\";}}s:18:\"le-chef-philosophy\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";}}s:12:\"le-chef-food\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";}}s:16:\"le-chef-la-carte\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";}}s:14:\"le-chef-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"le-chef-footer/slide1.jpg\";}}s:20:\"news-magazine-slider\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"news-magazine-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"news-magazine-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"news-magazine-slider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"news-magazine-slider/slide4.jpg\";}}s:18:\"real-estate-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"real-estate-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"real-estate-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"real-estate-slider/slide3.jpg\";}}s:14:\"fashion-header\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"fashion-header/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"fashion-header/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"fashion-header/slide3.jpg\";}}}}', 'no');
