<?php
if ( ! class_exists( 'inspiry_contact_list' ) ) {
	class inspiry_contact_list extends WP_Widget {
		public function __construct() {
			$widget_ops = array(
				'classname'   => 'inspiry_contact_list',
				'description' => esc_html__( 'Contact Details List.', 'inspiry-builderpress' )
			);
			parent::__construct( 'inspiry_contact_list', esc_html__( 'BuilderPress - Contact Us', 'inspiry-builderpress' ), $widget_ops );
		}


		public function widget( $args, $instance ) {

			if ( ! isset( $args['widget_id'] ) ) {
				$args['widget_id'] = $this->id;
			}

			$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : esc_html__( 'Contact Us', 'inspiry-builderpress' );

			$phone   = ( ! empty( $instance['phone'] ) ) ? $instance['phone'] : '';
			$fax     = ( ! empty( $instance['fax'] ) ) ? $instance['fax'] : '';
			$email   = ( ! empty( $instance['email'] ) ) ? $instance['email'] : '';
			$address = ( ! empty( $instance['address'] ) ) ? $instance['address'] : '';

			/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
			$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

			echo( $args['before_widget'] );

			if ( $title ) {
				echo( $args['before_title'] . esc_html( $title ) . $args['after_title'] );
			}

			echo( "<ul>" );

			if ( ! empty( $phone ) ) {
				?>
				<li class="phone"><?php echo esc_html( $phone ); ?></li><?php
			}

			if ( ! empty( $fax ) ) {
				?>
				<li class="fax"><?php echo esc_html( $fax ); ?></li><?php
			}

			if ( ! empty( $email ) ) {
				?>
				<li class="email"><a
					href="mailto:<?php echo antispambot( $email ); ?>"><?php echo antispambot( $email ); ?></a>
				</li><?php
			}


			if ( ! empty( $address ) ) {
				$allow_address_html = array(
					'a'      => array(
						'href'  => array(),
						'title' => array()
					),
					'br'     => array(),
					'em'     => array(),
					'strong' => array(),
				);
				?>
				<li class="location"><?php echo wp_kses( ( $address ), $allow_address_html ); ?></li>
				<?php
			}

			echo( "</ul>" );

			echo( $args['after_widget'] );


		}

		public function form( $instance ) {
			$title   = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
			$phone   = isset( $instance['phone'] ) ? esc_attr( $instance['phone'] ) : '';
			$fax     = isset( $instance['fax'] ) ? esc_attr( $instance['fax'] ) : '';
			$email   = isset( $instance['email'] ) ? esc_attr( $instance['email'] ) : '';
			$address = isset( $instance['address'] ) ? esc_attr( $instance['address'] ) : '';
			?>

			<p>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'inspiry-builderpress' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
				       value="<?php echo esc_attr( $title ); ?>"/>
			</p>


			<p>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>"><?php esc_html_e( 'Phone:', 'inspiry-builderpress' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'phone' ) ); ?>" type="text"
				       value="<?php echo esc_attr( $phone ); ?>"/>
			</p>


			<p>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'fax' ) ); ?>"><?php esc_html_e( 'Fax:', 'inspiry-builderpress' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'fax' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'fax' ) ); ?>" type="text"
				       value="<?php echo esc_attr( $fax ); ?>"/>
			</p>


			<p>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>"><?php esc_html_e( 'Email:', 'inspiry-builderpress' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'email' ) ); ?>" type="text"
				       value="<?php echo esc_attr( $email ); ?>"/>
			</p>


			<p>
				<label
					for="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>"><?php esc_html_e( 'Address:', 'inspiry-builderpress' ); ?></label>
				<?php
				$allow_textarea_html = array(
					'a'      => array(
						'href'  => array(),
						'title' => array()
					),
					'br'     => array(),
					'em'     => array(),
					'strong' => array(),
				);
				?>
				<textarea class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'address' ) ); ?>"
				          id="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>" cols="30"
				          rows="5"><?php echo wp_kses( $address, $allow_textarea_html ); ?></textarea>
			</p>


			<?php
		}

		public function update( $new_instance, $old_instance ) {
			$allow_instance_html = array(
				'a'      => array(
					'href'  => array(),
					'title' => array()
				),
				'br'     => array(),
				'em'     => array(),
				'strong' => array(),
			);

			$instance            = $old_instance;
			$instance['title']   = sanitize_text_field( $new_instance['title'] );
			$instance['phone']   = sanitize_text_field( $new_instance['phone'] );
			$instance['fax']     = sanitize_text_field( $new_instance['fax'] );
			$instance['email']   = sanitize_text_field( $new_instance['email'] );
			$instance['address'] = wp_kses( ( $new_instance['address'] ), $allow_instance_html );

			return $instance;
		}


	}


}

