<?php
if ( ! class_exists( 'inspiry_builderpress_services' ) ) {
	class inspiry_builderpress_services extends WP_Widget {
		public function __construct() {
			$widget_ops = array(
				'classname'   => 'inspiry_builderpress_services',
				'description' => esc_html__( 'Builderpress Services List.', 'inspiry-builderpress' )
			);
			parent::__construct( 'inspiry_builderpress_services', esc_html__( 'BuilderPress - Services', 'inspiry-builderpress' ), $widget_ops );
		}


		public function widget( $args, $instance ) {

			if ( ! isset( $args['widget_id'] ) ) {
				$args['widget_id'] = $this->id;
			}

			$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : esc_html__( 'Services', 'inspiry-builderpress' );

			/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
			$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );


			$services_query = new WP_Query( apply_filters( 'widget_posts_args', array(
				'post_type'           => 'service',
				'post_status'         => 'publish',
				'ignore_sticky_posts' => true,
				'posts_per_page'      => - 1
			) ) );

			if ( $services_query->have_posts() ) :
				echo ( $args['before_widget'] );
				if ( $title ) {
					echo ( $args['before_title'] . esc_html( $title ) . $args['after_title'] );
				}
				?>
				<ul>
					<?php while ( $services_query->have_posts() ) : $services_query->the_post(); ?>
						<li>
							<a class="list-heading" href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a>
						</li>
					<?php endwhile; ?>
				</ul>
				<?php
				echo ( $args['after_widget'] );

				// Reset the global $the_post as this query will have stomped on it
				wp_reset_postdata();

			endif;


		}

		public function form( $instance ) {
			$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
			?>

			<p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'inspiry-builderpress' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
				       name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
				       value="<?php echo esc_attr( $title ); ?>"/></p>


			<?php
		}

		public function update( $new_instance, $old_instance ) {
			$instance          = $old_instance;
			$instance['title'] = sanitize_text_field( $new_instance['title'] );

			return $instance;
		}


	}


}

