<?php
/*-----------------------------------------------------------------------------------*/
/*	Team member carousel shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_team_shortcodes' ) ) {
	function inspiry_team_shortcodes( $atts, $content = null ) {

		$theme_color = get_theme_mod( 'inspiry-color-schemes' );
		$social_hover_color ='';
		if(!empty($theme_color)){
			$social_hover_color = $theme_color;
		}else{
			$social_hover_color = '#ffd800';
		}
		$atts = shortcode_atts(
			array(
				"inspiry_class"           => '',
				"team_columns"            => 'col-sm-6',
				"text_position"           => 'text-center',
				"team-heading-color"      => '',
				'team-designation-color'  => '',
				"team-text-color"         => '',
				"team-social-color"       => '#989898',
				"team-social-hover-color" => $social_hover_color,
			), $atts
		);

		$args          = array(
			'post_type'      => 'members',
			'posts_per_page' => 15,
		);
		$get_col_class = $atts['team_columns'];

		$cat_count      = 0;
		$count_clearfix = 1;

		$team_query = new WP_Query( $args );

		$team_structure = '';
		if ( $team_query->have_posts() ):
			$team_structure .= '<div class="wrapper-team common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
			$team_structure .= '<div class="row">';
			while ( $team_query->have_posts() ):

				$team_query->the_post();
				$team_structure .= '<div class="wrapper-member ' . esc_attr( $atts['team_columns'] ) . '">';
				$team_structure .= '<div class="single-member ' . esc_attr( $atts['text_position'] ) . '">';
				$team_structure .= get_the_post_thumbnail( get_the_ID(), 'inspiry_image_size_720_540' );
				$team_structure .= '<h3 style="color: ' . esc_attr( $atts['team-heading-color'] ) . '">' . get_the_title() . '</h3>';
				$member_designation = get_post_meta( get_the_ID(), 'bp-member-designation', true );
				$member_twitter     = get_post_meta( get_the_ID(), 'bp-member-twitter', true );
				$member_facebook    = get_post_meta( get_the_ID(), 'bp-member-facebook', true );
				$member_google      = get_post_meta( get_the_ID(), 'bp-member-google', true );
				$member_youtube     = get_post_meta( get_the_ID(), 'bp-member-youtube', true );
				$member_instagram   = get_post_meta( get_the_ID(), 'bp-member-instagram', true );
				$team_structure .= '<span class="designation" style="color: ' . esc_attr( $atts['team-designation-color'] ) . '">' . esc_html( $member_designation ) . '</span>';

				$team_social_color       = esc_attr( $atts['team-social-color'] );
				$team_social_hover_color = esc_attr( $atts['team-social-hover-color'] );

				if ( ! empty( $member_twitter ) || ! empty( $member_facebook ) || ! empty( $member_google ) || ! empty( $member_youtube ) || ! empty( $member_instagram ) ) {
					$team_structure .= '<ul class="member-social-icons" onmouseover="">';
					if ( ! empty( $team_social_hover_color ) ) {
						$mouseHover = " onmouseover=\" this.style.color = '  $team_social_hover_color ';\"  ";
					}
					if ( ! empty( $team_social_color ) ) {
						$mouseNormal = " onmouseout=\" this.style.color = '  $team_social_color ';\"";
					}
					if ( ! empty( $member_twitter ) ) {
						$team_structure .= '<li><a style="color:' . $team_social_color . '" href=" ' . esc_url( $member_twitter ) . '"';
						if ( ! empty( $mouseHover ) ) {
							$team_structure .= $mouseHover;
						}
						if ( ! empty( $mouseNormal ) ) {
							$team_structure .= $mouseNormal;
						}
						$team_structure .= '><i class="fa fa-twitter"></i></a></li>';
					}

					if ( ! empty( $member_facebook ) ) {
						$team_structure .= '<li><a style="color:' . $team_social_color . '" href=" ' . esc_url( $member_facebook ) . '"';
						if ( ! empty( $mouseHover ) ) {
							$team_structure .= $mouseHover;
						}
						if ( ! empty( $mouseNormal ) ) {
							$team_structure .= $mouseNormal;
						}
						$team_structure .= '><i class="fa fa-facebook"></i></a></li>';
					}

					if ( ! empty( $member_google ) ) {
						$team_structure .= '<li><a style="color:' . $team_social_color . '" href=" ' . esc_url( $member_google ) . '"';
						if ( ! empty( $mouseHover ) ) {
							$team_structure .= $mouseHover;
						}
						if ( ! empty( $mouseNormal ) ) {
							$team_structure .= $mouseNormal;
						}
						$team_structure .= '><i class="fa fa-google-plus"></i></a></li>';
					}

					if ( ! empty( $member_youtube ) ) {
						$team_structure .= '<li><a style="color:' . $team_social_color . '" href=" ' . esc_url( $member_youtube ) . '"';
						if ( ! empty( $mouseHover ) ) {
							$team_structure .= $mouseHover;
						}
						if ( ! empty( $mouseNormal ) ) {
							$team_structure .= $mouseNormal;
						}
						$team_structure .= '><i class="fa fa-youtube-play"></i></a></li>';
					}

					if ( ! empty( $member_instagram ) ) {
						$team_structure .= '<li><a style="color:' . $team_social_color . '" href=" ' . esc_url( $member_instagram ) . '"';
						if ( ! empty( $mouseHover ) ) {
							$team_structure .= $mouseHover;
						}
						if ( ! empty( $mouseNormal ) ) {
							$team_structure .= $mouseNormal;
						}
						$team_structure .= '><i class="fa fa-instagram"></i></a></li>';
					}

					$team_structure .= '</ul>';
				}
				$team_structure .= '<p style="color: ' . esc_attr( $atts['team-text-color'] ) . '">' . get_the_content() . '</p>';
				$team_structure .= '</div>';
				$team_structure .= '</div>';

				$cat_count ++;

				if ( $get_col_class == 'col-sm-6' ) {
					if ( $count_clearfix % 2 == 0 ) {

						$team_structure .= '<div class="clearfix"></div>';

					}
				} elseif ( $get_col_class == 'col-sm-6 col-md-4' ) {
					if ( $count_clearfix % 3 == 0 ) {

						$team_structure .= '<div class="clearfix visible-md visible-lg"></div>';

					}
					if ( $count_clearfix % 2 == 0 ) {

						$team_structure .= '<div class="clearfix visible-sm"></div>';

					}
				} elseif ( $get_col_class == 'col-sm-6 col-md-3' ) {
					if ( $count_clearfix % 4 == 0 ) {

						$team_structure .= '<div class="clearfix visible-md visible-lg"></div>';

					}
					if ( $count_clearfix % 2 == 0 ) {

						$team_structure .= '<div class="clearfix visible-sm"></div>';

					}
				}
				$count_clearfix ++;
			endwhile;
			wp_reset_postdata();

			$team_structure .= '</div>';
			$team_structure .= '</div>';

		endif;

		return $team_structure;


	}

	add_shortcode( 'inspiry_team', 'inspiry_team_shortcodes' );
}


/*-----------------------------------------------------------------------------------*/
/*	Mapper Function
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'inspiry_vc_team_wrapper' ) ) {
	function inspiry_vc_team_wrapper() {
		vc_map( array(
				"name"     => esc_html__( "Team Members", "builderpress-pack" ),
				"base"     => "inspiry_team",
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(


					array(
						"type"       => "dropdown",
						"heading"    => esc_html__( "Select columns", 'builderpress-pack' ),
						"param_name" => "team_columns",
						"value"      => array(
							esc_html__( 'two columns', 'builderpress-pack' )   => 'col-sm-6',
							esc_html__( 'three columns', 'builderpress-pack' ) => 'col-sm-6 col-md-4',
							esc_html__( 'four columns', 'builderpress-pack' )  => 'col-sm-6 col-md-3',
						),


					),
					array(
						"type"        => "dropdown",
						"heading"     => esc_html__( "Select position of contents", "builderpress-pack" ),
						"param_name"  => "text_position",
						"admin_label" => true,
						"value"       => array(
							esc_html__( 'Center', 'builderpress-pack' ) => 'text-center',
							esc_html__( 'Left', 'builderpress-pack' )   => 'text-left',
							esc_html__( 'Right', 'builderpress-pack' )  => 'text-right',
						),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Heading Color", "builderpress-pack" ),
						"param_name"  => "team-heading-color",
						"description" => esc_html__( "Default color is #1a1a1a", "builderpress-pack" ),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Designation Color", "builderpress-pack" ),
						"param_name"  => "team-designation-color",
						"description" => esc_html__( "Default color is #808080", "builderpress-pack" ),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Text Color", "builderpress-pack" ),
						"param_name"  => "team-text-color",
						"description" => esc_html__( "Default color is #909090", "builderpress-pack" ),
					),

					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Social Icons Color", "builderpress-pack" ),
						"param_name"  => "team-social-color",
						"description" => esc_html__( "Default color is #1a1a1a", "builderpress-pack" ),
					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Social Icons Hover Color", "builderpress-pack" ),
						"param_name"  => "team-social-hover-color",
						"description" => esc_html__( "Default color is #ffd800", "builderpress-pack" ),
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),

				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_team_wrapper' );
}