<?php
/*-----------------------------------------------------------------------------------*/
/*	Shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_section_icon_shortcodes' ) ) {
	function inspiry_section_icon_shortcodes( $atts, $content = null ) {
		$atts         = shortcode_atts(
			array(

				'img_src'          => '',
				'icon_position'    => 'pulley-center',
				'top_position'     => '-35',
				'container_height' => '60',
			), $atts
		);
		$section_icon = '<div class="container-icon-pulley common-vc-class " style="height: ' . esc_attr( $atts['container_height'] ) . 'px">';
		$image_src    = wp_get_attachment_url( $atts['img_src'] );
		if ( ! empty( $image_src ) ) {
			$section_icon .= '<span class="pulley ' . esc_attr( $atts['icon_position'] ) . '" style="top:' . esc_attr( $atts['top_position'] ) . 'px"> <img src= ' . esc_url( wp_get_attachment_url( $atts['img_src'] ) ) . ' alt = ' . esc_attr( get_the_title( $atts['img_src'] ) ) . '> </span>';
		} else {
			$section_icon .= '<span class="pulley ' . esc_attr( $atts['icon_position'] ) . '" style="top:' . esc_attr( $atts['top_position'] ) . 'px"> <img src= ' . esc_url( get_template_directory_uri() . '/images/icons/section-icon-hook.svg' ) . ' alt = ' . esc_attr( get_the_title( $atts['img_src'] ) ) . '> </span>';

		}
		$section_icon .= "</div>";

		return $section_icon;
	}

	add_shortcode( 'inspiry_section_icon', 'inspiry_section_icon_shortcodes' );
}


/*-----------------------------------------------------------------------------------*/
/*	Mapper function
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'inspiry_vc_pulley_icon' ) ) {
	function inspiry_vc_pulley_icon() {
		vc_map( array(
				"name"        => esc_html__( "Section Top Icon", "builderpress-pack" ),
				"base"        => "inspiry_section_icon",
				"weight"      => 100,
				"category"    => esc_html__( "BuilderPress", "builderpress-pack" ),
				"description" => esc_html__( 'Icon to display on the top of the section', 'builderpress-pack' ),
				"params"      => array(
					array(
						"type"        => "textfield",
						"value"       => "60",
						"heading"     => esc_html__( "Height of container", "builderpress-pack" ),
						"param_name"  => "container_height",
						"description" => esc_html__( "Enter pixel number to set container height. default is 60px.", "builderpress-pack" )
					),


					array(
						"type"        => "dropdown",
						"heading"     => esc_html__( "Select icon position", "builderpress-pack" ),
						"param_name"  => "icon_position",
						"description" => esc_html__( "Select icon position 'left','center','right'.", "builderpress-pack" ),
						"value"       => array(
							esc_html__( 'Center', 'builderpress-pack' ) => 'pulley-center',
							esc_html__( 'Left', 'builderpress-pack' )   => 'pulley-left',
							esc_html__( 'Right', 'builderpress-pack' )  => 'pulley-right',
						),
					),
					array(
						"type"        => "textfield",
						"value"       => "-35",
						"heading"     => esc_html__( "Icon position from top", "builderpress-pack" ),
						"param_name"  => "top_position",
						"description" => esc_html__( "Enter pixel number to adjust top to bottom position.", "builderpress-pack" )
					),
					array(
						"type"        => "attach_image",
						"class"       => "",
						"heading"     => esc_html__( "Image icon", "builderpress-pack" ),
						"param_name"  => "img_src",
						"description" => esc_html__( "Default Section Hook Icon Will be displayed if no image is selected", "builderpress-pack" )
					),

				)
			)
		);
	}

	add_action( 'vc_before_init', 'inspiry_vc_pulley_icon' );
}
?>