<?php
/*-----------------------------------------------------------------------------------*/
/*	Recent Posts Shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_recent_posts_shortcodes' ) ) {
	function inspiry_recent_posts_shortcodes( $atts, $content = null ) {
		$atts                     = shortcode_atts(
			array(
				"inspiry_class"             => '',
				"posts-heading-color"       => '',
				"posts-heading-hover-color" => '',
				"posts-text-color"          => '#808080',
				"number_of_posts"           => 3,
			), $atts
		);
		$number_of_posts          = esc_html( $atts['number_of_posts'] );
		$post_heading_color       = esc_attr( $atts['posts-heading-color'] );
		$post_heading_hover_color = esc_attr( $atts['posts-heading-hover-color'] );

		$args            = array(
			'post_type'           => 'post',
			'meta_query'          => array( array( 'key' => '_thumbnail_id' ) ),
			'posts_per_page'      => $number_of_posts,
			'ignore_sticky_posts' => 1

		);
		$posts_query     = new WP_Query( $args );
		$posts_structure = '';
		if ( $posts_query->have_posts() ):
			$posts_structure .= '<div class="recent-blog common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
			$posts_structure .= '<div class="row">';

			while ( $posts_query->have_posts() ):
				$posts_query->the_post();

				$posts_structure .= '<div class="col-md-4">';
				$posts_structure .= '<div class="wrapper-recent-single">';
				$posts_structure .= '<a class="wrapper-recent-thumbs" href="' . get_the_permalink() . '">' . get_the_post_thumbnail( get_the_ID() ) . '</a>';
				if ( ! empty( $post_heading_hover_color ) ) {
					$mouseHover = " onmouseover=\" this.style.color = '  $post_heading_hover_color ';\"  ";
				}
				if ( ! empty( $post_heading_color ) ) {
					$mouseNormal = " onmouseout=\" this.style.color = '  $post_heading_color ';\"";
				}
				$posts_structure .= '<h3>';
				$posts_structure .= '<a style="color:' . $post_heading_color . ' " href="' . get_the_permalink() . '"';
				if ( ! empty( $mouseHover ) ) {
					$posts_structure .= $mouseHover;
				}
				if ( ! empty( $mouseNormal ) ) {
					$posts_structure .= $mouseNormal;
				}
				$posts_structure .= '>' . get_the_title() . '</a>';
				$posts_structure .= '</h3>';
				$posts_structure .= '<p style="color: ' . $atts['posts-text-color'] . '">' . wp_trim_words( get_the_excerpt(), 20, '...' ) . '</p>';

				$posts_structure .= '</div>';
				$posts_structure .= '</div>';

			endwhile;
			wp_reset_postdata();
			$posts_structure .= '</div>';
			$posts_structure .= '</div>';

		endif;

		return $posts_structure;

	}

	add_shortcode( 'inspiry_recent_posts', 'inspiry_recent_posts_shortcodes' );
}


/*-----------------------------------------------------------------------------------*/
/*	mapper functions
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_recent_posts_wrapper' ) ) {
	function inspiry_vc_recent_posts_wrapper() {
		vc_map( array(
				"name"        => esc_html__( "Recent Posts", "builderpress-pack" ),
				"base"        => "inspiry_recent_posts",
				"category"    => esc_html__( "BuilderPress", "builderpress-pack" ),
				"description" => esc_html__( "Show posts only that have post thumbnail", "builderpress-pack" ),
				"params"      => array(

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( 'Number Of Post To Be Shown', 'builderpress-pack' ),
						"param_name"  => "number_of_posts",
						"description" => esc_html__( 'Default value is 3', 'builderpress-pack' ),

					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Heading Color", "builderpress-pack" ),
						"param_name"  => "posts-heading-color",
						"description" => esc_html__( "default color is #1a1a1a", "builderpress-pack" ),
					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Heading Hover Color", "builderpress-pack" ),
						"param_name"  => "posts-heading-Hover-color",
						"description" => esc_html__( "default color is #ffd800", "builderpress-pack" ),
					),
					array(
						"type"        => "colorpicker",
						"heading"     => esc_html__( "Text Color", "builderpress-pack" ),
						"param_name"  => "posts-text-color",
						"description" => esc_html__( "default color is #808080", "builderpress-pack" ),
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),

				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_recent_posts_wrapper' );
}