<?php
/*-----------------------------------------------------------------------------------*/
/*	main slider shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_home_main_slider_parent_shortcodes' ) ) {
	function inspiry_home_main_slider_parent_shortcodes( $atts, $content = null ) {
		$atts             = shortcode_atts(
			array(
				"inspiry_class" => '',
			), $atts
		);
		$slider_structure = '<div class="wrapper-main-slider slider-var1 common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$slider_structure .= '<div class="main-slider owl-carousel owl-theme">';
		$slider_structure .= do_shortcode( $content );
		$slider_structure .= '</div>';
		$slider_structure .= '</div>';

		return $slider_structure;
	}

	add_shortcode( 'inspiry_home_main_slider', 'inspiry_home_main_slider_parent_shortcodes' );
}

if ( ! function_exists( 'inspiry_home_main_slider_child_shortcodes' ) ) {
	function inspiry_home_main_slider_child_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"inspiry_class"           => '',
				"inspiry_slider_image"    => '',
				"inspiry_slider_heading"  => '',
				"inspiry_slider_text"     => '',
				"inspiry_slider_btn_text" => '',
				"slider_btn_link"         => '',
				"inspiry_slider_icon"     => '',

			), $atts
		);

		$slider_structure = '<div class="' . esc_attr( $atts['inspiry_class'] ) . '">';
		$slider_structure .= '<div class="slide-content">';
		$image_src        = wp_get_attachment_image_src( $atts['inspiry_slider_image'], '', false );
		$slider_icon_atts = $atts['inspiry_slider_icon'];
		$slider_icon      = wp_get_attachment_url( $slider_icon_atts );

		$slider_structure .= '<img src="' . esc_url( $image_src[0] ) . '" width= "' . esc_attr( $image_src[1] ) . '" height="' . esc_attr( $image_src[2] ) . '"  alt="' . esc_html( $atts['inspiry_slider_heading'] ) . '">';
		$slider_structure .= '<div class="slider-detail">';
		$slider_structure .= '<div class="container custom-container-slider">';
		if ( ! empty( $slider_icon_atts ) ) {
			$slider_structure .= '<div class="slider-detail-inner content-animate icon-padding">';
			$slider_structure .= '<span class="slide-icon"><img src="' . esc_url( $slider_icon ) . '" alt="' . esc_attr(get_the_title( $atts['inspiry_slider_icon'] )) . '"></span>';

		} else {
			$slider_structure .= '<div class="slider-detail-inner content-animate">';

		}
		$slider_structure .= '<h1>' . esc_html( $atts['inspiry_slider_heading'] ) . '</h1>';
		$slider_structure .= '<div style="overflow: hidden">';
		$slider_structure .= '<p>' . esc_html( $atts['inspiry_slider_text'] ) . '</p>';
		$slider_structure .= '</div>';
		$btn_link_slider  = vc_build_link( $atts['slider_btn_link'] );
		$link_target      = $btn_link_slider['target'];
		$link_target_atts = '';
		if ( ! empty( $link_target ) ) {
			$link_target_atts = 'target = "' . esc_attr( $link_target ) . '"';
		}
		$btn_link_slider_var = array_filter( $btn_link_slider );
		if ( ! empty( $btn_link_slider_var ) ) {
			$slider_structure .= '<a class="bp-button bp-button-plain button-yellow button-slider" href="' . esc_url( $btn_link_slider['url'] ) . '" ' . $link_target_atts . ' >' . esc_html( $btn_link_slider['title'] ) . '</a>';
		}
		$slider_structure .= '</div>';
		$slider_structure .= '</div>';
		$slider_structure .= '</div>';
		$slider_structure .= '</div>';
		$slider_structure .= '</div>';

		return $slider_structure;
	}

	add_shortcode( 'inspiry_home_main_slider_child', 'inspiry_home_main_slider_child_shortcodes' );
}
/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_home_main_slider_wrapper' ) ) {
	function inspiry_vc_home_main_slider_wrapper() {
		vc_map( array(
				"name"            => esc_html__( "Home Main Slider", "builderpress-pack" ),
				"base"            => "inspiry_home_main_slider",
				"as_parent"       => array( 'only' => 'inspiry_home_main_slider_child' ),
				"category"        => esc_html__( "BuilderPress", "builderpress-pack" ),
				"content_element" => true,
				"is_container"    => true,
				"js_view"         => 'VcColumnView',

				"params" => array(
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),

				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_home_main_slider_wrapper' );
}

if ( ! function_exists( 'inspiry_vc_home_main_slider_child_wrapper' ) ) {
	function inspiry_vc_home_main_slider_child_wrapper() {
		vc_map( array(
				"name"     => esc_html__( "Home Main Slide Single", "builderpress-pack" ),
				"base"     => "inspiry_home_main_slider_child",
				"as_child" => array( 'only' => 'inspiry_home_main_slider' ),
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(


					array(
						"type"        => "attach_image",
						"heading"     => esc_html__( "Slide Image", "builderpress-pack" ),
						"param_name"  => 'inspiry_slider_image',
						"description" => esc_html__( 'Recommended Image Size 1970x775', 'builderpress-pack' )
					),

					array(
						"type"        => "attach_image",
						"heading"     => esc_html__( "Slide icon", "builderpress-pack" ),
						"param_name"  => 'inspiry_slider_icon',
						"description" => esc_html__( 'Select SVG/png/jpg icon', 'builderpress-pack' )
					),

					array(
						"type"       => "textfield",
						"heading"    => esc_html__( "Slide Heading", "builderpress-pack" ),
						"param_name" => 'inspiry_slider_heading',
					),

					array(
						"type"       => "textarea",
						"heading"    => esc_html__( "Slide Text", "builderpress-pack" ),
						"param_name" => 'inspiry_slider_text',
					),

					array(
						"type"       => "vc_link",
						"heading"    => esc_html__( "Select Button URL and Title", "builderpress-pack" ),
						"param_name" => "slider_btn_link",
					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),

				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_home_main_slider_child_wrapper' );
}

