<?php
/*-----------------------------------------------------------------------------------*/
/*	google map shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_google_map_shortcodes' ) ) {
	function inspiry_google_map_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"inspiry_class" => '',
				"map_height"    => 600,
				"map_latitude"  => '',
				"map_longitude" => '',
				"map_zoom"      => 14,
				"map_marker"    => '',
				"info_window"   => '',

			), $atts
		);


		$map_lati  = get_theme_mod( 'inspiry_google_maps_lati' );
		$map_longi = get_theme_mod( 'inspiry_google_maps_longi' );


		$map_marker_vc = $atts['map_marker'];

		if ( ! empty( $map_marker_vc ) ) {
			$map_marker = '\'' . esc_url( wp_get_attachment_url( $map_marker_vc ) ) . '\'';

		} else {
			$map_marker = '\'' . get_template_directory_uri() . '/images/icons/marker.png' . '\'';
		}

		$map_height   = esc_html( $atts['map_height'] );
		$map_lati_vc  = esc_html( $atts['map_latitude'] );
		$map_longi_vc = esc_html( $atts['map_longitude'] );
		$map_zoom_vc  = esc_html( $atts['map_zoom'] );
		$info_window  = esc_html( $atts['info_window'] );

		if ( ! empty( $map_lati_vc ) && ! empty( $map_longi_vc ) ) {
			$google_map_lati  = $map_lati_vc;
			$google_map_longi = $map_longi_vc;
		} else {
			$google_map_lati  = $map_lati;
			$google_map_longi = $map_longi;
		}


		$map_styles = '[

                            {
                                "elementType": "geometry",
                                "stylers": [
                                    {
                                        "color": "#f5f5f5"
                                    }
                                ]
                            },
                            {
                                "elementType": "labels.icon",
                                "stylers": [
                                    {
                                        "visibility": "off"
                                    }
                                ]
                            },
                            {
                                "elementType": "labels.text.fill",
                                "stylers": [
                                    {
                                        "color": "#616161"
                                    }
                                ]
                            },
                            {
                                "elementType": "labels.text.stroke",
                                "stylers": [
                                    {
                                        "color": "#f5f5f5"
                                    }
                                ]
                            },
                            {
                                "featureType": "administrative.land_parcel",
                                "elementType": "labels.text.fill",
                                "stylers": [
                                    {
                                        "color": "#bdbdbd"
                                    }
                                ]
                            },
                            {
                                "featureType": "poi",
                                "elementType": "geometry",
                                "stylers": [
                                    {
                                        "color": "#eeeeee"
                                    }
                                ]
                            },
                            {
                                "featureType": "poi",
                                "elementType": "labels.text.fill",
                                "stylers": [
                                    {
                                        "color": "#757575"
                                    }
                                ]
                            },
                            {
                                "featureType": "poi.park",
                                "elementType": "geometry",
                                "stylers": [
                                    {
                                        "color": "#e5e5e5"
                                    }
                                ]
                            },
                            {
                                "featureType": "poi.park",
                                "elementType": "labels.text.fill",
                                "stylers": [
                                    {
                                        "color": "#9e9e9e"
                                    }
                                ]
                            },
                            {
                                "featureType": "road",
                                "elementType": "geometry",
                                "stylers": [
                                    {
                                        "color": "#ffffff"
                                    }
                                ]
                            },
                            {
                                "featureType": "road.arterial",
                                "elementType": "labels.text.fill",
                                "stylers": [
                                    {
                                        "color": "#757575"
                                    }
                                ]
                            },
                            {
                                "featureType": "road.highway",
                                "elementType": "geometry",
                                "stylers": [
                                    {
                                        "color": "#dadada"
                                    }
                                ]
                            },
                            {
                                "featureType": "road.highway",
                                "elementType": "labels.text.fill",
                                "stylers": [
                                    {
                                        "color": "#616161"
                                    }
                                ]
                            },
                            {
                                "featureType": "road.local",
                                "elementType": "labels.text.fill",
                                "stylers": [
                                    {
                                        "color": "#9e9e9e"
                                    }
                                ]
                            },
                            {
                                "featureType": "transit.line",
                                "elementType": "geometry",
                                "stylers": [
                                    {
                                        "color": "#e5e5e5"
                                    }
                                ]
                            },
                            {
                                "featureType": "transit.station",
                                "elementType": "geometry",
                                "stylers": [
                                    {
                                        "color": "#eeeeee"
                                    }
                                ]
                            },
                            {
                                "featureType": "water",
                                "elementType": "geometry",
                                "stylers": [
                                    {
                                        "color": "#c9c9c9"
                                    }
                                ]
                            },
                            {
                                "featureType": "water",
                                "elementType": "labels.text.fill",
                                "stylers": [
                                    {
                                        "color": "#9e9e9e"
                                    }
                                ]
                            }

                        ]';


		ob_start();

		$google_maps_api_key = get_theme_mod( 'inspiry_google_maps_api_key' );
		if ( ! empty( $google_maps_api_key ) ) {
			?>
			<div id="map_canvas" class="common-vc-class <?php echo esc_attr( $atts['inspiry_class'] ); ?>"
			     style="height: <?php echo $map_height; ?>px"></div>


			<script type="text/javascript">


				jQuery(function ($) {
					$(document).ready(function () {
						function initialize() {
							var geocoder = new google.maps.Geocoder();
							var map;
							var latlng = new google.maps.LatLng(<?php echo $google_map_lati; ?>, <?php echo $google_map_longi; ?>);
							var myOptions = {
								scrollwheel: false,
								zoom: <?php echo $map_zoom_vc ?>,
								mapTypeId: google.maps.MapTypeId.ROADMAP,
								styles: <?php echo $map_styles;?>
							};


							map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);

							geocoder.geocode({'location': latlng},
								function (results, status) {
									if (status == google.maps.GeocoderStatus.OK) {

//                        var iconBase = //;
										map.setCenter(results[0].geometry.location);
										var marker = new google.maps.Marker({
											map: map,
											position: results[0].geometry.location,
											icon: <?php echo $map_marker;?>,
											animation: google.maps.Animation.DROP,

										});

										<?php
										if(! empty( $info_window )){
										?>
										var contentString = '<div class="info-window"> <?php echo $info_window;?> </div>';


										var infowindow = new google.maps.InfoWindow({
											content: contentString,
											maxWidth: 400,
										});

										marker.addListener('click', function () {
											infowindow.open(map, marker);
										});

										<?php
										}
										?>

									}
									else {
										alert("Geocode was not successful for the following reason: " + status);
									}
								});

						}

						initialize();
					});
				});

			</script>


			<?php


		} else {
			?>
			<div class="container map-api-alert">
				<?php
				$allowed_html = array(
					'strong' => array(),
					'br'     => array(),
					'a'      => array(
						'href'   => array(),
						'target' => array()
					),
				)
				?>
				<p>
					<?php
					echo wp_kses( __( "Please Enter a Valid Google MAP API Key in <strong> Customizer > Misc > Google Map</strong>. <br>If you do not have Google Map API Key, <a href='https://developers.google.com/maps/documentation/javascript/get-api-key' target='_blank'>Click Here</a> to get now.", "builderpress-pack" ), $allowed_html );
					?>
				</p>
			</div>
			<?php
		}

		return ob_get_clean();
	}

	add_shortcode( 'inspiry_google_map', 'inspiry_google_map_shortcodes' );
}


/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'inspiry_vc_google_map' ) ) {
	function inspiry_vc_google_map() {
		vc_map( array(
				"name"     => esc_html__( "Google Map", "builderpress-pack" ),
				"base"     => "inspiry_google_map",
				"class"    => "",
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(


					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Set Height", "builderpress-pack" ),
						"param_name"  => 'map_height',
						"description" => esc_html__( "Default is 600.", "builderpress-pack" )
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Latitude", "builderpress-pack" ),
						"param_name"  => 'map_latitude',
						"description" => esc_html__( "Enter map latitude coordinates (If Field is empty, Customizer > Misc > Google Map default Coordinates  will be apply ) .", "builderpress-pack" )
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Longitude", "builderpress-pack" ),
						"param_name"  => 'map_longitude',
						"description" => esc_html__( "Enter map longitude coordinates (If Field is empty, Customizer > Misc > Google Map default Coordinates  will be apply) .", "builderpress-pack" )
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Address to display in info window", "builderpress-pack" ),
						"param_name"  => 'info_window',
						"description" => esc_html__( "Info window appears by clicking on map marker", "builderpress-pack" )
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Map Zoom", "builderpress-pack" ),
						"param_name"  => 'map_zoom',
						"description" => esc_html__( "Defaule value is 14", "builderpress-pack" )
					),

					array(
						"type"        => "attach_image",
						"heading"     => esc_html__( "Select Icon For Google Map Marker ", "builderpress-pack" ),
						"param_name"  => 'map_marker',
						"description" => esc_html__( "Default theme map marker icon will be displayed if no icon selected", "builderpress-pack" )
					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),


				),

			)
		);
	}

	add_action( 'vc_before_init', 'inspiry_vc_google_map' );
}
