<?php
/*-----------------------------------------------------------------------------------*/
/*	featured projects shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_home_featured_shortcodes' ) ) {
	function inspiry_home_featured_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"inspiry_class" => '',

			), $atts
		);

		$featured_structure = '<div class="featured-section text-center common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$featured_structure .= '<div class="wrapper-slider-featured">';
		$featured_structure .= '<div class="slider-featured owl-carousel">';
		$args           = array(
			'post_type'      => 'project',
			'posts_per_page' => 20,
		);
		$featured_query = new WP_Query( $args );
		if ( $featured_query->have_posts() ):
			while ( $featured_query->have_posts() ):
				$featured_query->the_post();
				$feature_checked  = get_post_meta( get_the_ID(), 'bp-featured', true );
				$feature_location = get_post_meta( get_the_ID(), 'bp-location', true );
				if ( $feature_checked == 1 ) {
					$featured_structure .= '<div>';
					$featured_structure .= '<div class="wrapper-featured-contents">';

					$featured_structure .= get_the_post_thumbnail( get_the_ID(), 'inspiry_image_size_1140_760' );

					$featured_structure .= '<div class="wrapper-button">';
					$featured_structure .= '<a class="bp-button bp-button-plain button-yellow btn-slider" href="' . get_permalink() . '">' . esc_html__( 'view project', 'builderpress-pack' ) . ' <i class="fa fa-chevron-right"></i></a>';
					$featured_structure .= '</div>';

					$featured_structure .= '<div class="wrapper-location">';
					$featured_structure .= '<h3>' . get_the_title() . '</h3>';
					$featured_structure .= '<p class="featured-location">' . esc_html( $feature_location ) . '</p>';
					$featured_structure .= '</div>';

					$featured_structure .= '</div>';
					$featured_structure .= '</div>';
				}
			endwhile;
			wp_reset_postdata();
		endif;
		$featured_structure .= '</div>';
		$featured_structure .= '</div>';
		$featured_structure .= '</div>';

		return $featured_structure;
	}

	add_shortcode( 'inspiry_home_featured', 'inspiry_home_featured_shortcodes' );
}
/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_home_featured_wrapper' ) ) {
	function inspiry_vc_home_featured_wrapper() {
		vc_map( array(
				"name"        => esc_html__( "Featured Projects 1", "builderpress-pack" ),
				"base"        => "inspiry_home_featured",
				"category"    => esc_html__( "BuilderPress", "builderpress-pack" ),
				"description" => esc_html__( 'Display projects that are marked featured (variation 1)', 'builderpress-pack' ),
				"params"      => array(
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),

				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_home_featured_wrapper' );
}