<?php
/*-----------------------------------------------------------------------------------*/
/*	specialties var 2 shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_home_container_specialties_var2_shortcodes' ) ) {
	function inspiry_home_container_specialties_var2_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"inspiry_class"                  => '',
				"inspiry_specialty_main_heading" => '',
				"inspiry_specialty_main_text"    => '',
				"cta_btn_link"                   => '',
			), $atts
		);

		$main_heading = $atts['inspiry_specialty_main_heading'];
		$main_text    = $atts['inspiry_specialty_main_text'];

		$specialty_structure = '<div class="container-special-features common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$specialty_structure .= '<div class="row">';
		$specialty_structure .= '<div class="col-md-4">';
		$specialty_structure .= '<div class="specialty-intro">';
		if ( ! empty( $main_heading ) ) {
			$specialty_structure .= '<h2>' . esc_html( $main_heading ) . '</h2>';
		}
		if ( ! empty( $main_text ) ) {
			$specialty_structure .= '<p>' . esc_html( $main_text ) . '</p>';
		}


		$btn_link = vc_build_link( $atts['cta_btn_link'] );


		$link_target      = $btn_link['target'];
		$link_target_atts = '';
		if ( ! empty( $link_target ) ) {
			$link_target_atts = 'target = "' . esc_attr( $link_target ) . '"';
		}


		$specialty_structure .= '<a class="bp-button bp-button-plain button-yellow" ' . $link_target_atts . '  href="' . esc_url( $btn_link['url'] ) . '">' . esc_html( $btn_link['title'] ) . '</a>';
		$specialty_structure .= '</div>';
		$specialty_structure .= '</div>';

		$specialty_structure .= '<div class="col-md-8">';
		$specialty_structure .= '<div class="row">';
		$specialty_structure .= do_shortcode( $content );
		$specialty_structure .= '</div>';
		$specialty_structure .= '</div>';
		$specialty_structure .= '</div>';
		$specialty_structure .= '</div>';

		return $specialty_structure;
	}

	add_shortcode( 'inspiry_home_specialties_var2', 'inspiry_home_container_specialties_var2_shortcodes' );
}

// Core Specialties var 2 child
if ( ! function_exists( 'inspiry_home_specialty_var2_shortcodes' ) ) {
	function inspiry_home_specialty_var2_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				"inspiry_class"             => '',
				"inspiry_specialty_image"   => '',
				"inspiry_specialty_heading" => '',
				"inspiry_specialty_text"    => '',

			), $atts
		);


		$specialty_structure = '<div class="col-sm-6 text-center">';
		$specialty_structure .= '<div class="wrapper-special-feature theme-box-shadow">';
		$specialty_structure .= '<div class="feature-icon">';
		$specialty_structure .= '<img class="value-icon" src="' . esc_url( wp_get_attachment_url( $atts['inspiry_specialty_image'] ) ) . '" alt="' . esc_attr( $atts['inspiry_specialty_heading'] ) . '">';
		$specialty_structure .= '</div>';
		$specialty_structure .= '<h3>' . esc_html( $atts['inspiry_specialty_heading'] ) . '</h3>';
		$specialty_structure .= '<p>' . esc_html( $atts['inspiry_specialty_text'] ) . '</p>';

		$specialty_structure .= '</div>';
		$specialty_structure .= '</div>';

		return $specialty_structure;

	}

	add_shortcode( 'inspiry_home_specialty_child', 'inspiry_home_specialty_var2_shortcodes' );
}
/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_core_specialty_parent' ) ) {
	function inspiry_vc_core_specialty_parent() {
		vc_map( array(
				"name"            => esc_html__( "Core Expertise 2", "builderpress-pack" ),
				"base"            => "inspiry_home_specialties_var2",
				"weight"          => 94,
				"class"           => "",
				"as_parent"       => array( 'only' => 'inspiry_home_specialty_child' ),
				"category"        => esc_html__( "BuilderPress", "builderpress-pack" ),
				"content_element" => true,
				"is_container"    => true,
				"js_view"         => 'VcColumnView',
				"description"     => esc_html__( 'Core Expertise variation 2', 'builderpress-pack' ),
				"params"          => array(


					array(
						"type"       => "textfield",
						"heading"    => esc_html__( "Heading", "builderpress-pack" ),
						"param_name" => 'inspiry_specialty_main_heading',
					),

					array(
						"type"       => "textarea",
						"heading"    => esc_html__( "Text", "builderpress-pack" ),
						"param_name" => 'inspiry_specialty_main_text',
					),
					array(
						"type"       => "vc_link",
						"heading"    => esc_html__( "Select Button URL and Title", "builderpress-pack" ),
						"param_name" => "cta_btn_link",

					),
					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),


				),

			)
		);
	}

	add_action( 'vc_before_init', 'inspiry_vc_core_specialty_parent' );
}

//Home core specialties var2 child
if ( ! function_exists( 'inspiry_vc_core_specialty_child' ) ) {
	function inspiry_vc_core_specialty_child() {
		vc_map( array(
				"name"     => esc_html__( "Core Expertise 2", "builderpress-pack" ),
				"base"     => "inspiry_home_specialty_child",
				"as_child" => array( 'only' => 'inspiry_home_specialties_var2' ),
				// Use only|except attributes to limit parent (separate multiple values with comma)
				"category" => esc_html__( "BuilderPress", "builderpress-pack" ),
				"params"   => array(


					array(
						"type"       => "attach_image",
						"heading"    => esc_html__( "Core Expertise Image", "builderpress-pack" ),
						"param_name" => 'inspiry_specialty_image',
					),

					array(
						"type"       => "textfield",
						"heading"    => esc_html__( "Core Expertise Heading", "builderpress-pack" ),
						"param_name" => 'inspiry_specialty_heading',
					),

					array(
						"type"       => "textarea",
						"heading"    => esc_html__( "Core Expertise Text", "builderpress-pack" ),
						"param_name" => 'inspiry_specialty_text',
					),

					array(
						"type"        => "textfield",
						"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
						"param_name"  => 'inspiry_class',
						"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
					),

				),
			)
		);
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_core_specialty_child' );
}

