<?php
/*-----------------------------------------------------------------------------------*/
/*	Expertise shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_home_specialties_shortcodes' ) ) {
	function inspiry_home_specialties_shortcodes( $atts, $content = null ) {
		$atts            = shortcode_atts(
			array(
				"inspiry_class"             => '',
				"inspiry_specialty_image"   => '',
				"inspiry_specialty_heading" => '',
				"inspiry_specialty_text"    => '',

			), $atts
		);
		$special_image   = $atts['inspiry_specialty_image'];
		$special_heading = $atts['inspiry_specialty_heading'];
		$special_text    = $atts['inspiry_specialty_text'];

		$specialty_structure = '<div class="wrapper-special-feature common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '" >';
		if ( ! empty( $special_image ) ) {
			$specialty_structure .= '<div class="feature-icon">';
			$specialty_structure .= '<img class="value-icon" src="' . esc_url( wp_get_attachment_url( $special_image ) ) . '" alt="' . esc_attr( $atts['inspiry_specialty_heading'] ) . '">';
			$specialty_structure .= '</div>';
		}

		if ( ! empty( $special_heading ) ) {
			$specialty_structure .= '<h2>' . esc_html( $special_heading ) . '</h2>';
		}
		if ( ! empty( $special_text ) ) {
			$specialty_structure .= '<p>' . esc_html( $special_text ) . '</p>';
		}

		$specialty_structure .= '</div>';

		return $specialty_structure;

	}

	add_shortcode( 'inspiry_home_specialties', 'inspiry_home_specialties_shortcodes' );
}

/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'inspiry_vc_home_specialties_wrapper' ) ) {
	function inspiry_vc_home_specialties_wrapper() {
		vc_map( array(
			"name"        => esc_html__( "Core Expertise 1", "builderpress-pack" ),
			"base"        => "inspiry_home_specialties",
			"weight"      => 95,
			"category"    => esc_html__( "BuilderPress", "builderpress-pack" ),
			"description" => esc_html__( 'Core Expertise variation 1', 'builderpress-pack' ),
			"params"      => array(

				array(
					"type"       => "attach_image",
					"heading"    => esc_html__( "Core Speciality Image", "builderpress-pack" ),
					"param_name" => 'inspiry_specialty_image',
				),

				array(
					"type"       => "textfield",
					"heading"    => esc_html__( "Core Speciality Heading", "builderpress-pack" ),
					"param_name" => 'inspiry_specialty_heading',
				),

				array(
					"type"       => "textarea",
					"heading"    => esc_html__( "Core Speciality Text", "builderpress-pack" ),
					"param_name" => 'inspiry_specialty_text',
				),

				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
					"param_name"  => 'inspiry_class',
					"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )
				),


			),
		) );
	}

	add_action( 'vc_after_init_base', 'inspiry_vc_home_specialties_wrapper' );
}