<?php
/*-----------------------------------------------------------------------------------*/
/*	Contact Form shortcodes
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_contact_form_wrapper_shortcodes' ) ) {
	function inspiry_contact_form_wrapper_shortcodes( $atts, $content = null ) {
		$atts = shortcode_atts(
			array(
				'inspiry_class' => '',
			), $atts
		);

		$content = wpb_js_remove_wpautop( $content, true );

		$form_structure = '<div class="wrapper-form common-vc-class ' . esc_attr( $atts['inspiry_class'] ) . '">';
		$form_structure .= $content;
		$form_structure .= '</div>';


		return $form_structure;

	}

	add_shortcode( 'inspiry_contact_form_wrapper', 'inspiry_contact_form_wrapper_shortcodes' );
}

/*-----------------------------------------------------------------------------------*/
/*	mapper function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'inspiry_vc_contact_form' ) ) {
	function inspiry_vc_contact_form() {

		vc_map( array(
			"name"        => esc_html__( "Contact Form", "builderpress-pack" ),
			"base"        => "inspiry_contact_form_wrapper",
			"class"       => "",
			"category"    => esc_html__( "BuilderPress", "builderpress-pack" ),
			"description" => esc_html__( 'Display Contact Form 7 (Ninja Forms also supported)', 'builderpress-pack' ),
			"params"      => array(

				array(
					"type"       => "textarea_html",
					"holder"     => "div",
					"heading"    => esc_html__( "Enter Contact Form 7 Shortcodes or Ninja Forms Shortcodes", "builderpress-pack" ),
					"param_name" => "content",
				),

				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Extra class name", "builderpress-pack" ),
					"param_name"  => 'inspiry_class',
					"description" => esc_html__( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "builderpress-pack" )

				),

			),

		) );
	}

	add_action( 'vc_before_init', 'inspiry_vc_contact_form' );

}

?>