<?php
if ( ! function_exists( 'builderpress_plugin_meta_boxes' ) ) {
	/**
	 * Configure meta boxes using Meta Box plugin API
	 *
	 * @param $meta_boxes
	 *
	 * @return array
	 */
	function builderpress_plugin_meta_boxes( $meta_boxes ) {

		$portfolio_array = array();
		$portfolio_items = get_posts( array(
			'post_type'      => 'project',
			'posts_per_page' => 500,
		) );

		if ( !empty( $portfolio_items ) ) {
			foreach ( $portfolio_items as $portfolio_item ) {
				$portfolio_array[ $portfolio_item->ID ] = $portfolio_item->post_title;
			}
		}


		$meta_boxes[] = array(
			'id'         => 'bp-project-single-banner',
			'title'      => esc_html__( 'Banner', 'builderpress-pack' ),
			'post_types' => array( 'project','service' ),
			'fields'     => array(

		

				array(
					'name' => esc_html__( 'Banner Title ', 'builderpress-pack' ),
					'id'   => 'bp-projects-banner-in-post-title',
					'type' => 'text',
					'desc' => esc_html__( 'Default title will be displayed if field is empty. ', 'builderpress-pack' ),
				),

				array(
					'name' => esc_html__( 'Title Color ', 'builderpress-pack' ),
					'type' => 'color',
					'id'   => 'bp-project-banner-in-post-title-color',
					'desc' => esc_html__( 'Default color will be applied if no color selected. ', 'builderpress-pack' ),
				),

				array(
					'name' => esc_html__( 'Banner Background Image', 'builderpress-pack' ),
					'type' => 'image_advanced',
					'id'   => 'bp-project-banner-in-post-bg-image',
					'desc' => esc_html__( 'Default background will be displayed if no image selected. ', 'builderpress-pack' ),
				),


			),
		);

		// location meta box
		$meta_boxes[] = array(
			'id'         => 'bp-project-location',
			'title'      => esc_html__( 'Project Details', 'builderpress-pack' ),
			'post_types' => array( 'project' ),
			'fields'     => array(
				array(
					'name'  => esc_html__( 'Mark this Project as Featured ', 'builderpress-pack' ),
					'id'    => 'bp-featured',
					'type'  => 'checkbox',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Location', 'builderpress-pack' ),
					'id'    => 'bp-location',
					'type'  => 'text',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Completion Year', 'builderpress-pack' ),
					'id'    => 'bp-completion-date-text',
					'type'  => 'text',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => wp_kses( __( 'Area/Size (m<sup>2</sup>)', 'builderpress-pack' ), array( 'sup' => array() ) ),
					'id'    => 'bp-area',
					'type'  => 'text',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Gallery Images (1140x760)', 'builderpress-pack' ),
					'id'    => 'bp-slider-image',
					'type'  => 'image_advanced',
					'class' => 'bp-meta-class',
					'desc'  => esc_html__( 'Featured image (1140x760) will be shown on single project page if there is no gallery image.', 'builderpress-pack' ),
				),
			),
		);


		$meta_boxes[] = array(
			'id'         => 'bp-services-meta',
			'title'      => esc_html__( 'Service Details', 'builderpress-pack' ),
			'post_types' => array( 'service' ),
			'fields'     => array(
				array(
					'name'    => esc_html__( 'Select projects related to this service', 'builderpress-pack' ),
					'id'      => 'bp-listed-projects-to-service',
					'type'    => 'checkbox_list',
					'class'   => 'bp-meta-class',
					'options' => $portfolio_array,
				),
				array(
					'name'  => esc_html__( 'Brochures Heading', 'builderpress-pack' ),
					'id'    => 'bp-heading-info-files',
					'type'  => 'text',
					'class' => 'bp-meta-class',
					'desc'  => esc_html__( 'Default heading is "Brochures"', 'builderpress-pack' )
				),
				array(
					'name'  => esc_html__( 'Service Brochures', 'builderpress-pack' ),
					'id'    => 'bp-file-pdf-info',
					'type'  => 'file_advanced',
					'class' => 'bp-meta-class',
					'desc'  => esc_html__( 'PDF file to download as service info', 'builderpress-pack' ),
				),
			),
		);

		$meta_boxes[] = array(
			'id'         => 'bp-team-member',
			'title'      => __( 'Team member extra detail', 'builderpress-pack' ),
			'post_types' => array( 'members' ),
			'fields'     => array(
				array(
					'name'  => esc_html__( 'Member Designation', 'builderpress-pack' ),
					'id'    => 'bp-member-designation',
					'type'  => 'text',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Twitter URL', 'builderpress-pack' ),
					'id'    => 'bp-member-twitter',
					'type'  => 'text',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Facebook URL', 'builderpress-pack' ),
					'id'    => 'bp-member-facebook',
					'type'  => 'text',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Google+ URL', 'builderpress-pack' ),
					'id'    => 'bp-member-google',
					'type'  => 'text',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Youtube URL', 'builderpress-pack' ),
					'id'    => 'bp-member-youtube',
					'type'  => 'text',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Instagram URL', 'builderpress-pack' ),
					'id'    => 'bp-member-instagram',
					'type'  => 'text',
					'class' => 'bp-meta-class',
				),
			),
		);

		$meta_boxes[] = array(
			'id'         => 'bp-page-meta',
			'title'      => esc_html__( 'Page Detail', 'builderpress-pack' ),
			'post_types' => array( 'page' ),
			'fields'     => array(
				array(
					'name'  => esc_html__( 'Top Icon Under Banner', 'builderpress-pack' ),
					'id'    => 'bp-page-top-icon',
					'type'  => 'image_advanced',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Heading', 'builderpress-pack' ),
					'id'    => 'bp-page-heading',
					'type'  => 'text',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Intro Text', 'builderpress-pack' ),
					'id'    => 'bp-page-text',
					'type'  => 'textarea',
					'class' => 'bp-meta-class',
				),
				array(
					'name'  => esc_html__( 'Posts Per Page', 'builderpress-pack' ),
					'id'    => 'bp-page-posts-count',
					'type'  => 'number',
					'std'   => '6',
					'class' => 'bp-meta-class',
					'desc'  => esc_html__( 'Default posts are 6' )
				),
				array(
					'name'    => esc_html__( 'Page Current Layout', 'builderpress-pack' ),
					'id'      => 'bp-page-layout-option',
					'desc'    => esc_html__( 'Select Page current layout on page load', 'builderpress-pack' ),
					'type'    => 'select',
					'std'     => 'full',
					'class'   => 'bp-meta-class inspiry-page-layout',
					'options' => array(
						'full' => 'Full Width',
						'grid' => 'Grid',
					),
				),
			),
		);

		return $meta_boxes;
	}

	add_filter( 'rwmb_meta_boxes', 'builderpress_plugin_meta_boxes' );
}